/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.Message;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class MessageIdValidator
implements ElementValidator {
    private static final String ERROR_MESSAGE = "Message id %s is not unique for method %s with project code %s.";
    private final Map<String, IdDescriptor> messageIdMap = new HashMap<String, IdDescriptor>();

    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        for (ExecutableElement method : elementMethods) {
            Message message = method.getAnnotation(Message.class);
            if (message == null || message.id() <= 0) continue;
            String projectCode = ElementHelper.getProjectCode(element);
            String key = this.createKey(projectCode, message);
            if (this.messageIdMap.containsKey(key)) {
                IdDescriptor idDesc = this.messageIdMap.get(key);
                if (!idDesc.error) {
                    errorMessages.add(ValidationErrorMessage.of(idDesc.method, ERROR_MESSAGE, message.id(), idDesc.method, projectCode));
                    idDesc.error = true;
                }
                errorMessages.add(ValidationErrorMessage.of(method, ERROR_MESSAGE, message.id(), method, projectCode));
                continue;
            }
            this.messageIdMap.put(key, new IdDescriptor(message.id(), method));
        }
        return errorMessages;
    }

    private String createKey(String projectCode, Message message) {
        StringBuilder result = new StringBuilder();
        result.append(projectCode);
        result.append(":");
        result.append(message.id());
        return result.toString();
    }

    private static class IdDescriptor {
        final int id;
        final ExecutableElement method;
        boolean error = false;

        public IdDescriptor(int id, ExecutableElement method) {
            this.id = id;
            this.method = method;
        }
    }
}

