/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.io.Serializable;
import org.jboss.logging.LoggerProviders;
import org.jboss.logging.SerializedLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Logger
implements Serializable {
    private static final long serialVersionUID = 4232175575988879434L;
    private static final String FQCN = Logger.class.getName();
    private final String name;
    private final String resourceBundleName;
    private final String prefix;

    protected Logger(String name, String resourceBundleName, String prefix) {
        this.name = name;
        this.resourceBundleName = resourceBundleName;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public abstract boolean isEnabled(Level var1);

    protected abstract void doLog(Level var1, String var2, Object var3, Object[] var4, Throwable var5);

    protected abstract void doLogf(Level var1, String var2, String var3, Object[] var4, Throwable var5);

    private static String key(String prefix, int id) {
        StringBuilder b = new StringBuilder(32);
        b.append(prefix).append('-');
        if (id < 10) {
            b.append("0000");
        } else if (id < 100) {
            b.append("000");
        } else if (id < 1000) {
            b.append("00");
        } else if (id < 10000) {
            b.append('0');
        }
        b.append(id);
        return b.toString();
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public void trace(Object message) {
        this.doLog(Level.TRACE, FQCN, message, null, null);
    }

    public void trace(Object message, Throwable t) {
        this.doLog(Level.TRACE, FQCN, message, null, t);
    }

    public void trace(String loggerFqcn, Object message, Throwable t) {
        this.doLog(Level.TRACE, loggerFqcn, message, null, t);
    }

    public void trace(Object message, Object[] params) {
        this.doLog(Level.TRACE, FQCN, message, params, null);
    }

    public void trace(Object message, Object[] params, Throwable t) {
        this.doLog(Level.TRACE, FQCN, message, params, t);
    }

    public void trace(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.doLog(Level.TRACE, loggerFqcn, message, params, t);
    }

    public void tracev(String format, Object ... params) {
        this.doLog(Level.TRACE, FQCN, format, params, null);
    }

    public void tracev(String format, Object param1) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void tracev(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void tracev(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void tracev(Throwable t, String format, Object ... params) {
        this.doLog(Level.TRACE, FQCN, format, params, t);
    }

    public void tracev(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void tracev(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void tracev(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void tracef(String format, Object ... params) {
        this.doLogf(Level.TRACE, FQCN, format, params, null);
    }

    public void tracef(String format, Object param1) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void tracef(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void tracef(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void tracef(Throwable t, String format, Object ... params) {
        this.doLogf(Level.TRACE, FQCN, format, params, t);
    }

    public void tracef(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void tracef(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void tracef(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void tracek(int key) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), null, null);
        }
    }

    public void tracek(Throwable t, int key) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), null, t);
        }
    }

    public void tracekv(int key, Object ... params) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void tracekv(int key, Object param1) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void tracekv(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void tracekv(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void tracekv(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void tracekv(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void tracekv(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void tracekv(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void tracekf(int key, Object ... params) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void tracekf(int key, Object param1) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void tracekf(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void tracekf(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void tracekf(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLog(Level.TRACE, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void tracekf(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void tracekf(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void tracekf(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.TRACE)) {
            this.doLogf(Level.TRACE, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public void debug(Object message) {
        this.doLog(Level.DEBUG, FQCN, message, null, null);
    }

    public void debug(Object message, Throwable t) {
        this.doLog(Level.DEBUG, FQCN, message, null, t);
    }

    public void debug(String loggerFqcn, Object message, Throwable t) {
        this.doLog(Level.DEBUG, loggerFqcn, message, null, t);
    }

    public void debug(Object message, Object[] params) {
        this.doLog(Level.DEBUG, FQCN, message, params, null);
    }

    public void debug(Object message, Object[] params, Throwable t) {
        this.doLog(Level.DEBUG, FQCN, message, params, t);
    }

    public void debug(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.doLog(Level.DEBUG, loggerFqcn, message, params, t);
    }

    public void debugv(String format, Object ... params) {
        this.doLog(Level.DEBUG, FQCN, format, params, null);
    }

    public void debugv(String format, Object param1) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void debugv(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void debugv(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void debugv(Throwable t, String format, Object ... params) {
        this.doLog(Level.DEBUG, FQCN, format, params, t);
    }

    public void debugv(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void debugv(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void debugv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void debugf(String format, Object ... params) {
        this.doLogf(Level.DEBUG, FQCN, format, params, null);
    }

    public void debugf(String format, Object param1) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void debugf(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void debugf(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void debugf(Throwable t, String format, Object ... params) {
        this.doLogf(Level.DEBUG, FQCN, format, params, t);
    }

    public void debugf(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void debugf(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void debugf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void debugk(int key) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), null, null);
        }
    }

    public void debugk(Throwable t, int key) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), null, t);
        }
    }

    public void debugkv(int key, Object ... params) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void debugkv(int key, Object param1) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void debugkv(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void debugkv(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void debugkv(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void debugkv(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void debugkv(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void debugkv(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void debugkf(int key, Object ... params) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void debugkf(int key, Object param1) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void debugkf(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void debugkf(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void debugkf(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLog(Level.DEBUG, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void debugkf(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void debugkf(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void debugkf(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.DEBUG)) {
            this.doLogf(Level.DEBUG, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public void info(Object message) {
        this.doLog(Level.INFO, FQCN, message, null, null);
    }

    public void info(Object message, Throwable t) {
        this.doLog(Level.INFO, FQCN, message, null, t);
    }

    public void info(String loggerFqcn, Object message, Throwable t) {
        this.doLog(Level.INFO, loggerFqcn, message, null, t);
    }

    public void info(Object message, Object[] params) {
        this.doLog(Level.INFO, FQCN, message, params, null);
    }

    public void info(Object message, Object[] params, Throwable t) {
        this.doLog(Level.INFO, FQCN, message, params, t);
    }

    public void info(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.doLog(Level.INFO, loggerFqcn, message, params, t);
    }

    public void infov(String format, Object ... params) {
        this.doLog(Level.INFO, FQCN, format, params, null);
    }

    public void infov(String format, Object param1) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void infov(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void infov(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void infov(Throwable t, String format, Object ... params) {
        this.doLog(Level.INFO, FQCN, format, params, t);
    }

    public void infov(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void infov(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void infov(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void infof(String format, Object ... params) {
        this.doLogf(Level.INFO, FQCN, format, params, null);
    }

    public void infof(String format, Object param1) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void infof(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void infof(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void infof(Throwable t, String format, Object ... params) {
        this.doLogf(Level.INFO, FQCN, format, params, t);
    }

    public void infof(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void infof(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void infof(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void infok(int key) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), null, null);
        }
    }

    public void infok(Throwable t, int key) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), null, t);
        }
    }

    public void infokv(int key, Object ... params) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void infokv(int key, Object param1) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void infokv(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void infokv(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void infokv(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void infokv(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void infokv(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void infokv(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void infokf(int key, Object ... params) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void infokf(int key, Object param1) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void infokf(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void infokf(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void infokf(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.INFO)) {
            this.doLog(Level.INFO, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void infokf(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void infokf(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void infokf(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.INFO)) {
            this.doLogf(Level.INFO, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void warn(Object message) {
        this.doLog(Level.WARN, FQCN, message, null, null);
    }

    public void warn(Object message, Throwable t) {
        this.doLog(Level.WARN, FQCN, message, null, t);
    }

    public void warn(String loggerFqcn, Object message, Throwable t) {
        this.doLog(Level.WARN, loggerFqcn, message, null, t);
    }

    public void warn(Object message, Object[] params) {
        this.doLog(Level.WARN, FQCN, message, params, null);
    }

    public void warn(Object message, Object[] params, Throwable t) {
        this.doLog(Level.WARN, FQCN, message, params, t);
    }

    public void warn(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.doLog(Level.WARN, loggerFqcn, message, params, t);
    }

    public void warnv(String format, Object ... params) {
        this.doLog(Level.WARN, FQCN, format, params, null);
    }

    public void warnv(String format, Object param1) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void warnv(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void warnv(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void warnv(Throwable t, String format, Object ... params) {
        this.doLog(Level.WARN, FQCN, format, params, t);
    }

    public void warnv(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void warnv(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void warnv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void warnf(String format, Object ... params) {
        this.doLogf(Level.WARN, FQCN, format, params, null);
    }

    public void warnf(String format, Object param1) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void warnf(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void warnf(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void warnf(Throwable t, String format, Object ... params) {
        this.doLogf(Level.WARN, FQCN, format, params, t);
    }

    public void warnf(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void warnf(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void warnf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void warnk(int key) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), null, null);
        }
    }

    public void warnk(Throwable t, int key) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), null, t);
        }
    }

    public void warnkv(int key, Object ... params) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void warnkv(int key, Object param1) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void warnkv(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void warnkv(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void warnkv(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void warnkv(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void warnkv(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void warnkv(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void warnkf(int key, Object ... params) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void warnkf(int key, Object param1) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void warnkf(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void warnkf(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void warnkf(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.WARN)) {
            this.doLog(Level.WARN, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void warnkf(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void warnkf(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void warnkf(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.WARN)) {
            this.doLogf(Level.WARN, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void error(Object message) {
        this.doLog(Level.ERROR, FQCN, message, null, null);
    }

    public void error(Object message, Throwable t) {
        this.doLog(Level.ERROR, FQCN, message, null, t);
    }

    public void error(String loggerFqcn, Object message, Throwable t) {
        this.doLog(Level.ERROR, loggerFqcn, message, null, t);
    }

    public void error(Object message, Object[] params) {
        this.doLog(Level.ERROR, FQCN, message, params, null);
    }

    public void error(Object message, Object[] params, Throwable t) {
        this.doLog(Level.ERROR, FQCN, message, params, t);
    }

    public void error(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.doLog(Level.ERROR, loggerFqcn, message, params, t);
    }

    public void errorv(String format, Object ... params) {
        this.doLog(Level.ERROR, FQCN, format, params, null);
    }

    public void errorv(String format, Object param1) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void errorv(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void errorv(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void errorv(Throwable t, String format, Object ... params) {
        this.doLog(Level.ERROR, FQCN, format, params, t);
    }

    public void errorv(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void errorv(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void errorv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void errorf(String format, Object ... params) {
        this.doLogf(Level.ERROR, FQCN, format, params, null);
    }

    public void errorf(String format, Object param1) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void errorf(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void errorf(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void errorf(Throwable t, String format, Object ... params) {
        this.doLogf(Level.ERROR, FQCN, format, params, t);
    }

    public void errorf(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void errorf(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void errorf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void errork(int key) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), null, null);
        }
    }

    public void errork(Throwable t, int key) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), null, t);
        }
    }

    public void errorkv(int key, Object ... params) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void errorkv(int key, Object param1) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void errorkv(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void errorkv(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void errorkv(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void errorkv(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void errorkv(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void errorkv(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void errorkf(int key, Object ... params) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void errorkf(int key, Object param1) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void errorkf(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void errorkf(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void errorkf(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLog(Level.ERROR, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void errorkf(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void errorkf(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void errorkf(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.ERROR)) {
            this.doLogf(Level.ERROR, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void fatal(Object message) {
        this.doLog(Level.FATAL, FQCN, message, null, null);
    }

    public void fatal(Object message, Throwable t) {
        this.doLog(Level.FATAL, FQCN, message, null, t);
    }

    public void fatal(String loggerFqcn, Object message, Throwable t) {
        this.doLog(Level.FATAL, loggerFqcn, message, null, t);
    }

    public void fatal(Object message, Object[] params) {
        this.doLog(Level.FATAL, FQCN, message, params, null);
    }

    public void fatal(Object message, Object[] params, Throwable t) {
        this.doLog(Level.FATAL, FQCN, message, params, t);
    }

    public void fatal(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.doLog(Level.FATAL, loggerFqcn, message, params, t);
    }

    public void fatalv(String format, Object ... params) {
        this.doLog(Level.FATAL, FQCN, format, params, null);
    }

    public void fatalv(String format, Object param1) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void fatalv(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void fatalv(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void fatalv(Throwable t, String format, Object ... params) {
        this.doLog(Level.FATAL, FQCN, format, params, t);
    }

    public void fatalv(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void fatalv(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void fatalv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void fatalf(String format, Object ... params) {
        this.doLogf(Level.FATAL, FQCN, format, params, null);
    }

    public void fatalf(String format, Object param1) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void fatalf(String format, Object param1, Object param2) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void fatalf(String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void fatalf(Throwable t, String format, Object ... params) {
        this.doLogf(Level.FATAL, FQCN, format, params, t);
    }

    public void fatalf(Throwable t, String format, Object param1) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void fatalf(Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void fatalf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void fatalk(int key) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), null, null);
        }
    }

    public void fatalk(Throwable t, int key) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), null, t);
        }
    }

    public void fatalkv(int key, Object ... params) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void fatalkv(int key, Object param1) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void fatalkv(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void fatalkv(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void fatalkv(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void fatalkv(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void fatalkv(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void fatalkv(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void fatalkf(int key, Object ... params) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void fatalkf(int key, Object param1) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void fatalkf(int key, Object param1, Object param2) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void fatalkf(int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void fatalkf(Throwable t, int key, Object ... params) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLog(Level.FATAL, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void fatalkf(Throwable t, int key, Object param1) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void fatalkf(Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void fatalkf(Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(Level.FATAL)) {
            this.doLogf(Level.FATAL, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void log(Level level, Object message) {
        this.doLog(level, FQCN, message, null, null);
    }

    public void log(Level level, Object message, Throwable t) {
        this.doLog(level, FQCN, message, null, t);
    }

    public void log(Level level, String loggerFqcn, Object message, Throwable t) {
        this.doLog(level, loggerFqcn, message, null, t);
    }

    public void log(Level level, Object message, Object[] params) {
        this.doLog(level, FQCN, message, params, null);
    }

    public void log(Level level, Object message, Object[] params, Throwable t) {
        this.doLog(level, FQCN, message, params, t);
    }

    public void log(String loggerFqcn, Level level, Object message, Object[] params, Throwable t) {
        this.doLog(level, loggerFqcn, message, params, t);
    }

    public void logv(Level level, String format, Object ... params) {
        this.doLog(level, FQCN, format, params, null);
    }

    public void logv(Level level, String format, Object param1) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void logv(Level level, String format, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void logv(Level level, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void logv(Level level, Throwable t, String format, Object ... params) {
        this.doLog(level, FQCN, format, params, t);
    }

    public void logv(Level level, Throwable t, String format, Object param1) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void logv(Level level, Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void logv(Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void logf(Level level, String format, Object ... params) {
        this.doLogf(level, FQCN, format, params, null);
    }

    public void logf(Level level, String format, Object param1) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, format, new Object[]{param1}, null);
        }
    }

    public void logf(Level level, String format, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, format, new Object[]{param1, param2}, null);
        }
    }

    public void logf(Level level, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, format, new Object[]{param1, param2, param3}, null);
        }
    }

    public void logf(Level level, Throwable t, String format, Object ... params) {
        this.doLogf(level, FQCN, format, params, t);
    }

    public void logf(Level level, Throwable t, String format, Object param1) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, format, new Object[]{param1}, t);
        }
    }

    public void logf(Level level, Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, format, new Object[]{param1, param2}, t);
        }
    }

    public void logf(Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void logk(Level level, int key) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), null, null);
        }
    }

    public void logk(Level level, Throwable t, int key) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), null, t);
        }
    }

    public void logkv(Level level, int key, Object ... params) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void logkv(Level level, int key, Object param1) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void logkv(Level level, int key, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void logkv(Level level, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void logkv(Level level, Throwable t, int key, Object ... params) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void logkv(Level level, Throwable t, int key, Object param1) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void logkv(Level level, Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void logkv(Level level, Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void logkf(Level level, int key, Object ... params) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, Logger.key(this.prefix, key), params, null);
        }
    }

    public void logkf(Level level, int key, Object param1) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, null);
        }
    }

    public void logkf(Level level, int key, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, null);
        }
    }

    public void logkf(Level level, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, null);
        }
    }

    public void logkf(Level level, Throwable t, int key, Object ... params) {
        if (this.isEnabled(level)) {
            this.doLog(level, FQCN, Logger.key(this.prefix, key), params, t);
        }
    }

    public void logkf(Level level, Throwable t, int key, Object param1) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1}, t);
        }
    }

    public void logkf(Level level, Throwable t, int key, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2}, t);
        }
    }

    public void logkf(Level level, Throwable t, int key, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLogf(level, FQCN, Logger.key(this.prefix, key), new Object[]{param1, param2, param3}, t);
        }
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object param1) {
        if (this.isEnabled(level)) {
            this.doLogf(level, loggerFqcn, format, new Object[]{param1}, t);
        }
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object param1, Object param2) {
        if (this.isEnabled(level)) {
            this.doLogf(level, loggerFqcn, format, new Object[]{param1, param2}, t);
        }
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.isEnabled(level)) {
            this.doLogf(level, loggerFqcn, format, new Object[]{param1, param2, param3}, t);
        }
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object ... params) {
        this.doLogf(level, loggerFqcn, format, params, t);
    }

    protected final Object writeReplace() {
        return new SerializedLogger(this.name, this.resourceBundleName, this.prefix);
    }

    public static Logger getI18nLogger(String name, String resourceBundleName) {
        return LoggerProviders.PROVIDER.getLogger(name, resourceBundleName, null);
    }

    public static Logger getI18nLogger(String name, String resourceBundleName, String prefix) {
        return LoggerProviders.PROVIDER.getLogger(name, resourceBundleName, prefix);
    }

    public static Logger getI18nLogger(Class<?> clazz, String resourceBundleName) {
        return Logger.getI18nLogger(clazz.getName(), resourceBundleName);
    }

    public static Logger getLogger(String name) {
        return Logger.getI18nLogger(name, null);
    }

    public static Logger getLogger(String name, String suffix) {
        return Logger.getLogger(name == null || name.length() == 0 ? suffix : name + "." + suffix);
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(Class<?> clazz, String suffix) {
        return Logger.getLogger(clazz.getName(), suffix);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

