/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import org.jboss.beans.metadata.spi.ValueMetaData;

import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlElement;

@XmlType(name = "formatterType", propOrder = {})
public class FormatterMetaData {
    private PatternFormatterMetaData patternFormatterMetaData;
    private RefMetaData formatterRefMetaData;
    private ValueMetaData valueMetaData;

    public PatternFormatterMetaData getPatternFormatterMetaData() {
        return patternFormatterMetaData;
    }

    @XmlElement(name = "pattern-formatter")
    public void setPatternFormatterMetaData(final PatternFormatterMetaData patternFormatterMetaData) {
        this.patternFormatterMetaData = patternFormatterMetaData;
    }

    public RefMetaData getFormatterRefMetaData() {
        return formatterRefMetaData;
    }

    @XmlElement(name = "formatter-ref")
    public void setFormatterRefMetaData(final RefMetaData formatterRefMetaData) {
        this.formatterRefMetaData = formatterRefMetaData;
    }

    public ValueMetaData getValueMetaData() {
        return valueMetaData;
    }

    @XmlElement(name = "value")
    public void setValueMetaData(final ValueMetaData valueMetaData) {
        this.valueMetaData = valueMetaData;
    }
}
