/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import java.util.List;

import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

@XmlType(name = "installHandlerType", propOrder = {})
public class InstallHandlerMetaData {
    private RefMetaData handlerRef;
    private List<AbstractLoggerRefMetaData> loggerRefList;

    public RefMetaData getHandlerRef() {
        return handlerRef;
    }

    @XmlElement(name = "handler-ref")
    public void setHandlerRef(final RefMetaData handlerRef) {
        this.handlerRef = handlerRef;
    }

    public List<AbstractLoggerRefMetaData> getLoggerRefList() {
        return loggerRefList;
    }

    @XmlElementWrapper(name = "loggers")
    @XmlElements({
            @XmlElement(name = "root-logger", type = RootLoggerRefMetaData.class),
            @XmlElement(name = "logger", type = LoggerRefMetaData.class)
    })
    public void setLoggerRefList(final List<AbstractLoggerRefMetaData> loggerRefList) {
        this.loggerRefList = loggerRefList;
    }
}
