/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

import java.util.List;

import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;

public abstract class AbstractHandlerMetaData {
    private RefMetaData levelMetaData;
    private FilterMetaData filterMetaData;
    private ErrorManagerMetaData errorManagerMetaData;
    private FormatterMetaData formatterMetaData;
    private List<AbstractLoggerRefMetaData> loggerMetaDataList;
    private List<AbstractHandlerMetaData> subHandlerMetaDataList;
    private List<PropertyMetaData> propertyMetaDataList;
    private String name;
    private String encoding;
    private boolean autoflush;

    public RefMetaData getLevelMetaData() {
        return levelMetaData;
    }

    @XmlElement(name = "level")
    public void setLevelMetaData(final RefMetaData levelMetaData) {
        this.levelMetaData = levelMetaData;
    }

    public FilterMetaData getFilterMetaData() {
        return filterMetaData;
    }

    @XmlElement(name = "filter")
    public void setFilterMetaData(final FilterMetaData filterMetaData) {
        this.filterMetaData = filterMetaData;
    }

    public ErrorManagerMetaData getErrorManagerMetaData() {
        return errorManagerMetaData;
    }

    @XmlElement(name = "error-manager")
    public void setErrorManagerMetaData(final ErrorManagerMetaData errorManagerMetaData) {
        this.errorManagerMetaData = errorManagerMetaData;
    }

    public FormatterMetaData getFormatterMetaData() {
        return formatterMetaData;
    }

    @XmlElement(name = "formatter")
    public void setFormatterMetaData(final FormatterMetaData formatterMetaData) {
        this.formatterMetaData = formatterMetaData;
    }

    public List<AbstractLoggerRefMetaData> getLoggerMetaDataList() {
        return loggerMetaDataList;
    }

    @XmlElementWrapper(name="loggers")
    @XmlElements({
            @XmlElement(name="logger", type=LoggerRefMetaData.class),
            @XmlElement(name="root-logger", type=RootLoggerRefMetaData.class)
    })
    public void setLoggerMetaDataList(final List<AbstractLoggerRefMetaData> loggerMetaDataList) {
        this.loggerMetaDataList = loggerMetaDataList;
    }

    public List<AbstractHandlerMetaData> getSubHandlerMetaDataList() {
        return subHandlerMetaDataList;
    }

    @XmlElementWrapper(name="sub-handlers")
    @XmlElements({
            @XmlElement(name = "handler", type = HandlerMetaData.class),
            @XmlElement(name = "log4j-appender", type = Log4jAppenderMetaData.class),
            @XmlElement(name = "console-handler", type = ConsoleHandlerMetaData.class),
            @XmlElement(name = "file-handler", type = FileHandlerMetaData.class),
            @XmlElement(name = "periodic-rotating-file-handler", type = PeriodicRotatingFileHandlerMetaData.class),
            @XmlElement(name = "size-rotating-file-handler", type = SizeRotatingFileHandlerMetaData.class),
            @XmlElement(name = "async-handler", type = AsyncHandlerMetaData.class),
            @XmlElement(name = "null-handler", type = NullHandlerMetaData.class),
            @XmlElement(name = "handler-ref", type = RefMetaData.class)
    })
    public void setSubHandlerMetaDataList(final List<AbstractHandlerMetaData> subHandlerMetaDataList) {
        this.subHandlerMetaDataList = subHandlerMetaDataList;
    }

    public List<PropertyMetaData> getPropertyMetaDataList() {
        return propertyMetaDataList;
    }

    @XmlElementWrapper(name="properties")
    @XmlElement(name = "property", type = AbstractPropertyMetaData.class)
    public void setPropertyMetaDataList(final List<PropertyMetaData> propertyMetaDataList) {
        this.propertyMetaDataList = propertyMetaDataList;
    }

    public String getName() {
        return name;
    }

    @XmlAttribute
    public void setName(final String name) {
        this.name = name;
    }

    public String getEncoding() {
        return encoding;
    }

    @XmlAttribute
    public void setEncoding(final String encoding) {
        this.encoding = encoding;
    }

    public boolean isAutoflush() {
        return autoflush;
    }

    @XmlAttribute
    public void setAutoflush(final boolean autoflush) {
        this.autoflush = autoflush;
    }
}
