/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlElementWrapper;

import org.jboss.beans.metadata.plugins.AbstractValueMetaData;

public abstract class AbstractLoggerMetaData {
    private RefMetaData levelMetaData;
    private FilterMetaData filterMetaData;
    private List<Object> handlerMetaDataList;

    public RefMetaData getLevelMetaData() {
        return levelMetaData;
    }

    @XmlElement(name = "level")
    public void setLevelMetaData(final RefMetaData levelMetaData) {
        this.levelMetaData = levelMetaData;
    }

    public FilterMetaData getFilterMetaData() {
        return filterMetaData;
    }

    @XmlElement(name = "filter")
    public void setFilterMetaData(final FilterMetaData filterMetaData) {
        this.filterMetaData = filterMetaData;
    }

    public List<Object> getHandlerMetaDataList() {
        return handlerMetaDataList;
    }

    @XmlElementWrapper(name = "handlers")
    @XmlElements({
            @XmlElement(name = "handler", type = HandlerMetaData.class),
            @XmlElement(name = "log4j-appender", type = Log4jAppenderMetaData.class),
            @XmlElement(name = "console-handler", type = ConsoleHandlerMetaData.class),
            @XmlElement(name = "file-handler", type = FileHandlerMetaData.class),
            @XmlElement(name = "periodic-rotating-file-handler", type = PeriodicRotatingFileHandlerMetaData.class),
            @XmlElement(name = "size-rotating-file-handler", type = SizeRotatingFileHandlerMetaData.class),
            @XmlElement(name = "async-handler", type = AsyncHandlerMetaData.class),
            @XmlElement(name = "null-handler", type = NullHandlerMetaData.class),
            @XmlElement(name = "handler-ref", type = RefMetaData.class),
            @XmlElement(name = "value", type = AbstractValueMetaData.class)
    })
    public void setHandlerMetaDataList(final List<Object> handlerMetaDataList) {
        this.handlerMetaDataList = handlerMetaDataList;
    }
}
