/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import org.jboss.xb.annotations.JBossXmlSchema;
import org.jboss.xb.annotations.JBossXmlConstants;
import org.jboss.xb.annotations.JBossXmlType;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

import java.util.List;
import java.util.ArrayList;

/**
 *
 */
@JBossXmlSchema(namespace = "urn:jboss:logging:6.0", elementFormDefault = XmlNsForm.QUALIFIED)
@XmlRootElement(name = "logging")
@XmlType(name = "logging", propOrder = {})
@JBossXmlType(modelGroup = JBossXmlConstants.MODEL_GROUP_UNORDERED_SEQUENCE)
public class LoggingMetaData implements BeanMetaDataFactory {
    private List<AbstractLoggerMetaData> loggerMetaDataList;
    private List<AbstractHandlerMetaData> handlerMetaDataList;
    private List<InstallHandlerMetaData> installHandlerMetaDataList;
    private List<DefineContextMetaData> defineContextMetaDataList;
    private String context = "system";

    public List<AbstractLoggerMetaData> getLoggerMetaDataList() {
        return loggerMetaDataList;
    }

    @XmlElements({
            @XmlElement(name = "root-logger", type = RootLoggerMetaData.class),
            @XmlElement(name = "logger", type = LoggerMetaData.class)
    })
    public void setLoggerMetaDataList(final List<AbstractLoggerMetaData> loggerMetaDataList) {
        this.loggerMetaDataList = loggerMetaDataList;
    }

    public List<AbstractHandlerMetaData> getHandlerMetaDataList() {
        return handlerMetaDataList;
    }

    @XmlElements({
            @XmlElement(name = "handler", type = HandlerMetaData.class),
            @XmlElement(name = "log4j-appender", type = Log4jAppenderMetaData.class),
            @XmlElement(name = "console-handler", type = ConsoleHandlerMetaData.class),
            @XmlElement(name = "file-handler", type = FileHandlerMetaData.class),
            @XmlElement(name = "periodic-rotating-file-handler", type = PeriodicRotatingFileHandlerMetaData.class),
            @XmlElement(name = "size-rotating-file-handler", type = SizeRotatingFileHandlerMetaData.class),
            @XmlElement(name = "async-handler", type = AsyncHandlerMetaData.class),
            @XmlElement(name = "null-handler", type = NullHandlerMetaData.class)
    })
    public void setHandlerMetaDataList(final List<AbstractHandlerMetaData> handlerMetaDataList) {
        this.handlerMetaDataList = handlerMetaDataList;
    }

    public List<InstallHandlerMetaData> getInstallHandlerMetaDataList() {
        return installHandlerMetaDataList;
    }

    @XmlElement(name = "install-handler")
    public void setInstallHandlerMetaDataList(final List<InstallHandlerMetaData> installHandlerMetaDataList) {
        this.installHandlerMetaDataList = installHandlerMetaDataList;
    }

    public List<DefineContextMetaData> getDefineContextMetaDataList() {
        return defineContextMetaDataList;
    }

    @XmlElement(name = "define-context")
    public void setDefineContextMetaDataList(final List<DefineContextMetaData> defineContextMetaDataList) {
        this.defineContextMetaDataList = defineContextMetaDataList;
    }

    public String getContext() {
        return context;
    }

    @XmlAttribute(name = "context")
    public void setContext(final String context) {
        this.context = context;
    }

    @XmlTransient
    public List<BeanMetaData> getBeans() {
        final ArrayList<BeanMetaData> list = new ArrayList<BeanMetaData>();
        LoggingMetaDataHelper.createBeanMetaData(list, this);
        return list;
    }
}
