/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Console;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.formatters.Formatters;
import org.jboss.logmanager.handlers.OutputStreamHandler;
import org.jboss.logmanager.handlers.UncloseableOutputStream;
import org.jboss.logmanager.handlers.UncloseableWriter;

public class ConsoleHandler
extends OutputStreamHandler {
    private static final OutputStream out = System.out;
    private static final OutputStream err = System.err;
    private static final PrintWriter console;
    private final ErrorManager localErrorManager = new ErrorManager(){

        @Override
        public void error(String msg, Exception ex, int code) {
            String codeStr;
            ExtLogRecord record = new ExtLogRecord(Level.ERROR, "Failed to publish log record (%s[%d]): %s", ExtLogRecord.FormatStyle.PRINTF, this.getClass().getName());
            switch (code) {
                case 0: {
                    codeStr = "GENERIC_FAILURE";
                    break;
                }
                case 1: {
                    codeStr = "WRITE_FAILURE";
                    break;
                }
                case 2: {
                    codeStr = "FLUSH_FAILURE";
                    break;
                }
                case 3: {
                    codeStr = "CLOSE_FAILURE";
                    break;
                }
                case 4: {
                    codeStr = "OPEN_FAILURE";
                    break;
                }
                case 5: {
                    codeStr = "FORMAT_FAILURE";
                    break;
                }
                default: {
                    codeStr = "Unknown Code";
                }
            }
            record.setParameters(new Object[]{codeStr, Integer.toString(code), msg});
            record.setThrown(ex);
            ConsoleHandler.this.publish(record);
        }
    };

    public ConsoleHandler() {
        this(Formatters.nullFormatter());
    }

    public ConsoleHandler(Formatter formatter) {
        this(console == null ? Target.SYSTEM_OUT : Target.CONSOLE, formatter);
    }

    public ConsoleHandler(Target target) {
        this(target, Formatters.nullFormatter());
    }

    public ConsoleHandler(Target target, Formatter formatter) {
        super(formatter);
        switch (target) {
            case SYSTEM_OUT: {
                this.setOutputStream(ConsoleHandler.wrap(out));
                break;
            }
            case SYSTEM_ERR: {
                this.setOutputStream(ConsoleHandler.wrap(err));
                break;
            }
            case CONSOLE: {
                this.setWriter(ConsoleHandler.wrap(console));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setTarget(Target target) {
        Target t = target == null ? (console == null ? Target.SYSTEM_OUT : Target.CONSOLE) : target;
        switch (t) {
            case SYSTEM_OUT: {
                this.setOutputStream(ConsoleHandler.wrap(out));
                break;
            }
            case SYSTEM_ERR: {
                this.setOutputStream(ConsoleHandler.wrap(err));
                break;
            }
            case CONSOLE: {
                this.setWriter(ConsoleHandler.wrap(console));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setErrorManager(ErrorManager em) {
        if (em == this.localErrorManager) {
            super.setErrorManager(new ErrorManager());
            return;
        }
        super.setErrorManager(em);
    }

    public ErrorManager getLocalErrorManager() {
        return this.localErrorManager;
    }

    private static OutputStream wrap(OutputStream outputStream) {
        return outputStream == null ? null : (outputStream instanceof UncloseableOutputStream ? outputStream : new UncloseableOutputStream(outputStream));
    }

    private static Writer wrap(Writer writer) {
        return writer == null ? null : (writer instanceof UncloseableWriter ? writer : new UncloseableWriter(writer));
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(ConsoleHandler.wrap(outputStream));
    }

    static {
        Console con = System.console();
        console = con == null ? null : con.writer();
    }

    public static enum Target {
        SYSTEM_OUT,
        SYSTEM_ERR,
        CONSOLE;

    }
}

