/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.Arrays;

public final class NDC {
    private static final Holder ndc = new Holder();

    private NDC() {
    }

    public static int push(String context) {
        Stack stack = (Stack)ndc.get();
        try {
            int n = stack.depth();
            return n;
        }
        finally {
            stack.push(context);
        }
    }

    public static String pop() {
        Stack stack = (Stack)ndc.get();
        if (stack.isEmpty()) {
            return "";
        }
        return (String)stack.pop();
    }

    public static void clear() {
        ((Stack)ndc.get()).trimTo(0);
    }

    public static void trimTo(int size) {
        ((Stack)ndc.get()).trimTo(size);
    }

    public static int getDepth() {
        return ((Stack)ndc.get()).depth();
    }

    public static String get() {
        Stack stack = (Stack)ndc.get();
        if (stack.isEmpty()) {
            return "";
        }
        return stack.toString();
    }

    public static String get(int n) {
        return (String)((Stack)ndc.get()).get(n);
    }

    private static final class Stack<T> {
        private Object[] data = new Object[32];
        private int sp;

        private Stack() {
        }

        public void push(T value) {
            int oldlen = this.data.length;
            if (this.sp == oldlen) {
                Object[] newdata = new Object[oldlen * 3 / 2];
                System.arraycopy(this.data, 0, newdata, 0, oldlen);
                this.data = newdata;
            }
            this.data[this.sp++] = value;
        }

        public T pop() {
            try {
                Object object = this.data[--this.sp];
                return (T)object;
            }
            finally {
                this.data[this.sp] = null;
            }
        }

        public T top() {
            return (T)this.data[this.sp - 1];
        }

        public boolean isEmpty() {
            return this.sp == 0;
        }

        public int depth() {
            return this.sp;
        }

        public void trimTo(int max) {
            int sp = this.sp;
            if (sp > max) {
                Arrays.fill(this.data, max, sp - 1, null);
                this.sp = max;
            }
        }

        public T get(int n) {
            return (T)(n < this.sp ? this.data[n] : null);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            int sp = this.sp;
            for (int i = 0; i < sp; ++i) {
                b.append(this.data[i]);
                if (i + 1 >= sp) continue;
                b.append('.');
            }
            return b.toString();
        }
    }

    private static final class Holder
    extends ThreadLocal<Stack<String>> {
        private Holder() {
        }

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    }
}

