/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.AtomicArray;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.handlers.FlushableCloseable;

public abstract class ExtHandler
extends Handler
implements FlushableCloseable {
    private volatile boolean autoFlush = true;
    private volatile boolean enabled = true;
    private volatile boolean closeChildren;
    private static final ErrorManager DEFAULT_ERROR_MANAGER = new OnlyOnceErrorManager();
    protected volatile Handler[] handlers;
    protected static final AtomicArray<ExtHandler, Handler> handlersUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(ExtHandler.class, Handler[].class, "handlers"), Handler.class);

    protected ExtHandler() {
        handlersUpdater.clear(this);
        this.closeChildren = true;
        super.setErrorManager(DEFAULT_ERROR_MANAGER);
    }

    @Override
    public void publish(LogRecord record) {
        if (this.enabled && record != null && this.isLoggable(record)) {
            this.doPublish(ExtLogRecord.wrap(record));
        }
    }

    public void publish(ExtLogRecord record) {
        if (this.enabled && record != null && this.isLoggable(record)) {
            this.doPublish(record);
        }
    }

    protected void doPublish(ExtLogRecord record) {
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        handlersUpdater.add(this, handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        if (handler == null) {
            return;
        }
        handlersUpdater.remove(this, handler, true);
    }

    public Handler[] getHandlers() {
        Handler[] handlers = this.handlers;
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] clearHandlers() throws SecurityException {
        Handler[] handlers = this.handlers;
        handlersUpdater.clear(this);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        if (newHandlers == null) {
            throw new IllegalArgumentException("newHandlers is null");
        }
        if (newHandlers.length == 0) {
            return this.clearHandlers();
        }
        Handler[] handlers = handlersUpdater.getAndSet(this, (Handler[])newHandlers);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) throws SecurityException {
        this.autoFlush = autoFlush;
        if (autoFlush) {
            this.flush();
        }
    }

    public final void setEnabled(boolean enabled) throws SecurityException {
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCloseChildren() {
        return this.closeChildren;
    }

    public void setCloseChildren(boolean closeChildren) {
        this.closeChildren = closeChildren;
    }

    @Override
    public void flush() {
        for (Handler handler : this.handlers) {
            try {
                handler.flush();
            }
            catch (Exception ex) {
                this.reportError("Failed to flush child handler", ex, 2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws SecurityException {
        if (this.closeChildren) {
            for (Handler handler : this.handlers) {
                try {
                    handler.close();
                }
                catch (Exception ex) {
                    this.reportError("Failed to close child handler", ex, 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        super.setFormatter(newFormatter);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        super.setFilter(newFilter);
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
    }

    @Override
    public void setErrorManager(ErrorManager em) {
        super.setErrorManager(em);
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
    }

    public boolean isCallerCalculationRequired() {
        Formatter formatter = this.getFormatter();
        if (ExtHandler.formatterRequiresCallerCalculation(formatter)) {
            return true;
        }
        for (Handler handler : this.getHandlers()) {
            if (!(handler instanceof ExtHandler ? ((ExtHandler)handler).isCallerCalculationRequired() : ExtHandler.formatterRequiresCallerCalculation(formatter = handler.getFormatter()))) continue;
            return true;
        }
        return false;
    }

    private static boolean formatterRequiresCallerCalculation(Formatter formatter) {
        return formatter != null && (!(formatter instanceof ExtFormatter) || ((ExtFormatter)formatter).isCallerCalculationRequired());
    }
}

