/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.ext.formatters;

import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.logmanager.ext.formatters.IndentingXmlWriter;
import org.jboss.logmanager.ext.formatters.StructuredFormatter;

public class XmlFormatter
extends StructuredFormatter {
    private volatile boolean prettyPrint = false;

    public XmlFormatter() {
    }

    public XmlFormatter(Map<StructuredFormatter.Key, String> keyOverrides) {
        super(keyOverrides);
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean b) {
        this.prettyPrint = b;
    }

    @Override
    protected StructuredFormatter.Generator createGenerator(Writer writer) throws Exception {
        return new XmlGenerator(writer);
    }

    private class XmlGenerator
    extends StructuredFormatter.Generator {
        private final XMLStreamWriter xmlWriter;

        private XmlGenerator(Writer writer) throws XMLStreamException {
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            this.xmlWriter = XmlFormatter.this.prettyPrint ? new IndentingXmlWriter(xmlOutputFactory.createXMLStreamWriter(writer)) : xmlOutputFactory.createXMLStreamWriter(writer);
        }

        @Override
        public StructuredFormatter.Generator begin() throws Exception {
            this.writeStart(XmlFormatter.this.getKey(StructuredFormatter.Key.RECORD));
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, Map<String, ?> value) throws Exception {
            if (value == null) {
                this.writeEmpty(key);
            } else {
                this.writeStart(key);
                for (Map.Entry<String, ?> entry : value.entrySet()) {
                    String k = entry.getKey();
                    Object v = entry.getValue();
                    if (v == null) {
                        this.writeEmpty(k);
                        continue;
                    }
                    this.add(k, String.valueOf(v));
                }
                this.writeEnd();
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, String value) throws Exception {
            if (value == null) {
                this.writeEmpty(key);
            } else {
                this.writeStart(key);
                this.xmlWriter.writeCharacters(value);
                this.writeEnd();
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator addStackTrace(Throwable throwable) throws Exception {
            if (throwable != null) {
                StackTraceElement[] elements;
                this.writeStart(XmlFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION));
                this.add(XmlFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_MESSAGE), throwable.getMessage());
                for (StackTraceElement e : elements = throwable.getStackTrace()) {
                    this.writeStart(XmlFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_FRAME));
                    this.add(XmlFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_FRAME_CLASS), e.getClassName());
                    this.add(XmlFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_FRAME_METHOD), e.getMethodName());
                    int line = e.getLineNumber();
                    if (line >= 0) {
                        this.add(XmlFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_FRAME_LINE), e.getLineNumber());
                    }
                    this.writeEnd();
                }
                this.writeEnd();
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator end() throws Exception {
            this.writeEnd();
            this.safeFlush(this.xmlWriter);
            this.safeClose(this.xmlWriter);
            return this;
        }

        private void writeEmpty(String name) throws XMLStreamException {
            this.xmlWriter.writeEmptyElement(name);
        }

        private void writeStart(String name) throws XMLStreamException {
            this.xmlWriter.writeStartElement(name);
        }

        private void writeEnd() throws XMLStreamException {
            this.xmlWriter.writeEndElement();
        }

        public void safeFlush(XMLStreamWriter flushable) {
            if (flushable != null) {
                try {
                    flushable.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public void safeClose(XMLStreamWriter closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

