/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.ext.formatters;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.ext.formatters.StringBuilderWriter;
import org.jboss.logmanager.ext.util.PropertyValues;

public abstract class StructuredFormatter
extends ExtFormatter {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private final Map<Key, String> keyOverrides;
    private final String keyOverridesValue;
    private String metaData;
    private Map<String, String> metaDataMap;
    private volatile boolean printDetails;
    private volatile SimpleDateFormat dateTimeFormatter;
    private volatile String eorDelimiter = "\n";
    private volatile ExceptionOutputType exceptionOutputType;
    private final StringBuilderWriter writer = new StringBuilderWriter();
    private int refId;

    protected StructuredFormatter() {
        this(null, null);
    }

    protected StructuredFormatter(Map<Key, String> keyOverrides) {
        this(keyOverrides, PropertyValues.mapToString(keyOverrides));
    }

    protected StructuredFormatter(String keyOverrides) {
        this(PropertyValues.stringToEnumMap(Key.class, keyOverrides), keyOverrides);
    }

    private StructuredFormatter(Map<Key, String> keyOverrides, String keyOverridesValue) {
        this.keyOverridesValue = keyOverridesValue;
        this.printDetails = false;
        this.dateTimeFormatter = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        this.keyOverrides = keyOverrides == null ? Collections.emptyMap() : new EnumMap<Key, String>(keyOverrides);
        this.exceptionOutputType = ExceptionOutputType.DETAILED;
    }

    protected abstract Generator createGenerator(Writer var1) throws Exception;

    protected void before(Generator generator, ExtLogRecord record) throws Exception {
    }

    protected void after(Generator generator, ExtLogRecord record) throws Exception {
    }

    protected final String getKey(Key defaultKey) {
        if (this.keyOverrides.containsKey((Object)defaultKey)) {
            return this.keyOverrides.get((Object)defaultKey);
        }
        return defaultKey.getKey();
    }

    public synchronized String format(ExtLogRecord record) {
        boolean details = this.printDetails;
        try {
            Generator generator = this.createGenerator(this.writer).begin();
            this.before(generator, record);
            generator.add(this.getKey(Key.TIMESTAMP), this.dateTimeFormatter.format(new Date(record.getMillis()))).add(this.getKey(Key.SEQUENCE), record.getSequenceNumber()).add(this.getKey(Key.LOGGER_CLASS_NAME), record.getLoggerClassName()).add(this.getKey(Key.LOGGER_NAME), record.getLoggerName()).add(this.getKey(Key.LEVEL), record.getLevel().getName()).add(this.getKey(Key.MESSAGE), record.getFormattedMessage()).add(this.getKey(Key.THREAD_NAME), record.getThreadName()).add(this.getKey(Key.THREAD_ID), record.getThreadID()).add(this.getKey(Key.MDC), record.getMdcCopy()).add(this.getKey(Key.NDC), record.getNdc());
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                if (this.isDetailedExceptionOutputType()) {
                    this.refId = 0;
                    IdentityHashMap<Throwable, Integer> seen = new IdentityHashMap<Throwable, Integer>();
                    generator.startObject(this.getKey(Key.EXCEPTION));
                    this.addException(generator, thrown, seen);
                    generator.endObject();
                }
                if (this.isFormattedExceptionOutputType()) {
                    StringBuilderWriter w = new StringBuilderWriter();
                    thrown.printStackTrace(new PrintWriter(w));
                    generator.add(this.getKey(Key.STACK_TRACE), w.toString());
                }
            }
            if (details) {
                generator.add(this.getKey(Key.SOURCE_CLASS_NAME), record.getSourceClassName()).add(this.getKey(Key.SOURCE_FILE_NAME), record.getSourceFileName()).add(this.getKey(Key.SOURCE_METHOD_NAME), record.getSourceMethodName()).add(this.getKey(Key.SOURCE_LINE_NUMBER), record.getSourceLineNumber());
            }
            if (StructuredFormatter.isNotNullOrEmpty(this.metaData)) {
                generator.addMetaData(this.metaDataMap);
            }
            this.after(generator, record);
            generator.end();
            if (this.getRecordDelimiter() != null) {
                this.writer.append(this.getRecordDelimiter());
            }
            String string = this.writer.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writer.clear();
        }
    }

    public String getKeyOverrides() {
        return this.keyOverridesValue;
    }

    public String getRecordDelimiter() {
        return this.eorDelimiter;
    }

    public void setRecordDelimiter(String eorDelimiter) {
        this.eorDelimiter = eorDelimiter;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public synchronized void setMetaData(String metaData) {
        this.metaData = metaData;
        this.metaDataMap = metaData == null ? null : PropertyValues.stringToMap(metaData);
    }

    public String getDateFormat() {
        return this.dateTimeFormatter.toPattern();
    }

    public synchronized void setDateFormat(String pattern) {
        this.dateTimeFormatter = pattern == null ? new SimpleDateFormat(DEFAULT_DATE_FORMAT) : new SimpleDateFormat(pattern);
    }

    public boolean isPrintDetails() {
        return this.printDetails;
    }

    public void setPrintDetails(boolean printDetails) {
        this.printDetails = printDetails;
    }

    public ExceptionOutputType getExceptionOutputType() {
        return this.exceptionOutputType;
    }

    public void setExceptionOutputType(ExceptionOutputType exceptionOutputType) {
        this.exceptionOutputType = exceptionOutputType == null ? ExceptionOutputType.DETAILED : exceptionOutputType;
    }

    protected boolean isDetailedExceptionOutputType() {
        return this.exceptionOutputType == ExceptionOutputType.DETAILED || this.exceptionOutputType == ExceptionOutputType.DETAILED_AND_FORMATTED;
    }

    protected boolean isFormattedExceptionOutputType() {
        return this.exceptionOutputType == ExceptionOutputType.FORMATTED || this.exceptionOutputType == ExceptionOutputType.DETAILED_AND_FORMATTED;
    }

    private void addException(Generator generator, Throwable throwable, Map<Throwable, Integer> seen) throws Exception {
        if (throwable == null) {
            return;
        }
        if (seen.containsKey(throwable)) {
            generator.addAttribute(this.getKey(Key.EXCEPTION_REFERENCE_ID), seen.get(throwable));
            generator.startObject(this.getKey(Key.EXCEPTION_CIRCULAR_REFERENCE));
            generator.add(this.getKey(Key.EXCEPTION_MESSAGE), throwable.getMessage());
            generator.endObject();
        } else {
            Throwable cause;
            int id = ++this.refId;
            seen.put(throwable, id);
            generator.addAttribute(this.getKey(Key.EXCEPTION_REFERENCE_ID), id);
            generator.add(this.getKey(Key.EXCEPTION_TYPE), throwable.getClass().getName());
            generator.add(this.getKey(Key.EXCEPTION_MESSAGE), throwable.getMessage());
            StackTraceElement[] elements = throwable.getStackTrace();
            this.addStackTraceElements(generator, elements);
            Throwable[] suppressed = throwable.getSuppressed();
            if (suppressed != null && suppressed.length > 0) {
                generator.startArray(this.getKey(Key.EXCEPTION_SUPPRESSED));
                for (Throwable s : suppressed) {
                    if (generator.wrapArrays()) {
                        generator.startObject(this.getKey(Key.EXCEPTION));
                    } else {
                        generator.startObject(null);
                    }
                    this.addException(generator, s, seen);
                    generator.endObject();
                }
                generator.endArray();
            }
            if ((cause = throwable.getCause()) != null) {
                generator.startObject(this.getKey(Key.EXCEPTION_CAUSED_BY));
                generator.startObject(this.getKey(Key.EXCEPTION));
                this.addException(generator, cause, seen);
                generator.endObject();
                generator.endObject();
            }
        }
    }

    private void addStackTraceElements(Generator generator, StackTraceElement[] elements) throws Exception {
        generator.startArray(this.getKey(Key.EXCEPTION_FRAMES));
        for (StackTraceElement e : elements) {
            if (generator.wrapArrays()) {
                generator.startObject(this.getKey(Key.EXCEPTION_FRAME));
            } else {
                generator.startObject(null);
            }
            generator.add(this.getKey(Key.EXCEPTION_FRAME_CLASS), e.getClassName());
            generator.add(this.getKey(Key.EXCEPTION_FRAME_METHOD), e.getMethodName());
            int line = e.getLineNumber();
            if (line >= 0) {
                generator.add(this.getKey(Key.EXCEPTION_FRAME_LINE), e.getLineNumber());
            }
            generator.endObject();
        }
        generator.endArray();
    }

    private static boolean isNotNullOrEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    private static boolean isNotNullOrEmpty(Collection<?> value) {
        return value != null && !value.isEmpty();
    }

    protected static abstract class Generator {
        protected Generator() {
        }

        public Generator begin() throws Exception {
            return this;
        }

        public Generator add(String key, int value) throws Exception {
            this.add(key, Integer.toString(value));
            return this;
        }

        public Generator add(String key, long value) throws Exception {
            this.add(key, Long.toString(value));
            return this;
        }

        public abstract Generator add(String var1, Map<String, ?> var2) throws Exception;

        public abstract Generator add(String var1, String var2) throws Exception;

        public Generator addMetaData(Map<String, String> metaData) throws Exception {
            for (String key : metaData.keySet()) {
                this.add(key, metaData.get(key));
            }
            return this;
        }

        public abstract Generator startObject(String var1) throws Exception;

        public abstract Generator endObject() throws Exception;

        public Generator startArray(String key) throws Exception {
            return this.startObject(key);
        }

        public Generator endArray() throws Exception {
            return this.endObject();
        }

        public Generator addAttribute(String name, int value) throws Exception {
            return this.add(name, value);
        }

        public Generator addAttribute(String name, String value) throws Exception {
            return this.add(name, value);
        }

        public abstract Generator end() throws Exception;

        public boolean wrapArrays() {
            return false;
        }
    }

    public static enum ExceptionOutputType {
        DETAILED,
        FORMATTED,
        DETAILED_AND_FORMATTED;

    }

    public static enum Key {
        EXCEPTION("exception"),
        EXCEPTION_CAUSED_BY("causedBy"),
        EXCEPTION_CIRCULAR_REFERENCE("circularReference"),
        EXCEPTION_TYPE("exceptionType"),
        EXCEPTION_FRAME("frame"),
        EXCEPTION_FRAME_CLASS("class"),
        EXCEPTION_FRAME_LINE("line"),
        EXCEPTION_FRAME_METHOD("method"),
        EXCEPTION_FRAMES("frames"),
        EXCEPTION_MESSAGE("message"),
        EXCEPTION_REFERENCE_ID("refId"),
        EXCEPTION_SUPPRESSED("suppressed"),
        LEVEL("level"),
        LOGGER_CLASS_NAME("loggerClassName"),
        LOGGER_NAME("loggerName"),
        MDC("mdc"),
        MESSAGE("message"),
        NDC("ndc"),
        RECORD("record"),
        SEQUENCE("sequence"),
        SOURCE_CLASS_NAME("sourceClassName"),
        SOURCE_FILE_NAME("sourceFileName"),
        SOURCE_LINE_NUMBER("sourceLineNumber"),
        SOURCE_METHOD_NAME("sourceMethodName"),
        STACK_TRACE("stackTrace"),
        THREAD_ID("threadId"),
        THREAD_NAME("threadName"),
        TIMESTAMP("timestamp");

        private final String key;

        private Key(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

