/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LoggerNode;

public final class LoggerInstance
extends Logger {
    private final LoggerNode loggerNode;
    private volatile Level level;
    private volatile int effectiveLevel = Level.INFO.intValue();

    LoggerInstance(LoggerNode loggerNode, String name) {
        super(name, null);
        super.setLevel(Level.ALL);
        this.loggerNode = loggerNode;
        this.setLevel(null);
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        super.setFilter(newFilter);
    }

    public Filter getFilter() {
        return super.getFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level newLevel) throws SecurityException {
        LogContext context = this.loggerNode.getContext();
        context.checkAccess();
        context.levelTreeLock.lock();
        try {
            LoggerInstance parent;
            Level oldLevel = this.level;
            this.level = newLevel;
            this.effectiveLevel = newLevel != null ? newLevel.intValue() : ((parent = (LoggerInstance)this.getParent()) == null ? Level.INFO.intValue() : parent.effectiveLevel);
            if (oldLevel != newLevel) {
                this.loggerNode.updateChildEffectiveLevel(this.effectiveLevel);
            }
        }
        finally {
            context.levelTreeLock.unlock();
        }
    }

    void setEffectiveLevel(int newLevel) {
        if (this.level == null) {
            this.effectiveLevel = newLevel;
            this.loggerNode.updateChildEffectiveLevel(newLevel);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isLoggable(Level level) {
        return true;
    }

    public void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        super.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return super.getHandlers();
    }

    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
        super.setUseParentHandlers(useParentHandlers);
    }

    public synchronized boolean getUseParentHandlers() {
        return super.getUseParentHandlers();
    }

    public Logger getParent() {
        return this.loggerNode.getParentLogger();
    }

    public void setParent(Logger parent) {
        throw new SecurityException("setParent() disallowed");
    }

    public void log(LogRecord record) {
        record.setSourceClassName(null);
        try {
            super.log(record);
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.setLevel(null);
        }
        finally {
            super.finalize();
        }
    }
}

