/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerMap<T>
implements ConcurrentMap<String, T> {
    private final Map<String, ValueRef<T>> delegate = new HashMap<String, ValueRef<T>>();
    private final Lock readLock;
    private final Lock writeLock;

    public LoggerMap() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T putIfAbsent(String key, T value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Map<String, ValueRef<T>> delegate = this.delegate;
        Lock writeLock = this.writeLock;
        writeLock.lock();
        try {
            if (delegate.containsKey(key)) {
                ValueRef<T> ref = delegate.get(key);
                Object t = ref.get();
                if (t == null) {
                    delegate.put(key, new ValueRef<T>(value));
                    T t2 = null;
                    return t2;
                }
                Object t3 = t;
                return t3;
            }
            delegate.put(key, new ValueRef<T>(value));
            T t = null;
            return t;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        Map<String, ValueRef<T>> delegate = this.delegate;
        Lock writeLock = this.writeLock;
        writeLock.lock();
        try {
            ValueRef<T> ref = delegate.get(key);
            if (ref != null) {
                Object t = ref.get();
                if (t == null) {
                    delegate.remove(key);
                    boolean bl = false;
                    return bl;
                }
                if (t == value) {
                    delegate.remove(key);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public boolean replace(String key, T oldValue, T newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T replace(String key, T value) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Lock readLock = this.readLock;
        readLock.lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Lock readLock = this.readLock;
        readLock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Lock readLock = this.readLock;
        readLock.lock();
        try {
            boolean bl = this.delegate.containsKey(key);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Lock readLock = this.readLock;
        readLock.lock();
        try {
            boolean bl = this.delegate.containsValue(new ValueRef<Object>(value));
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Object key) {
        Lock readLock = this.readLock;
        readLock.lock();
        try {
            ValueRef<T> ref = this.delegate.get(key);
            T t = ref == null ? null : (T)ref.get();
            return t;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T put(String key, T value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Lock writeLock = this.writeLock;
        writeLock.lock();
        try {
            ValueRef<T> oldRef = this.delegate.put(key, new ValueRef<T>(value));
            T t = oldRef == null ? null : (T)oldRef.get();
            return t;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(Object key) {
        Lock writeLock = this.writeLock;
        writeLock.lock();
        try {
            ValueRef<T> oldRef = this.delegate.remove(key);
            T t = oldRef == null ? null : (T)oldRef.get();
            return t;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> t) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock writeLock = this.writeLock;
        writeLock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> values() {
        Lock lock = this.readLock;
        lock.lock();
        try {
            Collection<ValueRef<T>> values = this.delegate.values();
            ArrayList list = new ArrayList();
            for (ValueRef<T> ref : values) {
                Object t = ref.get();
                if (t == null) continue;
                list.add(t);
            }
            Collection collection = Collections.unmodifiableCollection(list);
            return collection;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueRef<T>
    extends WeakReference<T> {
        public ValueRef(T referent) {
            super(referent);
        }

        public boolean equals(Object obj) {
            return ((ValueRef)obj).get() == this.get();
        }
    }
}

