/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.MDCProvider;
import org.jboss.logging.MDCSupport;
import org.jboss.logging.NDCProvider;
import org.jboss.logging.NDCSupport;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.MDCProviderImpl;
import org.jboss.logmanager.NDCProviderImpl;

public final class LoggerPluginImpl
implements LoggerPlugin,
NDCSupport,
MDCSupport {
    private Logger logger;
    private static final String FQCN = org.jboss.logging.Logger.class.getName();

    public void init(String name) {
        this.logger = Logger.getLogger(name);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.TRACE);
    }

    public void trace(Object message) {
        this.logger.log(FQCN, Level.TRACE, String.valueOf(message), null);
    }

    public void trace(Object message, Throwable t) {
        this.logger.log(FQCN, Level.TRACE, String.valueOf(message), t);
    }

    public void trace(String loggerFcqn, Object message, Throwable t) {
        this.logger.log(loggerFcqn, Level.TRACE, String.valueOf(message), t);
    }

    @Deprecated
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.DEBUG);
    }

    public void debug(Object message) {
        this.logger.log(FQCN, Level.DEBUG, String.valueOf(message), null);
    }

    public void debug(Object message, Throwable t) {
        this.logger.log(FQCN, Level.DEBUG, String.valueOf(message), t);
    }

    public void debug(String loggerFcqn, Object message, Throwable t) {
        this.logger.log(loggerFcqn, Level.DEBUG, String.valueOf(message), t);
    }

    @Deprecated
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(Object message) {
        this.logger.log(FQCN, Level.INFO, String.valueOf(message), null);
    }

    public void info(Object message, Throwable t) {
        this.logger.log(FQCN, Level.INFO, String.valueOf(message), t);
    }

    public void info(String loggerFcqn, Object message, Throwable t) {
        this.logger.log(loggerFcqn, Level.INFO, String.valueOf(message), t);
    }

    public void warn(Object message) {
        this.logger.log(FQCN, Level.WARN, String.valueOf(message), null);
    }

    public void warn(Object message, Throwable t) {
        this.logger.log(FQCN, Level.WARN, String.valueOf(message), t);
    }

    public void warn(String loggerFcqn, Object message, Throwable t) {
        this.logger.log(loggerFcqn, Level.WARN, String.valueOf(message), t);
    }

    public void error(Object message) {
        this.logger.log(FQCN, Level.ERROR, String.valueOf(message), null);
    }

    public void error(Object message, Throwable t) {
        this.logger.log(FQCN, Level.ERROR, String.valueOf(message), t);
    }

    public void error(String loggerFcqn, Object message, Throwable t) {
        this.logger.log(loggerFcqn, Level.ERROR, String.valueOf(message), t);
    }

    public void fatal(Object message) {
        this.logger.log(FQCN, Level.FATAL, String.valueOf(message), null);
    }

    public void fatal(Object message, Throwable t) {
        this.logger.log(FQCN, Level.FATAL, String.valueOf(message), t);
    }

    public void fatal(String loggerFcqn, Object message, Throwable t) {
        this.logger.log(loggerFcqn, Level.FATAL, String.valueOf(message), t);
    }

    public NDCProvider getNDCProvider() {
        return NDCProviderImpl.getInstance();
    }

    public MDCProvider getMDCProvider() {
        return MDCProviderImpl.getInstance();
    }
}

