/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.ConcurrentReferenceHashMap;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LoggerNode {
    private final LogContext context;
    private final LoggerNode parent;
    private final String fullName;
    private LoggerRef loggerRef = null;
    private final ConcurrentMap<String, LoggerNode> children = new ConcurrentReferenceHashMap<String, LoggerNode>(8, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    LoggerNode(LogContext context) {
        this.parent = null;
        this.fullName = "";
        this.context = context;
    }

    private LoggerNode(LogContext context, LoggerNode parent, String nodeName) {
        nodeName = nodeName.trim();
        if (nodeName.length() == 0) {
            throw new IllegalArgumentException("nodeName is empty, or just whitespace");
        }
        this.parent = parent;
        this.fullName = parent.parent == null ? nodeName : parent.fullName + "." + nodeName;
        parent.children.put(nodeName, this);
        this.context = context;
    }

    LoggerNode getOrCreate(String name) {
        LoggerNode appearingNode;
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null && (appearingNode = this.children.putIfAbsent(nextName, nextNode = new LoggerNode(this.context, this, nextName))) != null) {
            nextNode = appearingNode;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getOrCreate(name.substring(i + 1));
    }

    LoggerNode getIfExists(String name) {
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null) {
            return null;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getIfExists(name.substring(i + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logger getOrCreateLogger() {
        LoggerNode loggerNode = this;
        synchronized (loggerNode) {
            Logger instance;
            Logger logger = instance = this.loggerRef == null ? null : this.loggerRef.get();
            if (instance == null) {
                instance = new Logger(this, this.fullName);
                this.loggerRef = this.fullName.length() == 0 ? new StrongLoggerRef(instance) : new WeakLoggerRef(instance);
                instance.setLevel(null);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logger getLogger() {
        LoggerNode loggerNode = this;
        synchronized (loggerNode) {
            return this.loggerRef == null ? null : this.loggerRef.get();
        }
    }

    Collection<LoggerNode> getChildren() {
        return this.children.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logger getParentLogger() {
        LoggerNode node = this.parent;
        while (node != null) {
            LoggerNode loggerNode = node;
            synchronized (loggerNode) {
                Logger instance;
                Logger logger = instance = node.loggerRef == null ? null : node.loggerRef.get();
                if (instance != null) {
                    return instance;
                }
                node = node.parent;
            }
        }
        return null;
    }

    LogContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildEffectiveLevel(int newLevel) {
        for (LoggerNode node : this.children.values()) {
            if (node == null) continue;
            LoggerNode loggerNode = node;
            synchronized (loggerNode) {
                Logger instance;
                LoggerRef loggerRef = node.loggerRef;
                if (loggerRef != null && (instance = loggerRef.get()) != null) {
                    instance.setEffectiveLevel(newLevel);
                }
            }
        }
    }

    private static final class StrongLoggerRef
    implements LoggerRef {
        private final Logger logger;

        private StrongLoggerRef(Logger logger) {
            this.logger = logger;
        }

        public Logger get() {
            return this.logger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakLoggerRef
    extends WeakReference<Logger>
    implements LoggerRef {
        private WeakLoggerRef(Logger referent) {
            super(referent);
        }
    }

    private static interface LoggerRef {
        public Logger get();
    }
}

