/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.logmanager.ConcurrentReferenceHashMap;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LoggerNode {
    private final LogContext context;
    private final LoggerNode parent;
    private final String fullName;
    private volatile LoggerRef loggerRef = null;
    private static final AtomicReferenceFieldUpdater<LoggerNode, LoggerRef> loggerRefUpdater = AtomicReferenceFieldUpdater.newUpdater(LoggerNode.class, LoggerRef.class, "loggerRef");
    private final ConcurrentMap<String, LoggerNode> children = new ConcurrentReferenceHashMap<String, LoggerNode>(8, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    LoggerNode(LogContext context) {
        this.parent = null;
        this.fullName = "";
        this.context = context;
    }

    private LoggerNode(LogContext context, LoggerNode parent, String nodeName) {
        nodeName = nodeName.trim();
        if (nodeName.length() == 0) {
            throw new IllegalArgumentException("nodeName is empty, or just whitespace");
        }
        this.parent = parent;
        this.fullName = parent.parent == null ? nodeName : parent.fullName + "." + nodeName;
        this.context = context;
    }

    LoggerNode getOrCreate(String name) {
        LoggerNode appearingNode;
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null && (appearingNode = this.children.putIfAbsent(nextName, nextNode = new LoggerNode(this.context, this, nextName))) != null) {
            nextNode = appearingNode;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getOrCreate(name.substring(i + 1));
    }

    LoggerNode getIfExists(String name) {
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null) {
            return null;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getIfExists(name.substring(i + 1));
    }

    Logger getOrCreateLogger() {
        Logger logger;
        LoggerRef loggerRef;
        String fullName = this.fullName;
        LoggerNode parent = this.parent;
        do {
            if ((loggerRef = this.loggerRef) != null && (logger = loggerRef.get()) != null) {
                return logger;
            }
            logger = this.createLogger(fullName);
        } while (!loggerRefUpdater.compareAndSet(this, loggerRef, parent == null ? new StrongLoggerRef(logger) : new WeakLoggerRef(logger)));
        return logger;
    }

    private Logger createLogger(final String fullName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Logger>(){

                @Override
                public Logger run() {
                    Logger logger = new Logger(LoggerNode.this, fullName);
                    logger.setLevel(null);
                    return logger;
                }
            });
        }
        Logger logger = new Logger(this, fullName);
        logger.setLevel(null);
        return logger;
    }

    Logger getLogger() {
        LoggerRef loggerRef = this.loggerRef;
        return loggerRef == null ? null : loggerRef.get();
    }

    Collection<LoggerNode> getChildren() {
        return this.children.values();
    }

    Logger getParentLogger() {
        LoggerNode node = this.parent;
        while (node != null) {
            Logger instance = node.getLogger();
            if (instance != null) {
                return instance;
            }
            node = node.parent;
        }
        return null;
    }

    LogContext getContext() {
        return this.context;
    }

    void updateChildEffectiveLevel(int newLevel) {
        for (LoggerNode node : this.children.values()) {
            Logger instance;
            if (node == null || (instance = node.getLogger()) == null) continue;
            instance.setEffectiveLevel(newLevel);
        }
    }

    private static final class StrongLoggerRef
    implements LoggerRef {
        private final Logger logger;

        private StrongLoggerRef(Logger logger) {
            this.logger = logger;
        }

        public Logger get() {
            return this.logger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakLoggerRef
    extends WeakReference<Logger>
    implements LoggerRef {
        private WeakLoggerRef(Logger referent) {
            super(referent);
        }
    }

    private static interface LoggerRef {
        public Logger get();
    }
}

