/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SubstituteFilter
implements Filter {
    private final Filter matchFilter;
    private final Pattern pattern;
    private final String replacement;
    private final boolean replaceAll;

    public SubstituteFilter(Filter matchFilter, Pattern pattern, String replacement, boolean replaceAll) {
        this.matchFilter = matchFilter;
        this.pattern = pattern;
        this.replacement = replacement;
        this.replaceAll = replaceAll;
    }

    public boolean isLoggable(LogRecord record) {
        if (this.matchFilter.isLoggable(record)) {
            Matcher matcher = this.pattern.matcher(record.getMessage());
            if (this.replaceAll) {
                record.setMessage(matcher.replaceAll(this.replacement));
            } else {
                record.setMessage(matcher.replaceFirst(this.replacement));
            }
        }
        return true;
    }
}

