/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Formatter;
import org.jboss.logmanager.handlers.OutputStreamHandler;

public class FileHandler
extends OutputStreamHandler {
    private File file;
    private boolean append;

    public FileHandler() {
    }

    public FileHandler(Formatter formatter) {
        super(formatter);
    }

    public FileHandler(Formatter formatter, File file) throws FileNotFoundException {
        super(formatter);
        this.setFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppend(boolean append) {
        Object object = this.outputLock;
        synchronized (object) {
            this.append = append;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(File file) throws FileNotFoundException {
        Object object = this.outputLock;
        synchronized (object) {
            if (file == null) {
                this.setOutputStream(null);
                return;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            boolean ok = false;
            FileOutputStream fos = new FileOutputStream(file, this.append);
            try {
                this.setOutputStream(fos);
                this.file = file;
                ok = true;
            }
            finally {
                if (!ok) {
                    this.safeClose(fos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.file;
        }
    }

    public void setFileName(String fileName) throws FileNotFoundException {
        this.setFile(new File(fileName));
    }
}

