/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Formatter;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class WriterHandler
extends ExtHandler {
    protected final Object outputLock = new Object();
    private Writer writer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPublish(ExtLogRecord record) {
        String formatted;
        Formatter formatter = this.getFormatter();
        try {
            formatted = formatter.format(record);
        }
        catch (Exception ex) {
            this.reportError("Formatting error", ex, 5);
            return;
        }
        if (formatted.length() == 0) {
            return;
        }
        try {
            Object ex = this.outputLock;
            synchronized (ex) {
                Writer writer = this.writer;
                if (writer == null) {
                    return;
                }
                this.preWrite(record);
                writer.write(formatted);
                super.doPublish(record);
            }
        }
        catch (Exception ex) {
            this.reportError("Error writing log message", ex, 1);
            return;
        }
    }

    protected void preWrite(ExtLogRecord record) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriter(Writer writer) {
        Writer oldWriter;
        WriterHandler.checkAccess();
        Object object = this.outputLock;
        synchronized (object) {
            oldWriter = this.writer;
            this.writeTail(oldWriter);
            this.safeFlush(oldWriter);
            this.writeHead(writer);
            this.writer = writer;
        }
        if (oldWriter != null) {
            this.safeClose(oldWriter);
        }
    }

    private void writeHead(Writer writer) {
        if (writer != null) {
            try {
                writer.write(this.getFormatter().getHead(this));
            }
            catch (Exception e) {
                this.reportError("Error writing section header", e, 1);
            }
        }
    }

    private void writeTail(Writer writer) {
        if (writer != null) {
            try {
                writer.write(this.getFormatter().getTail(this));
            }
            catch (Exception ex) {
                this.reportError("Error writing section tail", ex, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.outputLock;
        synchronized (object) {
            this.safeFlush(this.writer);
        }
    }

    public void close() throws SecurityException {
        WriterHandler.checkAccess();
        this.setWriter(null);
    }

    protected void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            this.reportError("Error closing resource", e, 3);
        }
    }

    private void safeFlush(Flushable f) {
        try {
            if (f != null) {
                f.flush();
            }
        }
        catch (IOException e) {
            this.reportError("Error on flush", e, 2);
        }
    }
}

