/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.AtomicArray;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

final class LoggerNode {
    private final LogContext context;
    private final LoggerNode parent;
    private final String fullName;
    private final ConcurrentMap<String, LoggerNode> children;
    private volatile Handler[] handlers;
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private volatile Map<Logger.AttachmentKey, Object> attachments = Collections.emptyMap();
    private static final AtomicArray<LoggerNode, Handler> handlersUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(LoggerNode.class, Handler[].class, "handlers"), Handler.class);
    private static final AtomicReferenceFieldUpdater<LoggerNode, Map> attachmentsUpdater = AtomicReferenceFieldUpdater.newUpdater(LoggerNode.class, Map.class, "attachments");
    private volatile Level level;
    private volatile int effectiveLevel = Logger.INFO_INT;

    LoggerNode(LogContext context) {
        this.parent = null;
        this.fullName = "";
        handlersUpdater.clear(this);
        this.context = context;
        this.children = context.createChildMap();
    }

    private LoggerNode(LogContext context, LoggerNode parent, String nodeName) {
        nodeName = nodeName.trim();
        if (nodeName.length() == 0) {
            throw new IllegalArgumentException("nodeName is empty, or just whitespace");
        }
        this.parent = parent;
        handlersUpdater.clear(this);
        this.fullName = parent.parent == null ? nodeName : parent.fullName + "." + nodeName;
        this.context = context;
        this.effectiveLevel = parent.effectiveLevel;
        this.children = context.createChildMap();
    }

    LoggerNode getOrCreate(String name) {
        LoggerNode appearingNode;
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null && (appearingNode = this.children.putIfAbsent(nextName, nextNode = new LoggerNode(this.context, this, nextName))) != null) {
            nextNode = appearingNode;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getOrCreate(name.substring(i + 1));
    }

    LoggerNode getIfExists(String name) {
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null) {
            return null;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getIfExists(name.substring(i + 1));
    }

    Logger createLogger() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Logger>(){

                @Override
                public Logger run() {
                    Logger logger = new Logger(LoggerNode.this, LoggerNode.this.fullName);
                    return logger;
                }
            });
        }
        Logger logger = new Logger(this, this.fullName);
        return logger;
    }

    Collection<LoggerNode> getChildren() {
        return this.children.values();
    }

    LogContext getContext() {
        return this.context;
    }

    void setEffectiveLevel(int newLevel) {
        if (this.level == null) {
            this.effectiveLevel = newLevel;
            for (LoggerNode node : this.children.values()) {
                if (node == null) continue;
                node.setEffectiveLevel(newLevel);
            }
        }
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    Filter getFilter() {
        return this.filter;
    }

    int getEffectiveLevel() {
        return this.effectiveLevel;
    }

    Handler[] getHandlers() {
        return this.handlers;
    }

    Handler[] clearHandlers() {
        Handler[] handlers = this.handlers;
        handlersUpdater.clear(this);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    void removeHandler(Handler handler) {
        handlersUpdater.remove(this, handler, true);
    }

    void addHandler(Handler handler) {
        handlersUpdater.add(this, handler);
    }

    Handler[] setHandlers(Handler[] handlers) {
        return handlersUpdater.getAndSet(this, (Handler[])handlers);
    }

    boolean compareAndSetHandlers(Handler[] oldHandlers, Handler[] newHandlers) {
        return handlersUpdater.compareAndSet(this, (Handler[])oldHandlers, (Handler[])newHandlers);
    }

    boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    void setUseParentHandlers(boolean useParentHandlers) {
        this.useParentHandlers = useParentHandlers;
    }

    void publish(ExtLogRecord record) {
        LoggerNode parent;
        for (Handler handler : this.handlers) {
            try {
                handler.publish(record);
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.useParentHandlers && (parent = this.parent) != null) {
            parent.publish(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLevel(Level newLevel) {
        Object lock;
        LogContext context = this.context;
        Object object = lock = context.treeLock;
        synchronized (object) {
            int newEffectiveLevel;
            int oldEffectiveLevel = this.effectiveLevel;
            if (newLevel != null) {
                this.level = newLevel;
                newEffectiveLevel = newLevel.intValue();
            } else {
                LoggerNode parent = this.parent;
                if (parent == null) {
                    this.level = Level.INFO;
                    newEffectiveLevel = Logger.INFO_INT;
                } else {
                    this.level = null;
                    newEffectiveLevel = parent.effectiveLevel;
                }
            }
            this.effectiveLevel = newEffectiveLevel;
            if (oldEffectiveLevel != newEffectiveLevel) {
                for (LoggerNode node : this.children.values()) {
                    if (node == null) continue;
                    node.setEffectiveLevel(newEffectiveLevel);
                }
            }
        }
    }

    Level getLevel() {
        return this.level;
    }

    <V> V getAttachment(Logger.AttachmentKey<V> key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        Map<Logger.AttachmentKey, Object> attachments = this.attachments;
        return (V)attachments.get(key);
    }

    <V> V attach(Logger.AttachmentKey<V> key, V value) {
        Object old;
        Map<Logger.AttachmentKey<V>, V> newAttachments;
        Map<Logger.AttachmentKey, Object> oldAttachments;
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        do {
            if ((oldAttachments = this.attachments).isEmpty() || oldAttachments.size() == 1 && oldAttachments.containsKey(key)) {
                old = oldAttachments.get(key);
                newAttachments = Collections.singletonMap(key, value);
                continue;
            }
            newAttachments = new HashMap<Logger.AttachmentKey, Object>(oldAttachments);
            old = newAttachments.put(key, value);
        } while (!attachmentsUpdater.compareAndSet(this, oldAttachments, newAttachments));
        return (V)old;
    }

    <V> V attachIfAbsent(Logger.AttachmentKey<V> key, V value) {
        Map<Logger.AttachmentKey<V>, V> newAttachments;
        Map<Logger.AttachmentKey, Object> oldAttachments;
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        do {
            if ((oldAttachments = this.attachments).isEmpty()) {
                newAttachments = Collections.singletonMap(key, value);
                continue;
            }
            if (oldAttachments.containsKey(key)) {
                return (V)oldAttachments.get(key);
            }
            newAttachments = new HashMap<Logger.AttachmentKey, Object>(oldAttachments);
            newAttachments.put(key, value);
        } while (!attachmentsUpdater.compareAndSet(this, oldAttachments, newAttachments));
        return null;
    }

    public <V> V detach(Logger.AttachmentKey<V> key) {
        Object result;
        Map<Object, Object> newAttachments;
        Map<Logger.AttachmentKey, Object> oldAttachments;
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        do {
            if ((result = (oldAttachments = this.attachments).get(key)) == null) {
                return null;
            }
            int size = oldAttachments.size();
            if (size == 1) {
                newAttachments = Collections.emptyMap();
                continue;
            }
            if (size == 2) {
                Iterator<Map.Entry<Logger.AttachmentKey, Object>> it = oldAttachments.entrySet().iterator();
                Map.Entry<Logger.AttachmentKey, Object> entry = it.next();
                if (entry.getKey() == key) {
                    entry = it.next();
                }
                newAttachments = Collections.singletonMap(entry.getKey(), entry.getValue());
                continue;
            }
            newAttachments = new HashMap<Logger.AttachmentKey, Object>(oldAttachments);
        } while (!attachmentsUpdater.compareAndSet(this, oldAttachments, newAttachments));
        return (V)result;
    }

    String getFullName() {
        return this.fullName;
    }

    LoggerNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.setLevel(null);
        }
        finally {
            super.finalize();
        }
    }
}

