/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.config;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.config.AbstractPropertyConfiguration;
import org.jboss.logmanager.config.ConfigAction;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfigurationImpl;
import org.jboss.logmanager.config.ObjectProducer;
import org.jboss.logmanager.config.PropertyHelper;

final class HandlerConfigurationImpl
extends AbstractPropertyConfiguration<Handler, HandlerConfigurationImpl>
implements HandlerConfiguration {
    private final List<String> handlerNames = new ArrayList<String>(0);
    private String formatterName;
    private String level;
    private String filter;
    private String encoding;
    private String errorManagerName;

    HandlerConfigurationImpl(LogContextConfigurationImpl configuration, String name, String moduleName, String className, String[] constructorProperties) {
        super(Handler.class, configuration, configuration.getHandlerRefs(), configuration.getHandlerConfigurations(), name, moduleName, className, constructorProperties);
    }

    @Override
    public String getFormatterName() {
        return this.formatterName;
    }

    @Override
    public void setFormatterName(final String formatterName) {
        final String oldFormatterName = this.formatterName;
        this.formatterName = formatterName;
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                if (formatterName != null && configuration.getFormatterConfiguration(formatterName) == null) {
                    throw new IllegalArgumentException(String.format("Formatter \"%s\" is not found", formatterName));
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(Void param) {
                configuration.getHandlerRefs().get(HandlerConfigurationImpl.this.getName()).setFormatter(formatterName == null ? null : configuration.getFormatterRefs().get(formatterName));
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.formatterName = oldFormatterName;
            }
        });
    }

    @Override
    public String getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(String level) {
        String resolvedLevel;
        final String oldLevel = this.level;
        this.level = resolvedLevel = PropertyHelper.resolveValue(level);
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Level>(){

            @Override
            public Level validate() throws IllegalArgumentException {
                return resolvedLevel == null ? null : configuration.getLogContext().getLevelForName(resolvedLevel);
            }

            @Override
            public void applyPreCreate(Level param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(Level param) {
                configuration.getHandlerRefs().get(HandlerConfigurationImpl.this.getName()).setLevel(param);
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.level = oldLevel;
            }
        });
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(final String filter) {
        final String oldFilterName = this.filter;
        this.filter = filter;
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<ObjectProducer>(){

            @Override
            public ObjectProducer validate() throws IllegalArgumentException {
                return configuration.parseFilterExpression(filter);
            }

            @Override
            public void applyPreCreate(ObjectProducer param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(ObjectProducer param) {
                configuration.getHandlerRefs().get(HandlerConfigurationImpl.this.getName()).setFilter((Filter)param.getObject());
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.filter = oldFilterName;
            }
        });
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(final String encoding) {
        final String oldEncoding = this.encoding;
        this.encoding = encoding;
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                if (encoding != null) {
                    try {
                        Charset.forName(encoding);
                    }
                    catch (Throwable t) {
                        throw new IllegalArgumentException(String.format("Unsupported character set \"%s\"", encoding));
                    }
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(Void param) {
                try {
                    configuration.getHandlerRefs().get(HandlerConfigurationImpl.this.getName()).setEncoding(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(String.format("The encoding value '%s' is invalid.", encoding), e);
                }
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.encoding = oldEncoding;
            }
        });
    }

    @Override
    public String getErrorManagerName() {
        return this.errorManagerName;
    }

    @Override
    public void setErrorManagerName(final String errorManagerName) {
        final String oldErrorManagerName = this.errorManagerName;
        this.errorManagerName = errorManagerName;
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                if (errorManagerName != null && configuration.getErrorManagerConfiguration(errorManagerName) == null) {
                    throw new IllegalArgumentException(String.format("errorManager \"%s\" is not found", errorManagerName));
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(Void param) {
                configuration.getHandlerRefs().get(HandlerConfigurationImpl.this.getName()).setErrorManager(errorManagerName == null ? null : configuration.getErrorManagerRefs().get(errorManagerName));
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.errorManagerName = oldErrorManagerName;
            }
        });
    }

    @Override
    public List<String> getHandlerNames() {
        return new ArrayList<String>(this.handlerNames);
    }

    @Override
    public void setHandlerNames(String ... names) {
        final String[] oldHandlerNames = this.handlerNames.toArray(new String[this.handlerNames.size()]);
        this.handlerNames.clear();
        LinkedHashSet<String> strings = new LinkedHashSet<String>(Arrays.asList(names));
        this.handlerNames.addAll(strings);
        final String[] stringsArray = strings.toArray(new String[strings.size()]);
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        if (!ExtHandler.class.isAssignableFrom(this.getActualClass())) {
            if (names.length == 0) {
                return;
            }
            throw new IllegalArgumentException("Nested handlers not supported for handler " + this.getActualClass());
        }
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                for (String name : stringsArray) {
                    if (configuration.getHandlerConfiguration(name) != null) continue;
                    throw new IllegalArgumentException(String.format("Handler \"%s\" is not found", name));
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                ExtHandler handler = (ExtHandler)handlerRefs.get(HandlerConfigurationImpl.this.getName());
                int length = stringsArray.length;
                Handler[] handlers = new Handler[length];
                for (int i = 0; i < length; ++i) {
                    handlers[i] = handlerRefs.get(stringsArray[i]);
                }
                handler.setHandlers(handlers);
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.handlerNames.clear();
                HandlerConfigurationImpl.this.handlerNames.addAll(Arrays.asList(oldHandlerNames));
            }
        });
    }

    @Override
    public void setHandlerNames(Collection<String> names) {
        this.setHandlerNames(names.toArray(new String[names.size()]));
    }

    @Override
    public boolean addHandlerName(final String name) {
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        if (!ExtHandler.class.isAssignableFrom(this.getActualClass())) {
            throw new IllegalArgumentException("Nested handlers not supported for handler " + this.getActualClass());
        }
        if (this.handlerNames.contains(name)) {
            return false;
        }
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                if (configuration.getHandlerConfiguration(name) == null) {
                    throw new IllegalArgumentException(String.format("Handler \"%s\" is not found", name));
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                ExtHandler handler = (ExtHandler)handlerRefs.get(HandlerConfigurationImpl.this.getName());
                handler.addHandler(handlerRefs.get(name));
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.handlerNames.remove(name);
            }
        });
        return true;
    }

    @Override
    public boolean removeHandlerName(final String name) {
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        if (!ExtHandler.class.isAssignableFrom(this.getActualClass())) {
            return false;
        }
        if (!this.handlerNames.contains(name)) {
            return false;
        }
        final int index = this.handlerNames.indexOf(name);
        this.handlerNames.remove(index);
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                ExtHandler handler = (ExtHandler)handlerRefs.get(HandlerConfigurationImpl.this.getName());
                handler.removeHandler(handlerRefs.get(name));
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.handlerNames.add(index, name);
            }
        });
        return true;
    }

    @Override
    String getDescription() {
        return "handler";
    }

    @Override
    ConfigAction<Void> getRemoveAction() {
        return new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                Handler handler = (Handler)HandlerConfigurationImpl.this.refs.remove(HandlerConfigurationImpl.this.getName());
                if (handler != null) {
                    handler.close();
                }
            }

            @Override
            public void applyPostCreate(Void param) {
                HandlerConfigurationImpl.this.addPostConfigurationActions();
            }

            @Override
            public void rollback() {
                HandlerConfigurationImpl.this.configs.put(HandlerConfigurationImpl.this.getName(), HandlerConfigurationImpl.this);
                HandlerConfigurationImpl.this.clearRemoved();
            }
        };
    }
}

