/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.ColorMap;
import org.jboss.logmanager.formatters.FormatStep;
import org.jboss.logmanager.formatters.StringBuilderWriter;

public final class Formatters {
    public static final String THREAD_ID = "id";
    private static final boolean DEFAULT_TRUNCATE_BEGINNING = false;
    private static final String NEW_LINE = String.format("%n", new Object[0]);
    private static final Pattern PRECISION_INT_PATTERN = Pattern.compile("\\d+");
    private static final Formatter NULL_FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord record) {
            return "";
        }
    };
    private static final String separatorString = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });

    private Formatters() {
    }

    public static Formatter nullFormatter() {
        return NULL_FORMATTER;
    }

    public static FormatStep textFormatStep(final String string) {
        return new FormatStep(){

            @Override
            public void render(StringBuilder builder, ExtLogRecord record) {
                builder.append(string);
            }

            @Override
            public int estimateLength() {
                return string.length();
            }
        };
    }

    private static String applySegments(int count, String subject) {
        if (count == 0) {
            return subject;
        }
        int idx = subject.length() + 1;
        for (int i = 0; i < count; ++i) {
            if ((idx = subject.lastIndexOf(46, idx - 1)) != -1) continue;
            return subject;
        }
        return subject.substring(idx + 1);
    }

    private static String applySegments(String precision, String subject) {
        String s;
        if (precision == null) {
            return subject;
        }
        if (PRECISION_INT_PATTERN.matcher(precision).matches()) {
            return Formatters.applySegments(Integer.parseInt(precision), subject);
        }
        Map<Integer, Segment> segments = Formatters.parsePatternSegments(precision);
        Deque<String> categorySegments = Formatters.parseCategorySegments(subject);
        StringBuilder result = new StringBuilder();
        Segment segment = null;
        int index = 0;
        while (true) {
            if (segments.containsKey(++index)) {
                segment = segments.get(index);
            }
            s = categorySegments.poll();
            if (categorySegments.peek() == null) break;
            if (segment == null) {
                result.append(s).append('.');
                continue;
            }
            if (segment.len > 0) {
                if (segment.len > s.length()) {
                    result.append(s);
                } else {
                    result.append(s.substring(0, segment.len));
                }
            }
            if (segment.text != null) {
                result.append(segment.text);
            }
            result.append('.');
        }
        result.append(s);
        return result.toString();
    }

    public static FormatStep loggerNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, String precision) {
        return Formatters.loggerNameFormatStep(leftJustify, minimumWidth, false, maximumWidth, precision);
    }

    public static FormatStep loggerNameFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth, String precision) {
        return new SegmentedFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, precision){

            @Override
            public String getSegmentedSubject(ExtLogRecord record) {
                return record.getLoggerName();
            }
        };
    }

    public static FormatStep classNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, String precision) {
        return Formatters.classNameFormatStep(leftJustify, minimumWidth, false, maximumWidth, precision);
    }

    public static FormatStep classNameFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth, String precision) {
        return new SegmentedFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, precision){

            @Override
            public String getSegmentedSubject(ExtLogRecord record) {
                return record.getSourceClassName();
            }
        };
    }

    public static FormatStep dateFormatStep(TimeZone timeZone, String formatString, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.dateFormatStep(timeZone, formatString, leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep dateFormatStep(final TimeZone timeZone, final String formatString, boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){
            private final ThreadLocal<SimpleDateFormat> holder;
            {
                super(x0, x1, x2, x3);
                this.holder = new ThreadLocal<SimpleDateFormat>(){

                    @Override
                    protected SimpleDateFormat initialValue() {
                        SimpleDateFormat dateFormat = new SimpleDateFormat(formatString == null ? "yyyy-MM-dd HH:mm:ss,SSS" : formatString);
                        dateFormat.setTimeZone(timeZone);
                        return dateFormat;
                    }
                };
            }

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(this.holder.get().format(new Date(record.getMillis())));
            }
        };
    }

    public static FormatStep dateFormatStep(String formatString, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.dateFormatStep(TimeZone.getDefault(), formatString, leftJustify, minimumWidth, maximumWidth);
    }

    public static FormatStep fileNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.fileNameFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep fileNameFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getSourceFileName());
            }
        };
    }

    public static FormatStep hostnameFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth, boolean qualified) {
        Map<String, String> env;
        Properties props;
        if (System.getSecurityManager() == null) {
            props = System.getProperties();
            env = System.getenv();
        } else {
            props = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

                @Override
                public Properties run() {
                    return System.getProperties();
                }
            });
            env = AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

                @Override
                public Map<String, String> run() {
                    return System.getenv();
                }
            });
        }
        final String hostname = Formatters.findHostname(props, env, qualified);
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(hostname);
            }
        };
    }

    public static FormatStep locationInformationFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.locationInformationFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep locationInformationFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                String fileName = record.getSourceFileName();
                int lineNumber = record.getSourceLineNumber();
                String className = record.getSourceClassName();
                String methodName = record.getSourceMethodName();
                builder.append(className).append('.').append(methodName);
                builder.append('(').append(fileName);
                if (lineNumber != -1) {
                    builder.append(':').append(lineNumber);
                }
                builder.append(')');
            }
        };
    }

    public static FormatStep lineNumberFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.lineNumberFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep lineNumberFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getSourceLineNumber());
            }
        };
    }

    public static FormatStep messageFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.messageFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep messageFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getFormattedMessage());
                Throwable t = record.getThrown();
                if (t != null) {
                    builder.append(": ");
                    t.printStackTrace(new PrintWriter(new StringBuilderWriter(builder)));
                }
            }
        };
    }

    public static FormatStep simpleMessageFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.simpleMessageFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep simpleMessageFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getFormattedMessage());
            }
        };
    }

    public static FormatStep exceptionFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, boolean extended) {
        return Formatters.exceptionFormatStep(leftJustify, minimumWidth, false, maximumWidth, extended);
    }

    public static FormatStep exceptionFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth, final boolean extended) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(final StringBuilder builder, final ExtLogRecord record) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Throwable t = record.getThrown();
                        if (t != null) {
                            Throwable cause;
                            HashMap cache;
                            builder.append(": ").append(t).append(NEW_LINE);
                            StackTraceElement[] stackTrace = t.getStackTrace();
                            HashMap hashMap = cache = extended ? new HashMap() : null;
                            if (extended) {
                                for (StackTraceElement element : stackTrace) {
                                    this.renderExtended(builder, element, cache);
                                }
                            } else {
                                for (StackTraceElement element : stackTrace) {
                                    this.renderTrivial(builder, element);
                                }
                            }
                            if ((cause = t.getCause()) != null) {
                                this.renderCause(builder, t, cause, cache, extended);
                            }
                        }
                        return null;
                    }
                });
            }

            private void renderTrivial(StringBuilder builder, StackTraceElement element) {
                builder.append("\tat ").append(element).append(NEW_LINE);
            }

            private void renderExtended(StringBuilder builder, StackTraceElement element, Map<String, String> cache) {
                builder.append("\tat ").append(element);
                String className = element.getClassName();
                String cached = cache.get(className);
                if (cached != null) {
                    builder.append(cached).append(NEW_LINE);
                    return;
                }
                int dotIdx = className.lastIndexOf(46);
                if (dotIdx == -1) {
                    builder.append(NEW_LINE);
                    return;
                }
                String packageName = className.substring(0, dotIdx);
                final Class<?> exceptionClass = this.guessClass(className);
                Package exceptionPackage = null;
                if (exceptionClass != null) {
                    exceptionPackage = exceptionClass.getPackage();
                }
                if (exceptionPackage == null) {
                    try {
                        exceptionPackage = Package.getPackage(packageName);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                String packageVersion = null;
                if (exceptionPackage != null) {
                    try {
                        packageVersion = exceptionPackage.getImplementationVersion();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (packageVersion == null) {
                        try {
                            packageVersion = exceptionPackage.getSpecificationVersion();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                URL resource = null;
                SecurityManager sm = System.getSecurityManager();
                final String classResourceName = className.replace('.', '/') + ".class";
                if (exceptionClass != null) {
                    try {
                        if (sm == null) {
                            CodeSource codeSource;
                            ProtectionDomain protectionDomain = exceptionClass.getProtectionDomain();
                            if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                                resource = codeSource.getLocation();
                            }
                        } else {
                            resource = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                                @Override
                                public URL run() {
                                    CodeSource codeSource;
                                    ProtectionDomain protectionDomain = exceptionClass.getProtectionDomain();
                                    if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                                        return codeSource.getLocation();
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (resource == null) {
                        try {
                            final ClassLoader exceptionClassLoader = exceptionClass.getClassLoader();
                            resource = sm == null ? (exceptionClassLoader == null ? ClassLoader.getSystemResource(classResourceName) : exceptionClassLoader.getResource(classResourceName)) : AccessController.doPrivileged(new PrivilegedAction<URL>(){

                                @Override
                                public URL run() {
                                    return exceptionClassLoader == null ? ClassLoader.getSystemResource(classResourceName) : exceptionClassLoader.getResource(classResourceName);
                                }
                            });
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                String jarName = Formatters.getJarName(resource, classResourceName);
                boolean started = false;
                StringBuilder tagBuilder = new StringBuilder();
                if (jarName != null) {
                    started = true;
                    tagBuilder.append(" [").append(jarName).append(':');
                }
                if (packageVersion != null) {
                    if (!started) {
                        tagBuilder.append(" [:");
                        started = true;
                    }
                    tagBuilder.append(packageVersion);
                }
                if (started) {
                    tagBuilder.append(']');
                    String tag = tagBuilder.toString();
                    cache.put(className, tag);
                    builder.append(tag);
                } else {
                    cache.put(className, "");
                }
                builder.append(NEW_LINE);
            }

            private Class<?> guessClass(String name) {
                try {
                    try {
                        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                        if (tccl != null) {
                            return Class.forName(name, false, tccl);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        return Class.forName(name);
                    }
                    catch (ClassNotFoundException e) {
                        return Class.forName(name, false, null);
                    }
                }
                catch (Throwable t) {
                    return null;
                }
            }

            private void renderCause(StringBuilder builder, Throwable t, Throwable cause, Map<String, String> cache, boolean extended2) {
                Throwable ourCause;
                int i;
                StackTraceElement[] causeStack = cause.getStackTrace();
                StackTraceElement[] currentStack = t.getStackTrace();
                int m = causeStack.length - 1;
                for (int n = currentStack.length - 1; m >= 0 && n >= 0 && causeStack[m].equals(currentStack[n]); --m, --n) {
                }
                int framesInCommon = causeStack.length - 1 - m;
                builder.append("Caused by: ").append(cause).append(NEW_LINE);
                if (extended2) {
                    for (i = 0; i <= m; ++i) {
                        this.renderExtended(builder, causeStack[i], cache);
                    }
                } else {
                    for (i = 0; i <= m; ++i) {
                        this.renderTrivial(builder, causeStack[i]);
                    }
                }
                if (framesInCommon != 0) {
                    builder.append("\t... ").append(framesInCommon).append(" more").append(NEW_LINE);
                }
                if ((ourCause = cause.getCause()) != null) {
                    this.renderCause(builder, cause, ourCause, cache, extended2);
                }
            }
        };
    }

    static String getJarName(URL resource, String classResourceName) {
        int endIdx;
        if (resource == null) {
            return null;
        }
        String path = resource.getPath();
        String protocol = resource.getProtocol();
        if ("jar".equals(protocol)) {
            int sepIdx = path.lastIndexOf("!/");
            if (sepIdx != -1) {
                String firstPart = path.substring(0, sepIdx);
                int lsIdx = Math.max(firstPart.lastIndexOf(47), firstPart.lastIndexOf(92));
                return firstPart.substring(lsIdx + 1);
            }
        } else if ("module".equals(protocol)) {
            return resource.getPath();
        }
        for (endIdx = path.lastIndexOf(classResourceName); endIdx >= 0; --endIdx) {
            char ch = path.charAt(endIdx);
            if (ch != '/' && ch != '\\' && ch != '?') continue;
            String firstPart = path.substring(0, endIdx);
            int lsIdx = Math.max(firstPart.lastIndexOf(47), firstPart.lastIndexOf(92));
            return firstPart.substring(lsIdx + 1);
        }
        endIdx = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        return path.substring(endIdx + 1);
    }

    public static FormatStep resourceKeyFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.resourceKeyFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep resourceKeyFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                String key = record.getResourceKey();
                if (key != null) {
                    builder.append(key);
                }
            }
        };
    }

    public static FormatStep methodNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.methodNameFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep methodNameFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getSourceMethodName());
            }
        };
    }

    public static FormatStep lineSeparatorFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.lineSeparatorFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep lineSeparatorFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(separatorString);
            }
        };
    }

    public static FormatStep levelFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.levelFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep levelFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                Level level = record.getLevel();
                builder.append(level.getName());
            }
        };
    }

    public static FormatStep localizedLevelFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.localizedLevelFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep localizedLevelFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                Level level = record.getLevel();
                builder.append(level.getResourceBundleName() != null ? level.getLocalizedName() : level.getName());
            }
        };
    }

    public static FormatStep relativeTimeFormatStep(long baseTime, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.relativeTimeFormatStep(baseTime, leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep relativeTimeFormatStep(final long baseTime, boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getMillis() - baseTime);
            }
        };
    }

    public static FormatStep threadFormatStep(String argument, boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        if (argument != null && THREAD_ID.equals(argument.toLowerCase(Locale.ROOT))) {
            return Formatters.threadIdFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth);
        }
        return Formatters.threadNameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth);
    }

    public static FormatStep threadIdFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getThreadID());
            }
        };
    }

    public static FormatStep threadNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.threadNameFormatStep(leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep threadNameFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getThreadName());
            }
        };
    }

    public static FormatStep ndcFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.ndcFormatStep(leftJustify, minimumWidth, false, maximumWidth, 0);
    }

    public static FormatStep ndcFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth, int count) {
        return new SegmentedFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, count){

            @Override
            public String getSegmentedSubject(ExtLogRecord record) {
                return record.getNdc();
            }
        };
    }

    public static FormatStep mdcFormatStep(String key, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.mdcFormatStep(key, leftJustify, minimumWidth, false, maximumWidth);
    }

    public static FormatStep mdcFormatStep(final String key, boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                String value = record.getMdc(key);
                if (value != null) {
                    builder.append(value);
                }
            }
        };
    }

    public static FormatStep formatColor(final ColorMap colors, final String color) {
        return new FormatStep(){

            @Override
            public void render(StringBuilder builder, ExtLogRecord record) {
                String code = colors.getCode(color, record.getLevel());
                if (code != null) {
                    builder.append(code);
                }
            }

            @Override
            public int estimateLength() {
                return 7;
            }
        };
    }

    public static FormatStep systemPropertyFormatStep(final String argument, boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
        if (argument == null) {
            throw new IllegalArgumentException("System property requires a key for the lookup");
        }
        return new JustifyingFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                String[] parts = argument.split("(?<!\\\\):");
                String key = parts[0];
                String value = System.getProperty(key);
                if (value == null && parts.length > 1) {
                    value = parts[1];
                }
                builder.append(value);
            }
        };
    }

    static Map<Integer, Segment> parsePatternSegments(String pattern) {
        HashMap<Integer, Segment> segments = new HashMap<Integer, Segment>();
        StringBuilder len = new StringBuilder();
        StringBuilder text = new StringBuilder();
        int pos = 0;
        for (char c : pattern.toCharArray()) {
            if (c >= '0' && c <= '9') {
                len.append(c);
                continue;
            }
            if (c == '.') {
                int i = len.length() > 0 ? Integer.parseInt(len.toString()) : 0;
                segments.put(++pos, new Segment(i, text.length() > 0 ? text.toString() : null));
                text = new StringBuilder();
                len = new StringBuilder();
                continue;
            }
            text.append(c);
        }
        if (len.length() > 0 || text.length() > 0) {
            int i = len.length() > 0 ? Integer.parseInt(len.toString()) : 0;
            segments.put(++pos, new Segment(i, text.length() > 0 ? text.toString() : null));
        }
        return Collections.unmodifiableMap(segments);
    }

    static Deque<String> parseCategorySegments(String category) {
        ArrayDeque<String> categorySegments = new ArrayDeque<String>();
        StringBuilder cat = new StringBuilder();
        for (char c : category.toCharArray()) {
            if (c == '.') {
                if (cat.length() > 0) {
                    categorySegments.add(cat.toString());
                    cat = new StringBuilder();
                    continue;
                }
                categorySegments.add("");
                continue;
            }
            cat.append(c);
        }
        if (cat.length() > 0) {
            categorySegments.add(cat.toString());
        }
        return categorySegments;
    }

    private static String findHostname(Properties props, Map<String, String> env, boolean qualified) {
        if (qualified) {
            return Formatters.findQualifiedHostname(props, env);
        }
        String hostname = props.getProperty("jboss.host.name");
        if (hostname == null) {
            String qualifiedHostname = Formatters.findQualifiedHostname(props, env);
            int index = qualifiedHostname.indexOf(46);
            hostname = index == -1 ? qualifiedHostname : qualifiedHostname.substring(0, index);
        }
        return hostname;
    }

    private static String findQualifiedHostname(Properties props, Map<String, String> env) {
        String qualifiedHostname = props.getProperty("jboss.qualified.host.name");
        if (qualifiedHostname == null) {
            qualifiedHostname = env.get("HOSTNAME");
            if (qualifiedHostname == null) {
                env.get("COMPUTERNAME");
            }
            if (qualifiedHostname == null) {
                try {
                    qualifiedHostname = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException ignore) {
                    qualifiedHostname = "unknown-host.unknown-domain";
                }
            }
        }
        return qualifiedHostname;
    }

    static class Segment {
        final int len;
        final String text;

        Segment(int len, String text) {
            this.len = len;
            this.text = text;
        }
    }

    private static abstract class SegmentedFormatStep
    extends JustifyingFormatStep {
        private final int count;
        private final String precision;

        protected SegmentedFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth, int count) {
            super(leftJustify, minimumWidth, truncateBeginning, maximumWidth);
            this.count = count;
            this.precision = null;
        }

        protected SegmentedFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth, String precision) {
            super(leftJustify, minimumWidth, truncateBeginning, maximumWidth);
            this.count = 0;
            this.precision = precision;
        }

        @Override
        public void renderRaw(StringBuilder builder, ExtLogRecord record) {
            if (this.precision == null) {
                builder.append(Formatters.applySegments(this.count, this.getSegmentedSubject(record)));
            } else {
                builder.append(Formatters.applySegments(this.precision, this.getSegmentedSubject(record)));
            }
        }

        public abstract String getSegmentedSubject(ExtLogRecord var1);
    }

    private static abstract class JustifyingFormatStep
    implements FormatStep {
        private final boolean leftJustify;
        private final boolean truncateBeginning;
        private final int minimumWidth;
        private final int maximumWidth;

        protected JustifyingFormatStep(boolean leftJustify, int minimumWidth, boolean truncateBeginning, int maximumWidth) {
            if (maximumWidth != 0 && minimumWidth > maximumWidth) {
                throw new IllegalArgumentException("Specified minimum width may not be greater than the specified maximum width");
            }
            if (maximumWidth < 0 || minimumWidth < 0) {
                throw new IllegalArgumentException("Minimum and maximum widths must not be less than zero");
            }
            this.leftJustify = leftJustify;
            this.truncateBeginning = truncateBeginning;
            this.minimumWidth = minimumWidth;
            this.maximumWidth = maximumWidth == 0 ? Integer.MAX_VALUE : maximumWidth;
        }

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
            int minimumWidth = this.minimumWidth;
            int maximumWidth = this.maximumWidth;
            boolean leftJustify = this.leftJustify;
            if (leftJustify) {
                int oldLen = builder.length();
                this.renderRaw(builder, record);
                int newLen = builder.length();
                int writtenLen = newLen - oldLen;
                int overflow = writtenLen - maximumWidth;
                if (overflow > 0) {
                    if (this.truncateBeginning) {
                        builder.delete(oldLen, overflow + 1);
                    }
                    builder.setLength(newLen - overflow);
                } else {
                    int spaces = minimumWidth - writtenLen;
                    for (int i = 0; i < spaces; ++i) {
                        builder.append(' ');
                    }
                }
            } else {
                StringBuilder subBuilder = new StringBuilder();
                this.renderRaw(subBuilder, record);
                int len = subBuilder.length();
                if (len > maximumWidth) {
                    if (this.truncateBeginning) {
                        int overflow = len - maximumWidth;
                        subBuilder.delete(0, overflow);
                    }
                    subBuilder.setLength(maximumWidth);
                } else if (len < minimumWidth) {
                    int spaces = minimumWidth - len;
                    for (int i = 0; i < spaces; ++i) {
                        builder.append(' ');
                    }
                }
                builder.append((CharSequence)subBuilder);
            }
        }

        @Override
        public int estimateLength() {
            int maximumWidth = this.maximumWidth;
            int minimumWidth = this.minimumWidth;
            if (maximumWidth != 0) {
                return Math.min(maximumWidth, minimumWidth * 3);
            }
            return Math.max(32, minimumWidth);
        }

        public abstract void renderRaw(StringBuilder var1, ExtLogRecord var2);
    }
}

