/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.Arrays;

final class ByteStringBuilder {
    private static final int INVALID_US_ASCII_CODE_POINT = 63;
    private static final int INVALID_UTF_8_CODE_POINT = 65533;
    private byte[] content;
    private int length;

    public ByteStringBuilder(int len) {
        this.content = new byte[len];
    }

    public ByteStringBuilder append(boolean b) {
        this.appendLatin1(Boolean.toString(b));
        return this;
    }

    public ByteStringBuilder append(char c) {
        return this.appendUtf8Raw((byte)c);
    }

    public static int getUtf8LengthOf(int c) {
        if (c < 128) {
            return 1;
        }
        if (c < 2048) {
            return 2;
        }
        if (c < 65536) {
            return 3;
        }
        if (c < 0x110000) {
            return 4;
        }
        return 1;
    }

    public ByteStringBuilder appendUtf8Raw(int codePoint) {
        if (codePoint < 0) {
            this.appendUtf8Raw(65533);
        } else if (codePoint < 128) {
            this.doAppend((byte)codePoint);
        } else if (codePoint < 2048) {
            this.doAppend((byte)(0xC0 | 0x1F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else if (codePoint < 65536) {
            this.doAppend((byte)(0xE0 | 0xF & codePoint >>> 12));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else if (codePoint < 0x110000) {
            this.doAppend((byte)(0xF0 | 7 & codePoint >>> 18));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 12));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else {
            this.appendUtf8Raw(65533);
        }
        return this;
    }

    public ByteStringBuilder append(byte[] bytes) {
        int length = this.length;
        int bl = bytes.length;
        this.reserve(bl, false);
        System.arraycopy(bytes, 0, this.content, length, bl);
        this.length = length + bl;
        return this;
    }

    public ByteStringBuilder append(byte[] bytes, int offs, int len) {
        this.reserve(len, false);
        int length = this.length;
        System.arraycopy(bytes, offs, this.content, length, len);
        this.length = length + len;
        return this;
    }

    public ByteStringBuilder appendUSASCII(String s) {
        return this.appendUSASCII(s, 0, s.length());
    }

    public ByteStringBuilder appendUSASCII(String s, int maxLen) {
        return this.appendASCII(128, s, 0, s.length(), maxLen);
    }

    public ByteStringBuilder appendUSASCII(String s, int offs, int len) {
        return this.appendASCII(128, s, offs, len, 0);
    }

    public ByteStringBuilder appendLatin1(String s) {
        return this.appendLatin1(s, 0, s.length());
    }

    public ByteStringBuilder appendLatin1(String s, int offs, int len) {
        return this.appendASCII(256, s, offs, len, 0);
    }

    public ByteStringBuilder append(String s) {
        return this.append(s, 0, s.length());
    }

    public ByteStringBuilder append(String s, int offs, int len) {
        int i = offs;
        while (i < len) {
            int c;
            if (Character.isHighSurrogate((char)(c = s.charAt(offs + i++)))) {
                char t;
                c = i < len ? (!Character.isLowSurrogate(t = s.charAt(offs + i++)) ? 65533 : Character.toCodePoint((char)c, t)) : 65533;
            }
            this.appendUtf8Raw(c);
        }
        return this;
    }

    public int write(String s, int limit) {
        int result = 0;
        int len = s.length();
        int i = 0;
        while (i < len) {
            int byteLen;
            int c = s.charAt(i);
            if (Character.isHighSurrogate((char)c)) {
                char t;
                c = i < len ? (!Character.isLowSurrogate(t = s.charAt(++i)) ? 65533 : Character.toCodePoint((char)c, t)) : 65533;
            }
            if (this.length + (byteLen = ByteStringBuilder.getUtf8LengthOf(c)) > limit) break;
            result = i++;
            this.appendUtf8Raw(c);
        }
        return result;
    }

    public ByteStringBuilder append(int i) {
        this.appendLatin1(Integer.toString(i));
        return this;
    }

    public ByteStringBuilder append(long l) {
        this.appendLatin1(Long.toString(l));
        return this;
    }

    public ByteStringBuilder append(ByteStringBuilder other) {
        this.append(other.content, 0, other.length);
        return this;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.content, this.length);
    }

    public byte byteAt(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.content[index];
    }

    public int capacity() {
        return this.content.length;
    }

    public int length() {
        return this.length;
    }

    public void setLength(int newLength) {
        if (newLength > this.length) {
            this.reserve(newLength - this.length, true);
        }
        this.length = newLength;
    }

    public boolean contentEquals(byte[] other) {
        return this.contentEquals(other, 0, other.length);
    }

    public boolean contentEquals(byte[] other, int offs, int length) {
        if (length != this.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.content[i] == other[offs + i]) continue;
            return false;
        }
        return true;
    }

    private ByteStringBuilder appendASCII(int asciiLen, String s, int offs, int len, int maxLen) {
        this.reserve(len, false);
        for (int i = 0; i < len && (maxLen >= 0 || i < maxLen); ++i) {
            char c = s.charAt(i + offs);
            if (c > asciiLen) {
                this.doAppendNoCheck((byte)63);
                continue;
            }
            this.doAppendNoCheck((byte)c);
        }
        return this;
    }

    private void reserve(int count, boolean clear) {
        byte[] content = this.content;
        int cl = content.length;
        int length = this.length;
        if (cl - length >= count) {
            if (clear) {
                Arrays.fill(content, length, length + count, (byte)0);
            }
            return;
        }
        if (clear) {
            Arrays.fill(content, length, cl, (byte)0);
        }
        do {
            if ((cl += cl + 1 >> 1) >= 0) continue;
            throw new IllegalStateException("Too large");
        } while (cl - length < count);
        this.content = Arrays.copyOf(content, cl);
    }

    private void doAppend(byte b) {
        int length = this.length;
        byte[] content = this.content;
        int cl = content.length;
        if (length == cl) {
            content = this.content = Arrays.copyOf(content, cl + (cl + 1 >> 1));
        }
        content[length] = b;
        this.length = length + 1;
    }

    private void doAppendNoCheck(byte b) {
        this.content[this.length++] = b;
    }
}

