/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class SuffixRotator {
    static final SuffixRotator EMPTY = new SuffixRotator("", "", "", CompressionType.NONE);
    private final String originalSuffix;
    private final String datePattern;
    private final SimpleDateFormat formatter;
    private final String compressionSuffix;
    private final CompressionType compressionType;

    private SuffixRotator(String originalSuffix, String datePattern, String compressionSuffix, CompressionType compressionType) {
        this.originalSuffix = originalSuffix;
        this.datePattern = datePattern;
        this.compressionSuffix = compressionSuffix;
        this.compressionType = compressionType;
        this.formatter = datePattern.isEmpty() ? null : new SimpleDateFormat(datePattern);
    }

    static SuffixRotator parse(String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return EMPTY;
        }
        String compressionSuffix = "";
        String datePattern = "";
        CompressionType compressionType = CompressionType.NONE;
        String lSuffix = suffix.toLowerCase(Locale.ROOT);
        int compressionIndex = lSuffix.indexOf(".gz");
        if (compressionIndex != -1) {
            compressionSuffix = suffix.substring(compressionIndex);
            datePattern = suffix.substring(0, compressionIndex);
            compressionType = CompressionType.GZIP;
        } else {
            compressionIndex = lSuffix.indexOf(".zip");
            if (compressionIndex != -1) {
                compressionSuffix = suffix.substring(compressionIndex);
                datePattern = suffix.substring(0, compressionIndex);
                compressionType = CompressionType.ZIP;
            }
        }
        if (compressionSuffix.isEmpty() && datePattern.isEmpty()) {
            return new SuffixRotator(suffix, suffix, "", CompressionType.NONE);
        }
        return new SuffixRotator(suffix, datePattern, compressionSuffix, compressionType);
    }

    String getDatePattern() {
        return this.datePattern;
    }

    String getCompressionSuffix() {
        return this.compressionSuffix;
    }

    CompressionType getCompressionType() {
        return this.compressionType;
    }

    void rotate(Path source, String suffix) throws IOException {
        Path target = Paths.get(source + suffix + this.compressionSuffix, new String[0]);
        if (this.compressionType == CompressionType.GZIP) {
            SuffixRotator.archiveGzip(source, target);
        } else if (this.compressionType == CompressionType.ZIP) {
            SuffixRotator.archiveZip(source, target);
        } else {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rotate(Path source, int maxBackupIndex) throws IOException {
        if (this.formatter == null) {
            this.rotate(source, "", maxBackupIndex);
        } else {
            String suffix;
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                suffix = this.formatter.format(new Date());
            }
            this.rotate(source, suffix, maxBackupIndex);
        }
    }

    void rotate(Path source, String suffix, int maxBackupIndex) throws IOException {
        if (maxBackupIndex > 0) {
            String rotationSuffix = suffix == null ? "" : suffix;
            String fileWithSuffix = source.toAbsolutePath() + rotationSuffix;
            Files.deleteIfExists(Paths.get(fileWithSuffix + "." + maxBackupIndex + this.compressionSuffix, new String[0]));
            for (int i = maxBackupIndex - 1; i >= 1; --i) {
                Path src = Paths.get(fileWithSuffix + "." + i + this.compressionSuffix, new String[0]);
                if (!Files.exists(src, new LinkOption[0])) continue;
                Path target = Paths.get(fileWithSuffix + "." + (i + 1) + this.compressionSuffix, new String[0]);
                Files.move(src, target, StandardCopyOption.REPLACE_EXISTING);
            }
            this.rotate(source, rotationSuffix + ".1");
        } else if (suffix != null && !suffix.isEmpty()) {
            this.rotate(source, suffix);
        }
    }

    public String toString() {
        return this.originalSuffix;
    }

    private static void archiveGzip(Path source, Path target) throws IOException {
        byte[] buff = new byte[512];
        try (GZIPOutputStream out = new GZIPOutputStream(Files.newOutputStream(target, new OpenOption[0]), true);){
            try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
                int len;
                while ((len = in.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
            }
            out.finish();
        }
    }

    private static void archiveZip(Path source, Path target) throws IOException {
        byte[] buff = new byte[512];
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(target, new OpenOption[0]), StandardCharsets.UTF_8);){
            ZipEntry entry = new ZipEntry(source.getFileName().toString());
            out.putNextEntry(entry);
            try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
                int len;
                while ((len = in.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
            }
            out.closeEntry();
        }
    }

    public static enum CompressionType {
        NONE,
        GZIP,
        ZIP;

    }
}

