/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.Writer;
import java.util.logging.Formatter;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class WriterHandler
extends ExtHandler {
    protected final Object outputLock = new Object();
    private volatile boolean checkHeadEncoding = true;
    private volatile boolean checkTailEncoding = true;
    private Writer writer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPublish(ExtLogRecord record) {
        String formatted;
        Formatter formatter = this.getFormatter();
        try {
            formatted = formatter.format(record);
        }
        catch (Exception ex) {
            this.reportError("Formatting error", ex, 5);
            return;
        }
        if (formatted.length() == 0) {
            return;
        }
        try {
            Object ex = this.outputLock;
            synchronized (ex) {
                if (this.writer == null) {
                    return;
                }
                this.preWrite(record);
                Writer writer = this.writer;
                if (writer == null) {
                    return;
                }
                writer.write(formatted);
                super.doPublish(record);
            }
        }
        catch (Exception ex) {
            this.reportError("Error writing log message", ex, 1);
            return;
        }
    }

    public boolean isCheckHeadEncoding() {
        return this.checkHeadEncoding;
    }

    public WriterHandler setCheckHeadEncoding(boolean checkHeadEncoding) {
        this.checkHeadEncoding = checkHeadEncoding;
        return this;
    }

    public boolean isCheckTailEncoding() {
        return this.checkTailEncoding;
    }

    public WriterHandler setCheckTailEncoding(boolean checkTailEncoding) {
        this.checkTailEncoding = checkTailEncoding;
        return this;
    }

    protected void preWrite(ExtLogRecord record) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriter(Writer writer) {
        WriterHandler.checkAccess(this);
        Writer oldWriter = null;
        boolean ok = false;
        try {
            Object object = this.outputLock;
            synchronized (object) {
                oldWriter = this.writer;
                if (oldWriter != null) {
                    this.writeTail(oldWriter);
                    this.safeFlush(oldWriter);
                }
                if (writer != null) {
                    this.writer = new BufferedWriter(writer);
                    this.writeHead(this.writer);
                } else {
                    this.writer = null;
                }
                ok = true;
            }
            this.safeClose(oldWriter);
            if (!ok) {
                this.safeClose(writer);
            }
        }
        catch (Throwable throwable) {
            this.safeClose(oldWriter);
            if (!ok) {
                this.safeClose(writer);
            }
            throw throwable;
        }
    }

    private void writeHead(Writer writer) {
        try {
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                String head = formatter.getHead(this);
                if (this.checkHeadEncoding && !this.getCharset().newEncoder().canEncode(head)) {
                    this.reportError("Section header cannot be encoded into charset \"" + this.getCharset().name() + "\"", null, 0);
                    return;
                }
                writer.write(head);
            }
        }
        catch (Exception e) {
            this.reportError("Error writing section header", e, 1);
        }
    }

    private void writeTail(Writer writer) {
        try {
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                String tail = formatter.getTail(this);
                if (this.checkTailEncoding && !this.getCharset().newEncoder().canEncode(tail)) {
                    this.reportError("Section tail cannot be encoded into charset \"" + this.getCharset().name() + "\"", null, 0);
                    return;
                }
                writer.write(tail);
            }
        }
        catch (Exception ex) {
            this.reportError("Error writing section tail", ex, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.outputLock;
        synchronized (object) {
            this.safeFlush(this.writer);
        }
        super.flush();
    }

    @Override
    public void close() throws SecurityException {
        WriterHandler.checkAccess(this);
        this.setWriter(null);
        super.close();
    }

    protected void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            this.reportError("Error closing resource", e, 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void safeFlush(Flushable f) {
        try {
            if (f != null) {
                f.flush();
            }
        }
        catch (Exception e) {
            this.reportError("Error on flush", e, 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

