/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.configuration;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.expression.Expression;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.configuration.ContextConfiguration;
import org.jboss.logmanager.configuration.ObjectBuilder;
import org.jboss.logmanager.configuration.filters.FilterExpressions;
import org.jboss.logmanager.filters.AcceptAllFilter;
import org.jboss.logmanager.filters.DenyAllFilter;

public class PropertyConfigurator {
    private static final String[] EMPTY_STRINGS = new String[0];
    private final LogContext logContext;
    private final Properties properties;
    private final ContextConfiguration contextConfiguration;

    private PropertyConfigurator(LogContext logContext, Properties properties) {
        this.logContext = logContext;
        this.properties = properties;
        ContextConfiguration config = new ContextConfiguration();
        ContextConfiguration current = logContext.attachIfAbsent(ContextConfiguration.CONTEXT_CONFIGURATION_KEY, config);
        this.contextConfiguration = current == null ? config : current;
    }

    public static void configure(LogContext logContext, Properties properties) {
        PropertyConfigurator config = new PropertyConfigurator((LogContext)Assert.checkNotNullParam((String)"logContext", (Object)logContext), (Properties)Assert.checkNotNullParam((String)"properties", (Object)properties));
        config.doConfigure();
    }

    private void doConfigure() {
        for (String pojoName : this.getStringCsvArray("pojos")) {
            this.configurePojos(pojoName);
        }
        this.configureLogger("");
        for (String loggerName : this.getStringCsvArray("loggers")) {
            this.configureLogger(loggerName);
        }
        for (String handlerName : this.getStringCsvArray("handlers")) {
            this.configureHandler(handlerName);
        }
        for (String filterName : this.getStringCsvArray("filters")) {
            this.configureFilter(filterName);
        }
        for (String formatterName : this.getStringCsvArray("formatters")) {
            this.configureFormatter(formatterName);
        }
        for (String errorManagerName : this.getStringCsvArray("errorManagers")) {
            this.configureErrorManager(errorManagerName);
        }
    }

    private void configureLogger(String loggerName) {
        String useParentFiltersString;
        String[] handlerNames;
        String filterName;
        Logger logger = this.logContext.getLogger(loggerName);
        String levelName = this.getStringProperty(PropertyConfigurator.getKey("logger", loggerName, "level"));
        if (levelName != null) {
            ((java.util.logging.Logger)logger).setLevel(Level.parse(levelName));
        }
        if ((filterName = this.getStringProperty(PropertyConfigurator.getKey("logger", loggerName, "filter"))) != null && this.configureFilter(filterName)) {
            ((java.util.logging.Logger)logger).setFilter(this.contextConfiguration.getFilter(filterName));
        }
        for (String name : handlerNames = this.getStringCsvArray(PropertyConfigurator.getKey("logger", loggerName, "handlers"))) {
            if (!this.configureHandler(name)) continue;
            ((java.util.logging.Logger)logger).addHandler(this.contextConfiguration.getHandler(name));
        }
        String useParentHandlersString = this.getStringProperty(PropertyConfigurator.getKey("logger", loggerName, "useParentHandlers"));
        if (useParentHandlersString != null) {
            ((java.util.logging.Logger)logger).setUseParentHandlers(PropertyConfigurator.resolveBooleanExpression(useParentHandlersString));
        }
        if ((useParentFiltersString = this.getStringProperty(PropertyConfigurator.getKey("logger", loggerName, "useParentFilters"))) != null && logger instanceof Logger) {
            logger.setUseParentFilters(PropertyConfigurator.resolveBooleanExpression(useParentHandlersString));
        }
    }

    private boolean configureHandler(String handlerName) {
        String[] handlerNames;
        String errorManagerName;
        String formatterName;
        String levelName;
        String filter;
        if (this.contextConfiguration.hasHandler(handlerName)) {
            return true;
        }
        String className = this.getStringProperty(PropertyConfigurator.getKey("handler", handlerName), true, false);
        if (className == null) {
            StandardOutputStreams.printError("Handler %s is not defined%n", handlerName);
            return false;
        }
        ObjectBuilder<Handler> handlerBuilder = ObjectBuilder.of(this.logContext, this.contextConfiguration, Handler.class, className).setModuleName(this.getStringProperty(PropertyConfigurator.getKey("handler", handlerName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyConfigurator.getKey("handler", handlerName, "postConfiguration")));
        this.configureProperties(handlerBuilder, "handler", handlerName);
        String encoding = this.getStringProperty(PropertyConfigurator.getKey("handler", handlerName, "encoding"));
        if (encoding != null) {
            handlerBuilder.addProperty("encoding", encoding);
        }
        if ((filter = this.getStringProperty(PropertyConfigurator.getKey("handler", handlerName, "filter"))) != null && this.configureFilter(filter)) {
            handlerBuilder.addDefinedProperty("filter", Filter.class, this.contextConfiguration.getFilters().get(filter));
        }
        if ((levelName = this.getStringProperty(PropertyConfigurator.getKey("handler", handlerName, "level"))) != null) {
            handlerBuilder.addProperty("level", levelName);
        }
        if ((formatterName = this.getStringProperty(PropertyConfigurator.getKey("handler", handlerName, "formatter"))) != null && this.configureFormatter(formatterName)) {
            handlerBuilder.addDefinedProperty("formatter", Formatter.class, this.contextConfiguration.getFormatters().get(formatterName));
        }
        if ((errorManagerName = this.getStringProperty(PropertyConfigurator.getKey("handler", handlerName, "errorManager"))) != null && this.configureErrorManager(errorManagerName)) {
            handlerBuilder.addDefinedProperty("errorManager", ErrorManager.class, this.contextConfiguration.getErrorManagers().get(errorManagerName));
        }
        if ((handlerNames = this.getStringCsvArray(PropertyConfigurator.getKey("handler", handlerName, "handlers"))).length > 0) {
            final ArrayList<Supplier<Handler>> subhandlers = new ArrayList<Supplier<Handler>>();
            for (String name : handlerNames) {
                if (!this.configureHandler(name)) continue;
                subhandlers.add(this.contextConfiguration.getHandlers().get(name));
            }
            handlerBuilder.addDefinedProperty("handlers", Handler[].class, new Supplier<Handler[]>(){

                @Override
                public Handler[] get() {
                    if (subhandlers.isEmpty()) {
                        return new Handler[0];
                    }
                    Handler[] result = new Handler[subhandlers.size()];
                    int i = 0;
                    for (Supplier supplier : subhandlers) {
                        result[i++] = (Handler)supplier.get();
                    }
                    return result;
                }
            });
        }
        this.contextConfiguration.addHandler(handlerName, handlerBuilder.build());
        return true;
    }

    private boolean configureFormatter(String formatterName) {
        if (this.contextConfiguration.hasFilter(formatterName)) {
            return true;
        }
        String className = this.getStringProperty(PropertyConfigurator.getKey("formatter", formatterName), true, false);
        if (className == null) {
            StandardOutputStreams.printError("Formatter %s is not defined%n", formatterName);
            return false;
        }
        ObjectBuilder<Formatter> formatterBuilder = ObjectBuilder.of(this.logContext, this.contextConfiguration, Formatter.class, className).setModuleName(this.getStringProperty(PropertyConfigurator.getKey("formatter", formatterName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyConfigurator.getKey("formatter", formatterName, "postConfiguration")));
        this.configureProperties(formatterBuilder, "formatter", formatterName);
        this.contextConfiguration.addFormatter(formatterName, formatterBuilder.build());
        return true;
    }

    private boolean configureErrorManager(String errorManagerName) {
        if (this.contextConfiguration.hasErrorManager(errorManagerName)) {
            return true;
        }
        String className = this.getStringProperty(PropertyConfigurator.getKey("errorManager", errorManagerName), true, false);
        if (className == null) {
            StandardOutputStreams.printError("Error manager %s is not defined%n", errorManagerName);
            return false;
        }
        ObjectBuilder<ErrorManager> errorManagerBuilder = ObjectBuilder.of(this.logContext, this.contextConfiguration, ErrorManager.class, className).setModuleName(this.getStringProperty(PropertyConfigurator.getKey("errorManager", errorManagerName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyConfigurator.getKey("errorManager", errorManagerName, "postConfiguration")));
        this.configureProperties(errorManagerBuilder, "errorManager", errorManagerName);
        this.contextConfiguration.addErrorManager(errorManagerName, errorManagerBuilder.build());
        return true;
    }

    private boolean configureFilter(String filterName) {
        if (this.contextConfiguration.hasFilter(filterName)) {
            return true;
        }
        String filterValue = this.getStringProperty(PropertyConfigurator.getKey("filter", filterName), true, false);
        if (filterValue == null) {
            this.contextConfiguration.addFilter(filterName, () -> FilterExpressions.parse(this.logContext, filterName));
        } else if (AcceptAllFilter.class.getName().equals(filterValue)) {
            this.contextConfiguration.addFilter(filterName, AcceptAllFilter::getInstance);
        } else if (DenyAllFilter.class.getName().equals(filterValue)) {
            this.contextConfiguration.addFilter(filterName, DenyAllFilter::getInstance);
        } else {
            ObjectBuilder<Filter> filterBuilder = ObjectBuilder.of(this.logContext, this.contextConfiguration, Filter.class, filterValue).setModuleName(this.getStringProperty(PropertyConfigurator.getKey("filter", filterName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyConfigurator.getKey("filter", filterName, "postConfiguration")));
            this.configureProperties(filterBuilder, "errorManager", filterName);
            this.contextConfiguration.addFilter(filterName, filterBuilder.build());
        }
        return true;
    }

    private void configurePojos(String pojoName) {
        if (this.contextConfiguration.hasObject(pojoName)) {
            return;
        }
        String className = this.getStringProperty(PropertyConfigurator.getKey("pojo", pojoName), true, false);
        if (className == null) {
            StandardOutputStreams.printError("POJO %s is not defined%n", pojoName);
            return;
        }
        ObjectBuilder<Object> pojoBuilder = ObjectBuilder.of(this.logContext, this.contextConfiguration, Object.class, className).setModuleName(this.getStringProperty(PropertyConfigurator.getKey("pojo", pojoName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyConfigurator.getKey("pojo", pojoName, "postConfiguration")));
        this.configureProperties(pojoBuilder, "pojo", pojoName);
        this.contextConfiguration.addObject(pojoName, pojoBuilder.build());
    }

    private String getStringProperty(String key) {
        return this.getStringProperty(key, true, true);
    }

    private String getStringProperty(String key, boolean trim, boolean resolveExpression) {
        String value = this.properties.getProperty(key);
        if (resolveExpression && value != null) {
            value = PropertyConfigurator.resolveExpression(value);
        } else if (value != null && trim) {
            value = value.trim();
        }
        return value;
    }

    private String[] getStringCsvArray(String key) {
        String property = this.properties.getProperty(key, "");
        if (property == null) {
            return EMPTY_STRINGS;
        }
        String value = property.trim();
        if (value.length() == 0) {
            return EMPTY_STRINGS;
        }
        return value.split("\\s*,\\s*");
    }

    private void configureProperties(ObjectBuilder<?> builder, String prefix, String name) {
        String[] propertyNames;
        String[] constructorPropertyNames;
        for (String propertyName : constructorPropertyNames = this.getStringCsvArray(PropertyConfigurator.getKey(prefix, name, "constructorProperties"))) {
            String valueString = this.getStringProperty(PropertyConfigurator.getKey(prefix, name, propertyName), false, true);
            if (valueString == null) continue;
            builder.addConstructorProperty(propertyName, valueString);
        }
        for (String propertyName : propertyNames = this.getStringCsvArray(PropertyConfigurator.getKey(prefix, name, "properties"))) {
            String valueString = this.getStringProperty(PropertyConfigurator.getKey(prefix, name, propertyName), false, true);
            if (valueString == null) continue;
            builder.addProperty(propertyName, valueString);
        }
    }

    private static String getKey(String prefix, String objectName) {
        return objectName.length() > 0 ? prefix + "." + objectName : prefix;
    }

    private static String getKey(String prefix, String objectName, String key) {
        return objectName.length() > 0 ? prefix + "." + objectName + "." + key : prefix + "." + key;
    }

    private static boolean resolveBooleanExpression(String possibleExpression) {
        String value = PropertyConfigurator.resolveExpression(possibleExpression);
        return !value.toLowerCase(Locale.ROOT).equals("false");
    }

    private static String resolveExpression(String possibleExpression) {
        EnumSet<Expression.Flag> flags = EnumSet.noneOf(Expression.Flag.class);
        Expression expression = Expression.compile((String)possibleExpression, flags);
        return expression.evaluateWithPropertiesAndEnvironment(false);
    }
}

