/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectImpl
implements MutableManagedObject {
    private static final long serialVersionUID = 2L;
    private String name;
    private String nameType;
    private String attachmentName;
    private transient Object attachment;
    private Map<String, Annotation> annotations = Collections.emptyMap();
    private Map<String, ManagedProperty> properties;
    private Set<ManagedOperation> operations;
    private ManagedObject parent;
    private transient Object componentName;
    private transient Map<String, Object> transientAttachments;

    public ManagedObjectImpl(String name) {
        this(name, name, null, ManagedObjectImpl.toMap(null), new HashSet<ManagedOperation>(), null);
    }

    public ManagedObjectImpl(String name, Set<ManagedProperty> properties) {
        this(name, name, null, properties, new HashSet<ManagedOperation>(), null);
    }

    public ManagedObjectImpl(String name, Set<ManagedProperty> properties, HashSet<ManagedOperation> operations) {
        this(name, name, null, properties, operations, null);
    }

    public ManagedObjectImpl(String name, String nameType, String attachmentName, Set<ManagedProperty> properties, HashSet<ManagedOperation> operations, Serializable attachment) {
        this(name, nameType, attachmentName, ManagedObjectImpl.toMap(properties), operations, attachment);
    }

    public ManagedObjectImpl(String name, String nameType, String attachmentName, Map<String, ManagedProperty> properties, HashSet<ManagedOperation> operations, Serializable attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Null properties");
        }
        this.name = name;
        this.nameType = nameType;
        this.attachmentName = attachmentName;
        this.properties = properties;
        this.operations = operations;
        this.setAttachment(attachment);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNameType() {
        return this.nameType;
    }

    public void setNameType(String nameType) {
        this.nameType = nameType;
    }

    @Override
    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    @Override
    public Map<String, Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, Annotation> annotations) {
        if (this.annotations.isEmpty()) {
            this.annotations = new HashMap<String, Annotation>();
        } else {
            this.annotations.clear();
        }
        this.annotations.putAll(annotations);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public ManagedProperty getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return this.properties.get(name);
    }

    @Override
    public Map<String, ManagedProperty> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, ManagedProperty> properties) {
        this.properties = properties;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public Set<ManagedOperation> getOperations() {
        return this.operations;
    }

    @Override
    public void setOperations(Set<ManagedOperation> operations) {
        this.operations = operations;
    }

    @Override
    public ManagedObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ManagedObject parent) {
        this.parent = parent;
    }

    @Override
    public Object getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(Object name) {
        this.componentName = name;
    }

    @Override
    public <T> T getTransientAttachment(Class<T> expectedType) {
        T tvalue = null;
        Object value = this.getTransientAttachment(expectedType.getName());
        if (value != null) {
            tvalue = expectedType.cast(value);
        }
        return tvalue;
    }

    @Override
    public Object getTransientAttachment(String name) {
        Object value = null;
        if (this.transientAttachments != null) {
            value = this.transientAttachments.get(name);
        }
        return value;
    }

    @Override
    public synchronized void setTransientAttachment(String name, Object attachment) {
        if (this.transientAttachments == null) {
            this.transientAttachments = new HashMap<String, Object>();
        }
        this.transientAttachments.put(name, attachment);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ManagedObject)) {
            return false;
        }
        ManagedObject other = (ManagedObject)obj;
        return this.getName().equals(other.getName()) && ((Object)this.getProperties()).equals(other.getProperties());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "ManagedObject{" + this.name + "}";
    }

    protected void toString(StringBuilder sb) {
        sb.append("name=");
        sb.append(this.name);
        sb.append(", nameType=");
        sb.append(this.nameType);
        sb.append(", attachmentName=");
        sb.append(this.attachmentName);
        sb.append(", properties=");
        sb.append(this.properties);
    }

    private static Map<String, ManagedProperty> toMap(Set<ManagedProperty> props) {
        HashMap<String, ManagedProperty> properties = new HashMap<String, ManagedProperty>();
        if (props != null && !props.isEmpty()) {
            for (ManagedProperty prop : props) {
                properties.put(prop.getName(), prop);
            }
        }
        return properties;
    }
}

