/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedPropertyImpl
implements ManagedProperty {
    private static final long serialVersionUID = 2L;
    private static final int VERSION1 = 1;
    private static final int STREAM_VERSION = 1;
    private ManagedObject managedObject;
    private ManagedObject targetManagedObject;
    private Fields fields;
    private transient String name;
    private transient Map<String, Object> transientAttachments;

    public ManagedPropertyImpl(String name) {
        this(null, new DefaultFieldsImpl(name));
    }

    public ManagedPropertyImpl(Fields fields) {
        this(null, fields);
    }

    public ManagedPropertyImpl(ManagedObject managedObject, Fields fields) {
        this.init(managedObject, fields);
    }

    @Override
    public ManagedObject getManagedObject() {
        return this.managedObject;
    }

    @Override
    public void setManagedObject(ManagedObject managedObject) {
        this.managedObject = managedObject;
    }

    @Override
    public ManagedObject getTargetManagedObject() {
        return this.targetManagedObject;
    }

    @Override
    public void setTargetManagedObject(ManagedObject target) {
        this.targetManagedObject = target;
    }

    @Override
    public Fields getFields() {
        return this.fields;
    }

    @Override
    public <T> T getField(String fieldName, Class<T> expected) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Null field name");
        }
        if (expected == null) {
            throw new IllegalArgumentException("Null expected type");
        }
        Object field = this.getFields().getField(fieldName);
        if (field == null) {
            return null;
        }
        if (expected.isInstance(field)) {
            return expected.cast(field);
        }
        if (field instanceof SimpleValue) {
            SimpleValue value = (SimpleValue)field;
            Serializable result = value.getValue();
            if (result == null) {
                return null;
            }
            return expected.cast(result);
        }
        throw new IllegalStateException("Field " + fieldName + " with value " + field + " is not of the expected type: " + expected.getName());
    }

    @Override
    public void setField(String fieldName, Serializable value) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Null field name");
        }
        this.getFields().setField(fieldName, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMappedName() {
        return this.getField("mappedName", String.class);
    }

    @Override
    public String getDescription() {
        return this.getField("description", String.class);
    }

    public void setDescription(String description) {
        this.setField("description", (Serializable)((Object)description));
    }

    @Override
    public Map<String, Annotation> getAnnotations() {
        Object set = this.getField("annotations", Object.class);
        return (Map)set;
    }

    public void setAnnotations(Map<String, Annotation> annotations) {
        this.setField("annotations", (Serializable)((Object)annotations));
    }

    @Override
    public boolean hasViewUse(ViewUse use) {
        boolean hasViewUse = false;
        ViewUse[] uses = this.getViewUse();
        if (uses != null) {
            for (ViewUse vu : uses) {
                hasViewUse |= vu == use;
            }
        }
        return hasViewUse;
    }

    @Override
    public MetaType getMetaType() {
        return this.getField("metaType", MetaType.class);
    }

    public void setMetaType(MetaType type) {
        this.setField("metaType", (Serializable)type);
    }

    @Override
    public MetaValue getValue() {
        return this.getField("value", MetaValue.class);
    }

    @Override
    public void setValue(MetaValue value) {
        this.setField("value", (Serializable)value);
    }

    public ViewUse[] getViewUse() {
        ViewUse[] use = new ViewUse[]{};
        ViewUse[] useField = this.getField("viewUse", ViewUse[].class);
        Map<String, Annotation> annotations = this.getAnnotations();
        if (annotations != null) {
            ManagementProperty mp = (ManagementProperty)annotations.get(ManagementProperty.class.getName());
            if (mp != null) {
                use = mp.use();
                if (useField != null && useField.length > 0) {
                    HashSet<ViewUse> uses = new HashSet<ViewUse>();
                    for (ViewUse vu : use) {
                        uses.add(vu);
                    }
                    for (ViewUse vu : useField) {
                        uses.add(vu);
                    }
                    use = new ViewUse[uses.size()];
                    uses.toArray(use);
                }
            }
        } else if (useField != null) {
            use = useField;
        }
        return use;
    }

    public void setViewUse(ViewUse[] use) {
        this.setField("viewUse", (Serializable)use);
    }

    @Override
    public Set<MetaValue> getLegalValues() {
        return this.getField("legalValues", Set.class);
    }

    public void setLegalValues(Set<MetaValue> values) {
        this.setField("legalValues", (Serializable)((Object)values));
    }

    public Comparable<MetaValue> getMinimumValue() {
        return this.getField("minValue", Comparable.class);
    }

    public void setMinimumValue(Comparable<MetaValue> value) {
        this.setField("minValue", (Serializable)((Object)value));
    }

    public Comparable<MetaValue> getMaximumValue() {
        Comparable field = this.getField("maxValue", Comparable.class);
        return field;
    }

    public void setMaximumValue(Comparable<MetaValue> value) {
        this.setField("maxValue", (Serializable)((Object)value));
    }

    @Override
    public String checkValidValue(MetaValue value) {
        Comparable<MetaValue> min = this.getMinimumValue();
        if (min != null && min.compareTo(value) > 0) {
            return "min(" + min + ") > " + value;
        }
        Comparable<MetaValue> max = this.getMaximumValue();
        if (max != null && max.compareTo(value) < 0) {
            return "max(" + max + ") < " + value;
        }
        Set<MetaValue> legalValues = this.getLegalValues();
        if (legalValues != null && legalValues.size() > 0 && !legalValues.contains(value)) {
            return legalValues + " does not contain: " + value;
        }
        return null;
    }

    @Override
    public boolean isMandatory() {
        Boolean result = this.getField("mandatory", Boolean.class);
        if (result == null) {
            return false;
        }
        return result;
    }

    @Override
    public boolean isModified() {
        Boolean result = this.getField("modified", Boolean.class);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void setModified(boolean flag) {
        if (flag) {
            this.setField("modified", Boolean.valueOf(flag));
        } else {
            this.setField("modified", null);
        }
    }

    public void setMandatory(boolean flag) {
        if (flag) {
            this.setField("mandatory", Boolean.valueOf(flag));
        } else {
            this.setField("mandatory", null);
        }
    }

    @Override
    public boolean isRemoved() {
        Boolean result = this.getField("removed", Boolean.class);
        if (result == null) {
            return false;
        }
        return result;
    }

    @Override
    public void setRemoved(boolean flag) {
        if (flag) {
            this.setField("removed", Boolean.valueOf(flag));
        } else {
            this.setField("removed", null);
        }
    }

    @Override
    public <T> T getTransientAttachment(Class<T> expectedType) {
        T tvalue = null;
        Object value = this.getTransientAttachment(expectedType.getName());
        if (value != null) {
            tvalue = expectedType.cast(value);
        }
        return tvalue;
    }

    @Override
    public Object getTransientAttachment(String name) {
        Object value = null;
        if (this.transientAttachments != null) {
            value = this.transientAttachments.get(name);
        }
        return value;
    }

    @Override
    public synchronized void setTransientAttachment(String name, Object attachment) {
        if (this.transientAttachments == null) {
            this.transientAttachments = new HashMap<String, Object>();
        }
        this.transientAttachments.put(name, attachment);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("ManagedProperty");
        tmp.append('{');
        tmp.append(this.name);
        if (this.getMappedName() != null) {
            tmp.append(',');
            tmp.append(this.getMappedName());
        }
        tmp.append(",metaType=");
        tmp.append(this.getMetaType());
        tmp.append('}');
        return tmp.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ManagedProperty)) {
            return false;
        }
        ManagedProperty other = (ManagedProperty)obj;
        return this.getName().equals(other.getName());
    }

    private void init(ManagedObject managedObject, Fields fields) {
        if (fields == null) {
            throw new IllegalArgumentException("Null fields");
        }
        this.managedObject = managedObject;
        this.fields = fields;
        this.name = this.getField("name", String.class);
        if (this.name == null) {
            throw new IllegalArgumentException("No name in fields");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1) {
            throw new InvalidObjectException("Unknown version=" + version);
        }
        this.readVersion1(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.fields);
        out.writeObject(this.managedObject);
        out.writeObject(this.targetManagedObject);
    }

    private void readVersion1(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.fields = (Fields)in.readObject();
        this.name = this.getField("name", String.class);
        if (this.name == null) {
            throw new IOException("No name in fields");
        }
        this.managedObject = (ManagedObject)in.readObject();
        this.targetManagedObject = (ManagedObject)in.readObject();
    }
}

