/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.factory;

import java.util.HashMap;
import java.util.Map;

import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.RunStateMapper;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/**
 * A RunStateMapper implementation that maps string based meta values to
 * the RunState enum based on a Map<String,String> of meta value to enum
 * string.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 84191 $
 */
public class StringRunStateMapper implements RunStateMapper
{
   private Map<String, String> valueMapping = new HashMap<String, String>();

   public StringRunStateMapper()
   {
      
   }
   public StringRunStateMapper(String[] valueStrings, String[] enumStrings)
   {
      for(int n = 0; n < valueStrings.length; n ++)
      {
         String value = valueStrings[n];
         String enums = enumStrings[n];
         valueMapping.put(value, enums);
      }
   }

   public Map<String, String> getValueMapping()
   {
      return valueMapping;
   }
   public void setValueMapping(Map<String, String> valueMapping)
   {
      this.valueMapping = valueMapping;
   }

   public RunState getRunState(ManagedProperty property, MetaValue value)
   {
      RunState state = RunState.UNKNOWN;
      if ( value.getMetaType().isSimple() )
      {
         SimpleValue sv = SimpleValue.class.cast(value);
         String s = sv.getValue().toString();
         String es = valueMapping.get(s);
         if(es != null)
         {
            state = RunState.valueOf(es);
         }
      }
      else if (value.getMetaType().isEnum() )
      {
         
      }
      return state;
   }

}
