/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.mc;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.reloaded.naming.spi.JavaEEModule;

public class JNDIBinder {
    private static Logger logger = Logger.getLogger(JNDIBinder.class);
    private JavaEEModule javaeeModule;
    private String jndiName;
    private Object jndiObject;
    private boolean bound;
    private boolean javaAppBinder;

    public JNDIBinder(String jndiName, Object obj) {
        this(jndiName, obj, false);
    }

    public JNDIBinder(String jndiName, Object obj, boolean javaAppBinder) {
        this.jndiName = jndiName;
        this.jndiObject = obj;
        this.javaAppBinder = javaAppBinder;
    }

    @Start
    public void bind() throws NamingException {
        Context ctx = this.getContext();
        if (ctx == null) {
            throw new IllegalStateException("JNDI context is null, cannot bind jndi name " + this.jndiName);
        }
        logger.info((Object)("Binding Managed Bean in jndi namespace " + this.getNamespace() + " at jndiname " + this.jndiName));
        Util.bind((Context)ctx, (String)this.jndiName, (Object)this.jndiObject);
        this.bound = true;
    }

    @Stop
    public void unbind() throws NamingException {
        if (!this.bound) {
            return;
        }
        Context ctx = this.getContext();
        if (ctx == null) {
            throw new IllegalStateException("JNDI context is null, cannot unbind from jndi name " + this.jndiName);
        }
        logger.info((Object)("Unbinding Managed Bean from jndi namespace " + this.getNamespace() + " at jndiname " + this.jndiName));
        ctx.unbind(this.jndiName);
    }

    private String getNamespace() {
        if (this.javaAppBinder) {
            return "java:app/";
        }
        return "java:module/";
    }

    public void setJavaEEModule(JavaEEModule javaeeModule) {
        this.javaeeModule = javaeeModule;
    }

    private Context getContext() {
        if (this.javaeeModule == null) {
            throw new IllegalStateException("JavaEEModule is not set. Cannot return JNDI context");
        }
        if (this.javaAppBinder) {
            return this.javaeeModule.getApplication().getContext();
        }
        return this.javaeeModule.getContext();
    }
}

