/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.mc.resource.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.managed.bean.mc.resource.provider.ManagedBeanResolutionResult;
import org.jboss.managed.bean.metadata.ManagedBeanDeploymentMetaData;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;

public abstract class AbstractManagedBeanRefResourceProvider {
    protected ManagedBeanResolutionResult resolveWithinDeploymentUnit(DeploymentUnit unit, Set<DeploymentUnit> alreadyScannedDUs, String mbClassName) {
        List children;
        ManagedBeanMetaData managedBean = this.getManagedBean(unit, mbClassName);
        if (managedBean != null) {
            return new ManagedBeanResolutionResult(managedBean, unit);
        }
        if (alreadyScannedDUs == null) {
            alreadyScannedDUs = new HashSet<DeploymentUnit>();
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                if (alreadyScannedDUs.contains(child)) continue;
                ManagedBeanResolutionResult resolutionResult = this.resolveWithinDeploymentUnit(child, alreadyScannedDUs, mbClassName);
                if (resolutionResult != null) {
                    return resolutionResult;
                }
                alreadyScannedDUs.add(child);
            }
        }
        alreadyScannedDUs.add(unit);
        DeploymentUnit parent = unit.getParent();
        if (parent != null) {
            return this.resolveWithinDeploymentUnit(parent, alreadyScannedDUs, mbClassName);
        }
        return null;
    }

    private ManagedBeanMetaData getManagedBean(DeploymentUnit unit, String mbClassName) {
        ManagedBeanDeploymentMetaData managedBeanDeploymentMetaData = (ManagedBeanDeploymentMetaData)unit.getAttachment(ManagedBeanDeploymentMetaData.class);
        if (managedBeanDeploymentMetaData == null) {
            return null;
        }
        Collection managedBeans = managedBeanDeploymentMetaData.getManagedBeans();
        if (managedBeans == null || managedBeans.isEmpty()) {
            return null;
        }
        for (ManagedBeanMetaData managedBean : managedBeans) {
            if (!mbClassName.equals(managedBean.getManagedBeanClass())) continue;
            return managedBean;
        }
        return null;
    }
}

