/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.bean.metadata;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

import org.jboss.interceptor.spi.metadata.InterceptorMetadata;

/**
 * Represents the metadata for a Managed Bean
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public interface ManagedBeanMetaData
{

   /**
    * Returns the name of the managed bean
    * @return
    */
   String getName();
   
   
   /**
    * Returns the fully qualified class name of the managed bean
    * @return
    */
   String getManagedBeanClass();

   Collection<InterceptorMetadata<?>> getAllInterceptors();
   
   List<InterceptorMetadata<?>> getPostConstructs();

   /**
    * 
    * @param method
    * @return
    */
   List<InterceptorMetadata<?>> getAroundInvokes(Method method);
}
