/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.jboss.marshalling.ByteInput;

public class ByteBufferInput
extends InputStream
implements ByteInput {
    private final ByteBuffer buffer;

    public ByteBufferInput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int rem = this.buffer.remaining();
        if (rem == 0) {
            return -1;
        }
        int c = Math.min(len, rem);
        this.buffer.get(b, 0, c);
        return c;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > 0L) {
            long c = Math.min((long)this.buffer.remaining(), n);
            this.buffer.position(this.buffer.position() + (int)c);
            return c;
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
    }
}

