/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.AbstractUnmarshaller;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Pair;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.BasicSerializableClassDescriptor;
import org.jboss.marshalling.river.BlockUnmarshaller;
import org.jboss.marshalling.river.ClassDescriptor;
import org.jboss.marshalling.river.ExternalizerClassDescriptor;
import org.jboss.marshalling.river.FutureSerializableClassDescriptor;
import org.jboss.marshalling.river.Protocol;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.marshalling.river.RiverObjectInputStream;
import org.jboss.marshalling.river.SerializableClassDescriptor;
import org.jboss.marshalling.river.SerializableGapClassDescriptor;
import org.jboss.marshalling.river.SimpleClassDescriptor;
import org.jboss.marshalling.river.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiverUnmarshaller
extends AbstractUnmarshaller {
    private final ArrayList<Object> instanceCache;
    private final ArrayList<ClassDescriptor> classCache;
    private final SerializableClassRegistry registry;
    private int version;
    private int depth;
    private BlockUnmarshaller blockUnmarshaller;
    private RiverObjectInputStream objectInputStream;
    private SortedSet<Validator> validators;
    private int validatorSeq;
    private static final Field proxyInvocationHandler = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            try {
                Field field = Proxy.class.getDeclaredField("h");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    });
    private final PrivilegedExceptionAction<RiverObjectInputStream> createObjectInputStreamAction = new PrivilegedExceptionAction<RiverObjectInputStream>(){

        @Override
        public RiverObjectInputStream run() throws IOException {
            return new RiverObjectInputStream(RiverUnmarshaller.this, RiverUnmarshaller.this.getBlockUnmarshaller());
        }
    };
    private static final InvocationHandler DUMMY_HANDLER = new DummyInvocationHandler();

    protected RiverUnmarshaller(RiverMarshallerFactory marshallerFactory, SerializableClassRegistry registry, MarshallingConfiguration configuration) {
        super((AbstractMarshallerFactory)marshallerFactory, configuration);
        this.registry = registry;
        this.instanceCache = new ArrayList(configuration.getInstanceCount());
        this.classCache = new ArrayList(configuration.getClassCount());
    }

    public void clearInstanceCache() throws IOException {
        this.instanceCache.clear();
    }

    public void clearClassCache() throws IOException {
        this.clearInstanceCache();
        this.classCache.clear();
    }

    public void close() throws IOException {
        this.finish();
    }

    public void finish() throws IOException {
        super.finish();
        this.blockUnmarshaller = null;
        this.objectInputStream = null;
    }

    private BlockUnmarshaller getBlockUnmarshaller() {
        BlockUnmarshaller blockUnmarshaller = this.blockUnmarshaller;
        return blockUnmarshaller == null ? (this.blockUnmarshaller = new BlockUnmarshaller(this)) : blockUnmarshaller;
    }

    private RiverObjectInputStream getObjectInputStream() throws IOException {
        RiverObjectInputStream objectInputStream = this.objectInputStream;
        return objectInputStream == null ? (this.objectInputStream = this.createObjectInputStream()) : objectInputStream;
    }

    private RiverObjectInputStream createObjectInputStream() throws IOException {
        try {
            return AccessController.doPrivileged(this.createObjectInputStreamAction);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    Object doReadNestedObject(boolean unshared, String enclosingClassName) throws ClassNotFoundException, IOException {
        try {
            return this.doReadObject(unshared);
        }
        catch (IOException e) {
            TraceInformation.addIncompleteObjectInformation((Throwable)e, (String)enclosingClassName);
            throw e;
        }
        catch (ClassNotFoundException e) {
            TraceInformation.addIncompleteObjectInformation((Throwable)e, (String)enclosingClassName);
            throw e;
        }
        catch (RuntimeException e) {
            TraceInformation.addIncompleteObjectInformation((Throwable)e, (String)enclosingClassName);
            throw e;
        }
    }

    Object doReadCollectionObject(boolean unshared, int idx, int size) throws ClassNotFoundException, IOException {
        try {
            return this.doReadObject(unshared);
        }
        catch (IOException e) {
            TraceInformation.addIndexInformation((Throwable)e, (int)idx, (int)size, (TraceInformation.IndexType)TraceInformation.IndexType.ELEMENT);
            throw e;
        }
        catch (ClassNotFoundException e) {
            TraceInformation.addIndexInformation((Throwable)e, (int)idx, (int)size, (TraceInformation.IndexType)TraceInformation.IndexType.ELEMENT);
            throw e;
        }
        catch (RuntimeException e) {
            TraceInformation.addIndexInformation((Throwable)e, (int)idx, (int)size, (TraceInformation.IndexType)TraceInformation.IndexType.ELEMENT);
            throw e;
        }
    }

    Object doReadMapObject(boolean unshared, int idx, int size, boolean key) throws ClassNotFoundException, IOException {
        try {
            return this.doReadObject(unshared);
        }
        catch (IOException e) {
            TraceInformation.addIndexInformation((Throwable)e, (int)idx, (int)size, (TraceInformation.IndexType)(key ? TraceInformation.IndexType.MAP_KEY : TraceInformation.IndexType.MAP_VALUE));
            throw e;
        }
        catch (ClassNotFoundException e) {
            TraceInformation.addIndexInformation((Throwable)e, (int)idx, (int)size, (TraceInformation.IndexType)(key ? TraceInformation.IndexType.MAP_KEY : TraceInformation.IndexType.MAP_VALUE));
            throw e;
        }
        catch (RuntimeException e) {
            TraceInformation.addIndexInformation((Throwable)e, (int)idx, (int)size, (TraceInformation.IndexType)(key ? TraceInformation.IndexType.MAP_KEY : TraceInformation.IndexType.MAP_VALUE));
            throw e;
        }
    }

    protected Object doReadObject(boolean unshared) throws ClassNotFoundException, IOException {
        SortedSet<Validator> validators;
        Object obj = this.doReadObject(this.readUnsignedByte(), unshared);
        if (this.depth == 0 && (validators = this.validators) != null) {
            this.validators = null;
            this.validatorSeq = 0;
            for (Validator validator : validators) {
                validator.getValidation().validateObject();
            }
        }
        return obj;
    }

    Object doReadObject(int leadByte, boolean unshared) throws IOException, ClassNotFoundException {
        ++this.depth;
        try {
            block216: while (true) {
                switch (leadByte) {
                    case 1: {
                        Object var3_3 = null;
                        return var3_3;
                    }
                    case 2: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a backreference as unshared");
                        }
                        int index = this.readInt();
                        try {
                            Object obj = this.instanceCache.get(index);
                            if (obj != null) {
                                Object object = obj;
                                return object;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        throw new InvalidObjectException("Attempt to read a backreference with an invalid ID (absolute " + index + ")");
                    }
                    case 57: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a backreference as unshared");
                        }
                        int index = this.readByte() | 0xFFFFFF00;
                        try {
                            Object obj = this.instanceCache.get(index + this.instanceCache.size());
                            if (obj != null) {
                                Object object = obj;
                                return object;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        throw new InvalidObjectException("Attempt to read a backreference with an invalid ID (relative near " + index + ")");
                    }
                    case 58: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a backreference as unshared");
                        }
                        int index = this.readShort() | 0xFFFF0000;
                        try {
                            Object obj = this.instanceCache.get(index + this.instanceCache.size());
                            if (obj != null) {
                                Object object = obj;
                                return object;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        throw new InvalidObjectException("Attempt to read a backreference with an invalid ID (relative nearish " + index + ")");
                    }
                    case 4: 
                    case 5: {
                        if (unshared != (leadByte == 5)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        Object index = this.doReadNewObject(this.readUnsignedByte(), unshared);
                        return index;
                    }
                    case 61: {
                        String index = "";
                        return index;
                    }
                    case 62: {
                        int length = this.readUnsignedByte();
                        String s = UTFUtils.readUTFBytes((ByteInput)this, (int)(length == 0 ? 256 : length));
                        this.instanceCache.add(s);
                        String string = s;
                        return string;
                    }
                    case 63: {
                        int length = this.readUnsignedShort();
                        String s = UTFUtils.readUTFBytes((ByteInput)this, (int)(length == 0 ? 65536 : length));
                        this.instanceCache.add(s);
                        String string = s;
                        return string;
                    }
                    case 64: {
                        int length = this.readInt();
                        if (length <= 0) {
                            throw new StreamCorruptedException("Invalid length value for string in stream (" + length + ")");
                        }
                        String s = UTFUtils.readUTFBytes((ByteInput)this, (int)length);
                        this.instanceCache.add(s);
                        String string = s;
                        return string;
                    }
                    case 65: 
                    case 69: {
                        if (unshared != (leadByte == 69)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        ArrayList<Object> instanceCache = this.instanceCache;
                        int idx = instanceCache.size();
                        instanceCache.add(null);
                        Object obj = Array.newInstance(this.doReadClassDescriptor(this.readUnsignedByte()).getType(), 0);
                        instanceCache.set(idx, obj);
                        Object resolvedObject2 = this.objectResolver.readResolve(obj);
                        if (unshared) {
                            instanceCache.set(idx, null);
                        } else if (obj != resolvedObject2) {
                            instanceCache.set(idx, resolvedObject2);
                        }
                        Object object = obj;
                        return object;
                    }
                    case 66: 
                    case 70: {
                        if (unshared != (leadByte == 70)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        int len = this.readUnsignedByte();
                        Object idx = this.doReadArray(len == 0 ? 256 : len, unshared);
                        return idx;
                    }
                    case 67: 
                    case 71: {
                        if (unshared != (leadByte == 71)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        int len = this.readUnsignedShort();
                        Object idx = this.doReadArray(len == 0 ? 65536 : len, unshared);
                        return idx;
                    }
                    case 68: 
                    case 72: {
                        if (unshared != (leadByte == 72)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        int len = this.readInt();
                        if (len <= 0) {
                            throw new StreamCorruptedException("Invalid length value for array in stream (" + len + ")");
                        }
                        Object idx = this.doReadArray(len, unshared);
                        return idx;
                    }
                    case 3: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a predefined object as unshared");
                        }
                        Object len = this.objectTable.readObject((Unmarshaller)this);
                        return len;
                    }
                    case 80: {
                        Object len = this.objectResolver.readResolve((Object)Boolean.TRUE);
                        return len;
                    }
                    case 81: {
                        Object len = this.objectResolver.readResolve((Object)Boolean.FALSE);
                        return len;
                    }
                    case 73: {
                        Object len = this.objectResolver.readResolve((Object)this.readByte());
                        return len;
                    }
                    case 74: {
                        Object len = this.objectResolver.readResolve((Object)this.readShort());
                        return len;
                    }
                    case 75: {
                        Object len = this.objectResolver.readResolve((Object)this.readInt());
                        return len;
                    }
                    case 76: {
                        Object len = this.objectResolver.readResolve((Object)this.readLong());
                        return len;
                    }
                    case 78: {
                        Object len = this.objectResolver.readResolve((Object)Float.valueOf(this.readFloat()));
                        return len;
                    }
                    case 79: {
                        Object len = this.objectResolver.readResolve((Object)this.readDouble());
                        return len;
                    }
                    case 77: {
                        Object len = this.objectResolver.readResolve((Object)Character.valueOf(this.readChar()));
                        return len;
                    }
                    case 33: {
                        Class<Byte> len = Byte.TYPE;
                        return len;
                    }
                    case 32: {
                        Class<Boolean> len = Boolean.TYPE;
                        return len;
                    }
                    case 37: {
                        Class<Character> len = Character.TYPE;
                        return len;
                    }
                    case 39: {
                        Class<Double> len = Double.TYPE;
                        return len;
                    }
                    case 38: {
                        Class<Float> len = Float.TYPE;
                        return len;
                    }
                    case 35: {
                        Class<Integer> len = Integer.TYPE;
                        return len;
                    }
                    case 36: {
                        Class<Long> len = Long.TYPE;
                        return len;
                    }
                    case 34: {
                        Class<Short> len = Short.TYPE;
                        return len;
                    }
                    case 40: {
                        Class<Void> len = Void.TYPE;
                        return len;
                    }
                    case 42: {
                        Class<Byte> len = Byte.class;
                        return len;
                    }
                    case 41: {
                        Class<Boolean> len = Boolean.class;
                        return len;
                    }
                    case 46: {
                        Class<Character> len = Character.class;
                        return len;
                    }
                    case 48: {
                        Class<Double> len = Double.class;
                        return len;
                    }
                    case 47: {
                        Class<Float> len = Float.class;
                        return len;
                    }
                    case 44: {
                        Class<Integer> len = Integer.class;
                        return len;
                    }
                    case 45: {
                        Class<Long> len = Long.class;
                        return len;
                    }
                    case 43: {
                        Class<Short> len = Short.class;
                        return len;
                    }
                    case 49: {
                        Class<Void> len = Void.class;
                        return len;
                    }
                    case 22: {
                        Class<Object> len = Object.class;
                        return len;
                    }
                    case 21: {
                        Class<Class> len = Class.class;
                        return len;
                    }
                    case 20: {
                        Class<String> len = String.class;
                        return len;
                    }
                    case 23: {
                        Class<Enum> len = Enum.class;
                        return len;
                    }
                    case 25: {
                        Class<byte[]> len = byte[].class;
                        return len;
                    }
                    case 24: {
                        Class<boolean[]> len = boolean[].class;
                        return len;
                    }
                    case 29: {
                        Class<char[]> len = char[].class;
                        return len;
                    }
                    case 31: {
                        Class<double[]> len = double[].class;
                        return len;
                    }
                    case 30: {
                        Class<float[]> len = float[].class;
                        return len;
                    }
                    case 27: {
                        Class<int[]> len = int[].class;
                        return len;
                    }
                    case 28: {
                        Class<long[]> len = long[].class;
                        return len;
                    }
                    case 26: {
                        Class<short[]> len = short[].class;
                        return len;
                    }
                    case 90: {
                        Class<ArrayList> len = ArrayList.class;
                        return len;
                    }
                    case 91: {
                        Class<LinkedList> len = LinkedList.class;
                        return len;
                    }
                    case 94: {
                        Class<HashSet> len = HashSet.class;
                        return len;
                    }
                    case 95: {
                        Class<LinkedHashSet> len = LinkedHashSet.class;
                        return len;
                    }
                    case 96: {
                        Class<TreeSet> len = TreeSet.class;
                        return len;
                    }
                    case 99: {
                        Class<IdentityHashMap> len = IdentityHashMap.class;
                        return len;
                    }
                    case 100: {
                        Class<HashMap> len = HashMap.class;
                        return len;
                    }
                    case 101: {
                        Class<Hashtable> len = Hashtable.class;
                        return len;
                    }
                    case 102: {
                        Class<LinkedHashMap> len = LinkedHashMap.class;
                        return len;
                    }
                    case 103: {
                        Class<TreeMap> len = TreeMap.class;
                        return len;
                    }
                    case 106: {
                        Class<?> len = Protocol.enumSetProxyClass;
                        return len;
                    }
                    case 107: {
                        Class<EnumSet> len = EnumSet.class;
                        return len;
                    }
                    case 108: {
                        Class<EnumMap> len = EnumMap.class;
                        return len;
                    }
                    case 109: {
                        Class<AbstractCollection> len = AbstractCollection.class;
                        return len;
                    }
                    case 111: {
                        Class<AbstractList> len = AbstractList.class;
                        return len;
                    }
                    case 112: {
                        Class<AbstractQueue> len = AbstractQueue.class;
                        return len;
                    }
                    case 113: {
                        Class<AbstractSequentialList> len = AbstractSequentialList.class;
                        return len;
                    }
                    case 110: {
                        Class<AbstractSet> len = AbstractSet.class;
                        return len;
                    }
                    case 114: {
                        Class<ConcurrentHashMap> len = ConcurrentHashMap.class;
                        return len;
                    }
                    case 115: {
                        Class<CopyOnWriteArrayList> len = CopyOnWriteArrayList.class;
                        return len;
                    }
                    case 116: {
                        Class<CopyOnWriteArraySet> len = CopyOnWriteArraySet.class;
                        return len;
                    }
                    case 117: {
                        Class<Vector> len = Vector.class;
                        return len;
                    }
                    case 118: {
                        Class<Stack> len = Stack.class;
                        return len;
                    }
                    case 92: {
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(null);
                        List<Object> obj = Collections.singletonList(this.doReadNestedObject(false, "Collections#singletonList()"));
                        Object resolvedObject = this.objectResolver.readResolve(obj);
                        if (!unshared) {
                            this.instanceCache.set(idx, resolvedObject);
                        }
                        Object resolvedObject2 = resolvedObject;
                        return resolvedObject2;
                    }
                    case 97: {
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(null);
                        Set<Object> obj = Collections.singleton(this.doReadNestedObject(false, "Collections#singleton()"));
                        Object resolvedObject = this.objectResolver.readResolve(obj);
                        if (!unshared) {
                            this.instanceCache.set(idx, resolvedObject);
                        }
                        Object resolvedObject2 = resolvedObject;
                        return resolvedObject2;
                    }
                    case 104: {
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(null);
                        Map<Object, Object> obj = Collections.singletonMap(this.doReadNestedObject(false, "Collections#singletonMap() [key]"), this.doReadNestedObject(false, "Collections#singletonMap() [value]"));
                        Object resolvedObject = this.objectResolver.readResolve(obj);
                        if (!unshared) {
                            this.instanceCache.set(idx, resolvedObject);
                        }
                        Object resolvedObject2 = resolvedObject;
                        return resolvedObject2;
                    }
                    case 93: {
                        List idx = Collections.emptyList();
                        return idx;
                    }
                    case 98: {
                        Set idx = Collections.emptySet();
                        return idx;
                    }
                    case 105: {
                        Map idx = Collections.emptyMap();
                        return idx;
                    }
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: {
                        int len;
                        switch (leadByte) {
                            case 82: 
                            case 86: {
                                len = 0;
                                break;
                            }
                            case 83: 
                            case 87: {
                                int b = this.readUnsignedByte();
                                len = b == 0 ? 256 : b;
                                break;
                            }
                            case 84: 
                            case 88: {
                                int b = this.readUnsignedShort();
                                len = b == 0 ? 65536 : b;
                                break;
                            }
                            case 85: 
                            case 89: {
                                len = this.readInt();
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        int id = this.readUnsignedByte();
                        switch (id) {
                            case 90: {
                                Object resolvedObject = this.readCollectionData(unshared, len, new ArrayList(len));
                                return resolvedObject;
                            }
                            case 94: {
                                Object resolvedObject = this.readCollectionData(unshared, len, new HashSet(len));
                                return resolvedObject;
                            }
                            case 95: {
                                Object resolvedObject = this.readCollectionData(unshared, len, new LinkedHashSet(len));
                                return resolvedObject;
                            }
                            case 91: {
                                Object resolvedObject = this.readCollectionData(unshared, len, new LinkedList());
                                return resolvedObject;
                            }
                            case 96: {
                                Object resolvedObject = this.readCollectionData(unshared, len, new TreeSet((Comparator)this.doReadNestedObject(false, "java.util.TreeSet comparator")));
                                return resolvedObject;
                            }
                            case 106: {
                                ClassDescriptor nestedDescriptor = this.doReadClassDescriptor(this.readUnsignedByte());
                                Class<Enum> elementType = nestedDescriptor.getType().asSubclass(Enum.class);
                                Object object = this.readCollectionData(unshared, len, EnumSet.noneOf(elementType));
                                return object;
                            }
                            case 117: {
                                Object nestedDescriptor = this.readCollectionData(unshared, len, new Vector(len));
                                return nestedDescriptor;
                            }
                            case 118: {
                                Object nestedDescriptor = this.readCollectionData(unshared, len, new Stack());
                                return nestedDescriptor;
                            }
                            case 100: {
                                Object nestedDescriptor = this.readMapData(unshared, len, new HashMap(len));
                                return nestedDescriptor;
                            }
                            case 101: {
                                Object nestedDescriptor = this.readMapData(unshared, len, new Hashtable(len));
                                return nestedDescriptor;
                            }
                            case 99: {
                                Object nestedDescriptor = this.readMapData(unshared, len, new IdentityHashMap(len));
                                return nestedDescriptor;
                            }
                            case 102: {
                                Object nestedDescriptor = this.readMapData(unshared, len, new LinkedHashMap(len));
                                return nestedDescriptor;
                            }
                            case 103: {
                                Object nestedDescriptor = this.readMapData(unshared, len, new TreeMap((Comparator)this.doReadNestedObject(false, "java.util.TreeMap comparator")));
                                return nestedDescriptor;
                            }
                            case 108: {
                                ClassDescriptor nestedDescriptor = this.doReadClassDescriptor(this.readUnsignedByte());
                                Class<Enum> elementType = nestedDescriptor.getType().asSubclass(Enum.class);
                                Object object = this.readMapData(unshared, len, new EnumMap(elementType));
                                return object;
                            }
                        }
                        throw new StreamCorruptedException("Unexpected byte found when reading a collection type: " + leadByte);
                    }
                    case 119: {
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(null);
                        Pair obj = Pair.create((Object)this.doReadNestedObject(unshared, "java.util.marshalling.Pair [A]"), (Object)this.doReadNestedObject(unshared, "java.util.marshalling.Pair [B]"));
                        Object resolvedObject = this.objectResolver.readResolve((Object)obj);
                        if (!unshared) {
                            this.instanceCache.set(idx, resolvedObject);
                        }
                        Object object = resolvedObject;
                        return object;
                    }
                    case 54: {
                        if (this.depth > 1) {
                            throw new StreamCorruptedException("ID_CLEAR_CLASS_CACHE token in the middle of stream processing");
                        }
                        this.classCache.clear();
                        this.instanceCache.clear();
                        leadByte = this.readUnsignedByte();
                        continue block216;
                    }
                    case 55: {
                        if (this.depth > 1) {
                            throw new StreamCorruptedException("ID_CLEAR_INSTANCE_CACHE token in the middle of stream processing");
                        }
                        this.instanceCache.clear();
                        continue block216;
                    }
                }
                break;
            }
            throw new StreamCorruptedException("Unexpected byte found when reading an object: " + leadByte);
        }
        finally {
            --this.depth;
        }
    }

    private Object readCollectionData(boolean unshared, int len, Collection target) throws ClassNotFoundException, IOException {
        ArrayList<Object> instanceCache = this.instanceCache;
        int idx = instanceCache.size();
        instanceCache.add(target);
        for (int i = 0; i < len; ++i) {
            target.add(this.doReadCollectionObject(false, idx, len));
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)target);
        if (unshared) {
            instanceCache.set(idx, null);
        } else if (target != resolvedObject) {
            instanceCache.set(idx, resolvedObject);
        }
        return resolvedObject;
    }

    private Object readMapData(boolean unshared, int len, Map target) throws ClassNotFoundException, IOException {
        ArrayList<Object> instanceCache = this.instanceCache;
        int idx = instanceCache.size();
        instanceCache.add(target);
        for (int i = 0; i < len; ++i) {
            target.put(this.doReadMapObject(false, idx, len, true), this.doReadMapObject(false, idx, len, false));
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)target);
        if (unshared) {
            instanceCache.set(idx, null);
        } else if (target != resolvedObject) {
            instanceCache.set(idx, resolvedObject);
        }
        return resolvedObject;
    }

    private static InvalidObjectException sharedMismatch() {
        return new InvalidObjectException("Shared/unshared object mismatch");
    }

    ClassDescriptor doReadClassDescriptor(int classType) throws IOException, ClassNotFoundException {
        ArrayList<ClassDescriptor> classCache = this.classCache;
        switch (classType) {
            case 6: {
                return classCache.get(this.readInt());
            }
            case 59: {
                return classCache.get((this.readByte() | 0xFFFFFF00) + classCache.size());
            }
            case 60: {
                return classCache.get((this.readShort() | 0xFFFF0000) + classCache.size());
            }
            case 19: {
                int idx = classCache.size();
                classCache.add(null);
                Class type = this.classTable.readClass((Unmarshaller)this);
                SimpleClassDescriptor descriptor = new SimpleClassDescriptor(type, 12);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 17: {
                int idx = classCache.size();
                classCache.add(null);
                Class type = this.classTable.readClass((Unmarshaller)this);
                SimpleClassDescriptor descriptor = new SimpleClassDescriptor(type, 10);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 18: {
                int idx = classCache.size();
                classCache.add(null);
                Class type = this.classTable.readClass((Unmarshaller)this);
                Externalizer externalizer = (Externalizer)this.readObject();
                ExternalizerClassDescriptor descriptor = new ExternalizerClassDescriptor(type, externalizer);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 14: {
                int idx = classCache.size();
                classCache.add(null);
                Class type = this.classTable.readClass((Unmarshaller)this);
                SimpleClassDescriptor descriptor = new SimpleClassDescriptor(type, 7);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 15: {
                int idx = classCache.size();
                classCache.add(null);
                Class type = this.classTable.readClass((Unmarshaller)this);
                SimpleClassDescriptor descriptor = new SimpleClassDescriptor(type, 8);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 16: {
                int idx = classCache.size();
                classCache.add(null);
                Class type = this.classTable.readClass((Unmarshaller)this);
                SerializableClass serializableClass = this.registry.lookup(type);
                int descType = serializableClass.hasWriteObject() ? 56 : 9;
                BasicSerializableClassDescriptor descriptor = new BasicSerializableClassDescriptor(serializableClass, this.doReadClassDescriptor(this.readUnsignedByte()), serializableClass.getFields(), descType);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 7: {
                String className = this.readString();
                Class clazz = this.classResolver.resolveClass((Unmarshaller)this, className, 0L);
                SimpleClassDescriptor descriptor = new SimpleClassDescriptor(clazz, 7);
                classCache.add(descriptor);
                return descriptor;
            }
            case 8: {
                String[] interfaces = new String[this.readInt()];
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = this.readString();
                }
                SimpleClassDescriptor descriptor = new SimpleClassDescriptor(this.classResolver.resolveProxyClass((Unmarshaller)this, interfaces), 8);
                classCache.add(descriptor);
                return descriptor;
            }
            case 9: 
            case 56: {
                int idx = classCache.size();
                classCache.add(null);
                String className = this.readString();
                long uid = this.readLong();
                Class clazz = this.classResolver.resolveClass((Unmarshaller)this, className, uid);
                Class superClazz = clazz.getSuperclass();
                FutureSerializableClassDescriptor descriptor = new FutureSerializableClassDescriptor(clazz, classType);
                classCache.set(idx, descriptor);
                int cnt = this.readInt();
                String[] names = new String[cnt];
                ClassDescriptor[] descriptors = new ClassDescriptor[cnt];
                boolean[] unshareds = new boolean[cnt];
                for (int i = 0; i < cnt; ++i) {
                    names[i] = this.readUTF();
                    descriptors[i] = this.doReadClassDescriptor(this.readUnsignedByte());
                    unshareds[i] = this.readBoolean();
                }
                ClassDescriptor superDescriptor = this.doReadClassDescriptor(this.readUnsignedByte());
                if (superDescriptor != null) {
                    Class<?> superType = superDescriptor.getType();
                    if (!superType.isAssignableFrom(clazz)) {
                        throw new InvalidClassException(clazz.getName(), "Class does not extend stream superclass");
                    }
                    for (Class cl = superClazz; cl != superType; cl = cl.getSuperclass()) {
                        superDescriptor = new SerializableGapClassDescriptor(this.registry.lookup(cl), superDescriptor);
                    }
                } else if (superClazz != null) {
                    Class cl = superClazz;
                    while (Serializable.class.isAssignableFrom(cl)) {
                        superDescriptor = new SerializableGapClassDescriptor(this.registry.lookup(cl), superDescriptor);
                        cl = cl.getSuperclass();
                    }
                }
                SerializableClass serializableClass = this.registry.lookup(clazz);
                SerializableField[] fields = new SerializableField[cnt];
                for (int i = 0; i < cnt; ++i) {
                    fields[i] = serializableClass.getSerializableField(names[i], descriptors[i].getType(), unshareds[i]);
                }
                descriptor.setResult(new BasicSerializableClassDescriptor(serializableClass, superDescriptor, fields, classType));
                return descriptor;
            }
            case 10: {
                String className = this.readString();
                long uid = this.readLong();
                Class clazz = this.classResolver.resolveClass((Unmarshaller)this, className, uid);
                SimpleClassDescriptor descriptor = new SimpleClassDescriptor(clazz, 10);
                classCache.add(descriptor);
                return descriptor;
            }
            case 11: {
                String className = this.readString();
                int idx = classCache.size();
                classCache.add(null);
                Class clazz = this.classResolver.resolveClass((Unmarshaller)this, className, 0L);
                Externalizer externalizer = (Externalizer)this.readObject();
                ExternalizerClassDescriptor descriptor = new ExternalizerClassDescriptor(clazz, externalizer);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 12: {
                SimpleClassDescriptor descriptor = new SimpleClassDescriptor(this.classResolver.resolveClass((Unmarshaller)this, this.readString(), 0L), 12);
                classCache.add(descriptor);
                return descriptor;
            }
            case 13: {
                ClassDescriptor elementType = this.doReadClassDescriptor(this.readUnsignedByte());
                SimpleClassDescriptor arrayDescriptor = new SimpleClassDescriptor(Array.newInstance(elementType.getType(), 0).getClass(), 13);
                classCache.add(arrayDescriptor);
                return arrayDescriptor;
            }
            case 90: {
                return ClassDescriptor.CC_ARRAY_LIST;
            }
            case 91: {
                return ClassDescriptor.CC_LINKED_LIST;
            }
            case 94: {
                return ClassDescriptor.CC_HASH_SET;
            }
            case 95: {
                return ClassDescriptor.CC_LINKED_HASH_SET;
            }
            case 96: {
                return ClassDescriptor.CC_TREE_SET;
            }
            case 99: {
                return ClassDescriptor.CC_IDENTITY_HASH_MAP;
            }
            case 100: {
                return ClassDescriptor.CC_HASH_MAP;
            }
            case 101: {
                return ClassDescriptor.CC_HASHTABLE;
            }
            case 102: {
                return ClassDescriptor.CC_LINKED_HASH_MAP;
            }
            case 103: {
                return ClassDescriptor.CC_TREE_MAP;
            }
            case 107: {
                return ClassDescriptor.CC_ENUM_SET;
            }
            case 108: {
                return ClassDescriptor.CC_ENUM_MAP;
            }
            case 109: {
                return ClassDescriptor.ABSTRACT_COLLECTION;
            }
            case 111: {
                return ClassDescriptor.ABSTRACT_LIST;
            }
            case 112: {
                return ClassDescriptor.ABSTRACT_QUEUE;
            }
            case 113: {
                return ClassDescriptor.ABSTRACT_SEQUENTIAL_LIST;
            }
            case 110: {
                return ClassDescriptor.ABSTRACT_SET;
            }
            case 114: {
                return ClassDescriptor.CONCURRENT_HASH_MAP;
            }
            case 115: {
                return ClassDescriptor.COPY_ON_WRITE_ARRAY_LIST;
            }
            case 116: {
                return ClassDescriptor.COPY_ON_WRITE_ARRAY_SET;
            }
            case 117: {
                return ClassDescriptor.VECTOR;
            }
            case 118: {
                return ClassDescriptor.STACK;
            }
            case 104: {
                return ClassDescriptor.SINGLETON_MAP;
            }
            case 97: {
                return ClassDescriptor.SINGLETON_SET;
            }
            case 92: {
                return ClassDescriptor.SINGLETON_LIST;
            }
            case 105: {
                return ClassDescriptor.EMPTY_MAP;
            }
            case 98: {
                return ClassDescriptor.EMPTY_SET;
            }
            case 93: {
                return ClassDescriptor.EMPTY_LIST;
            }
            case 119: {
                return ClassDescriptor.PAIR;
            }
            case 20: {
                return ClassDescriptor.STRING_DESCRIPTOR;
            }
            case 22: {
                return ClassDescriptor.OBJECT_DESCRIPTOR;
            }
            case 21: {
                return ClassDescriptor.CLASS_DESCRIPTOR;
            }
            case 23: {
                return ClassDescriptor.ENUM_DESCRIPTOR;
            }
            case 24: {
                return ClassDescriptor.BOOLEAN_ARRAY;
            }
            case 25: {
                return ClassDescriptor.BYTE_ARRAY;
            }
            case 26: {
                return ClassDescriptor.SHORT_ARRAY;
            }
            case 27: {
                return ClassDescriptor.INT_ARRAY;
            }
            case 28: {
                return ClassDescriptor.LONG_ARRAY;
            }
            case 29: {
                return ClassDescriptor.CHAR_ARRAY;
            }
            case 30: {
                return ClassDescriptor.FLOAT_ARRAY;
            }
            case 31: {
                return ClassDescriptor.DOUBLE_ARRAY;
            }
            case 32: {
                return ClassDescriptor.BOOLEAN;
            }
            case 33: {
                return ClassDescriptor.BYTE;
            }
            case 37: {
                return ClassDescriptor.CHAR;
            }
            case 39: {
                return ClassDescriptor.DOUBLE;
            }
            case 38: {
                return ClassDescriptor.FLOAT;
            }
            case 35: {
                return ClassDescriptor.INT;
            }
            case 36: {
                return ClassDescriptor.LONG;
            }
            case 34: {
                return ClassDescriptor.SHORT;
            }
            case 40: {
                return ClassDescriptor.VOID;
            }
            case 41: {
                return ClassDescriptor.BOOLEAN_OBJ;
            }
            case 42: {
                return ClassDescriptor.BYTE_OBJ;
            }
            case 43: {
                return ClassDescriptor.SHORT_OBJ;
            }
            case 44: {
                return ClassDescriptor.INTEGER_OBJ;
            }
            case 45: {
                return ClassDescriptor.LONG_OBJ;
            }
            case 46: {
                return ClassDescriptor.CHARACTER_OBJ;
            }
            case 47: {
                return ClassDescriptor.FLOAT_OBJ;
            }
            case 48: {
                return ClassDescriptor.DOUBLE_OBJ;
            }
            case 49: {
                return ClassDescriptor.VOID_OBJ;
            }
        }
        throw new InvalidClassException("Unexpected class ID " + classType);
    }

    protected String readString() throws IOException {
        int length = this.readInt();
        return UTFUtils.readUTFBytes((ByteInput)this, (int)length);
    }

    public void start(ByteInput byteInput) throws IOException {
        super.start(byteInput);
        int version = this.readUnsignedByte();
        if (version < 2 || version > this.configuredVersion || version > 3) {
            throw new IOException("Unsupported protocol version " + version);
        }
        this.version = version;
    }

    private static Object createProxyInstance(Creator creator, Class<?> type) throws IOException {
        try {
            return creator.create(type);
        }
        catch (Exception e) {
            return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), DUMMY_HANDLER);
        }
    }

    protected Object doReadNewObject(int streamClassType, boolean unshared) throws ClassNotFoundException, IOException {
        ClassDescriptor descriptor = this.doReadClassDescriptor(streamClassType);
        try {
            int classType = descriptor.getTypeID();
            ArrayList<Object> instanceCache = this.instanceCache;
            switch (classType) {
                case 8: {
                    Class<?> type = descriptor.getType();
                    Object obj = RiverUnmarshaller.createProxyInstance(this.serializedCreator, type);
                    int idx = instanceCache.size();
                    instanceCache.add(obj);
                    try {
                        proxyInvocationHandler.set(obj, this.doReadNestedObject(unshared, "[proxy invocation handler]"));
                    }
                    catch (IllegalAccessException e) {
                        throw new InvalidClassException(type.getName(), "Unable to set proxy invocation handler");
                    }
                    Object resolvedObject = this.objectResolver.readResolve(obj);
                    if (unshared) {
                        instanceCache.set(idx, null);
                    } else if (obj != resolvedObject) {
                        instanceCache.set(idx, resolvedObject);
                    }
                    return resolvedObject;
                }
                case 9: 
                case 56: {
                    SerializableClassDescriptor serializableClassDescriptor = (SerializableClassDescriptor)descriptor;
                    Class<?> type = descriptor.getType();
                    SerializableClass serializableClass = serializableClassDescriptor.getSerializableClass();
                    Object obj = this.serializedCreator.create(type);
                    int idx = instanceCache.size();
                    instanceCache.add(obj);
                    this.doInitSerializable(obj, serializableClassDescriptor);
                    Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve(obj) : obj);
                    if (unshared) {
                        instanceCache.set(idx, null);
                    } else if (obj != resolvedObject) {
                        instanceCache.set(idx, resolvedObject);
                    }
                    return resolvedObject;
                }
                case 10: {
                    Class<?> type = descriptor.getType();
                    SerializableClass serializableClass = this.registry.lookup(type);
                    BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                    Externalizable obj = serializableClass.hasObjectInputConstructor() ? (Externalizable)serializableClass.callObjectInputConstructor((ObjectInput)((Object)blockUnmarshaller)) : (Externalizable)serializableClass.callNoArgConstructor();
                    int idx = instanceCache.size();
                    instanceCache.add(obj);
                    obj.readExternal((ObjectInput)((Object)blockUnmarshaller));
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                    Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve((Object)obj) : obj);
                    if (unshared) {
                        instanceCache.set(idx, null);
                    } else if (obj != resolvedObject) {
                        instanceCache.set(idx, resolvedObject);
                    }
                    return resolvedObject;
                }
                case 11: {
                    int idx = instanceCache.size();
                    instanceCache.add(null);
                    Externalizer externalizer = ((ExternalizerClassDescriptor)descriptor).getExternalizer();
                    Class<?> type = descriptor.getType();
                    SerializableClass serializableClass = this.registry.lookup(type);
                    BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                    Object obj = externalizer.createExternal(type, (ObjectInput)((Object)blockUnmarshaller), this.externalizerCreator);
                    instanceCache.set(idx, obj);
                    externalizer.readExternal(obj, (ObjectInput)((Object)blockUnmarshaller));
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                    Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve(obj) : obj);
                    if (unshared) {
                        instanceCache.set(idx, null);
                    } else if (obj != resolvedObject) {
                        instanceCache.set(idx, resolvedObject);
                    }
                    return resolvedObject;
                }
                case 12: {
                    String name = this.readString();
                    Enum obj = RiverUnmarshaller.resolveEnumConstant(descriptor, name);
                    int idx = instanceCache.size();
                    instanceCache.add(obj);
                    Object resolvedObject = this.objectResolver.readResolve((Object)obj);
                    if (unshared) {
                        instanceCache.set(idx, null);
                    } else if (obj != resolvedObject) {
                        instanceCache.set(idx, resolvedObject);
                    }
                    return resolvedObject;
                }
                case 13: {
                    return this.doReadObjectArray(this.readInt(), descriptor.getType().getComponentType(), unshared);
                }
                case 20: {
                    String obj = this.readString();
                    Object resolvedObject = this.objectResolver.readResolve((Object)obj);
                    instanceCache.add(unshared ? null : resolvedObject);
                    return resolvedObject;
                }
                case 21: {
                    ClassDescriptor nestedDescriptor = this.doReadClassDescriptor(this.readUnsignedByte());
                    Class<?> obj = nestedDescriptor.getType();
                    return obj;
                }
                case 24: {
                    return this.doReadBooleanArray(this.readInt(), unshared);
                }
                case 25: {
                    return this.doReadByteArray(this.readInt(), unshared);
                }
                case 26: {
                    return this.doReadShortArray(this.readInt(), unshared);
                }
                case 27: {
                    return this.doReadIntArray(this.readInt(), unshared);
                }
                case 28: {
                    return this.doReadLongArray(this.readInt(), unshared);
                }
                case 29: {
                    return this.doReadCharArray(this.readInt(), unshared);
                }
                case 30: {
                    return this.doReadFloatArray(this.readInt(), unshared);
                }
                case 31: {
                    return this.doReadDoubleArray(this.readInt(), unshared);
                }
                case 41: {
                    return this.objectResolver.readResolve((Object)this.readBoolean());
                }
                case 42: {
                    return this.objectResolver.readResolve((Object)this.readByte());
                }
                case 43: {
                    return this.objectResolver.readResolve((Object)this.readShort());
                }
                case 44: {
                    return this.objectResolver.readResolve((Object)this.readInt());
                }
                case 45: {
                    return this.objectResolver.readResolve((Object)this.readLong());
                }
                case 46: {
                    return this.objectResolver.readResolve((Object)Character.valueOf(this.readChar()));
                }
                case 47: {
                    return this.objectResolver.readResolve((Object)Float.valueOf(this.readFloat()));
                }
                case 48: {
                    return this.objectResolver.readResolve((Object)this.readDouble());
                }
                case 7: 
                case 22: {
                    throw new NotSerializableException("(remote)" + descriptor.getType().getName());
                }
            }
            throw new InvalidObjectException("Unexpected class type " + classType);
        }
        catch (IOException e) {
            TraceInformation.addIncompleteObjectInformation((Throwable)e, descriptor.getType());
            this.exceptionListener.handleUnmarshallingException((Throwable)e, descriptor.getType());
            throw e;
        }
        catch (ClassNotFoundException e) {
            TraceInformation.addIncompleteObjectInformation((Throwable)e, descriptor.getType());
            this.exceptionListener.handleUnmarshallingException((Throwable)e, descriptor.getType());
            throw e;
        }
        catch (RuntimeException e) {
            TraceInformation.addIncompleteObjectInformation((Throwable)e, descriptor.getType());
            this.exceptionListener.handleUnmarshallingException((Throwable)e, descriptor.getType());
            throw e;
        }
    }

    private Object doReadDoubleArray(int cnt, boolean unshared) throws IOException {
        double[] array = new double[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readDouble();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadFloatArray(int cnt, boolean unshared) throws IOException {
        float[] array = new float[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readFloat();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadCharArray(int cnt, boolean unshared) throws IOException {
        char[] array = new char[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readChar();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadLongArray(int cnt, boolean unshared) throws IOException {
        long[] array = new long[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readLong();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadIntArray(int cnt, boolean unshared) throws IOException {
        int[] array = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readInt();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadShortArray(int cnt, boolean unshared) throws IOException {
        short[] array = new short[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readShort();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadByteArray(int cnt, boolean unshared) throws IOException {
        byte[] array = new byte[cnt];
        this.readFully(array, 0, array.length);
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadBooleanArray(int cnt, boolean unshared) throws IOException {
        byte v;
        boolean[] array = new boolean[cnt];
        int bc = cnt & 0xFFFFFFF8;
        int i = 0;
        while (i < bc) {
            v = this.readByte();
            array[i++] = (v & 1) != 0;
            array[i++] = (v & 2) != 0;
            array[i++] = (v & 4) != 0;
            array[i++] = (v & 8) != 0;
            array[i++] = (v & 0x10) != 0;
            array[i++] = (v & 0x20) != 0;
            array[i++] = (v & 0x40) != 0;
            array[i++] = (v & 0x80) != 0;
        }
        if (bc < cnt) {
            v = this.readByte();
            switch (cnt & 7) {
                case 7: {
                    array[bc + 6] = (v & 0x40) != 0;
                }
                case 6: {
                    array[bc + 5] = (v & 0x20) != 0;
                }
                case 5: {
                    array[bc + 4] = (v & 0x10) != 0;
                }
                case 4: {
                    array[bc + 3] = (v & 8) != 0;
                }
                case 3: {
                    array[bc + 2] = (v & 4) != 0;
                }
                case 2: {
                    array[bc + 1] = (v & 2) != 0;
                }
                case 1: {
                    array[bc] = (v & 1) != 0;
                }
            }
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadObjectArray(int cnt, Class<?> type, boolean unshared) throws ClassNotFoundException, IOException {
        Object[] array = (Object[])Array.newInstance(type, cnt);
        int idx = this.instanceCache.size();
        this.instanceCache.add(array);
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.doReadCollectionObject(unshared, i, cnt);
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        if (unshared) {
            this.instanceCache.set(idx, null);
        } else if (array != resolvedObject) {
            this.instanceCache.set(idx, resolvedObject);
        }
        return resolvedObject;
    }

    private Object doReadArray(int cnt, boolean unshared) throws ClassNotFoundException, IOException {
        int leadByte = this.readUnsignedByte();
        switch (leadByte) {
            case 32: {
                return this.doReadBooleanArray(cnt, unshared);
            }
            case 33: {
                return this.doReadByteArray(cnt, unshared);
            }
            case 37: {
                return this.doReadCharArray(cnt, unshared);
            }
            case 39: {
                return this.doReadDoubleArray(cnt, unshared);
            }
            case 38: {
                return this.doReadFloatArray(cnt, unshared);
            }
            case 35: {
                return this.doReadIntArray(cnt, unshared);
            }
            case 36: {
                return this.doReadLongArray(cnt, unshared);
            }
            case 34: {
                return this.doReadShortArray(cnt, unshared);
            }
        }
        return this.doReadObjectArray(cnt, this.doReadClassDescriptor(leadByte).getType(), unshared);
    }

    private static Enum resolveEnumConstant(ClassDescriptor descriptor, String name) {
        return Enum.valueOf(descriptor.getType(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitSerializable(Object obj, SerializableClassDescriptor descriptor) throws IOException, ClassNotFoundException {
        Class<?> type = descriptor.getType();
        SerializableClass info = this.registry.lookup(type);
        ClassDescriptor superDescriptor = descriptor.getSuperClassDescriptor();
        if (superDescriptor instanceof SerializableClassDescriptor) {
            SerializableClassDescriptor serializableSuperDescriptor = (SerializableClassDescriptor)superDescriptor;
            this.doInitSerializable(obj, serializableSuperDescriptor);
        }
        int typeId = descriptor.getTypeID();
        BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
        if (descriptor instanceof SerializableGapClassDescriptor) {
            if (info.hasReadObjectNoData()) {
                info.callReadObjectNoData(obj);
            }
        } else if (info.hasReadObject()) {
            RiverObjectInputStream objectInputStream = this.getObjectInputStream();
            SerializableClassDescriptor oldDescriptor = objectInputStream.swapClass(descriptor);
            Object oldObj = objectInputStream.swapCurrent(obj);
            RiverObjectInputStream.State restoreState = objectInputStream.start();
            boolean ok = false;
            try {
                if (typeId == 56) {
                    info.callReadObject(obj, (ObjectInputStream)((Object)objectInputStream));
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                } else {
                    objectInputStream.noCustomData();
                    info.callReadObject(obj, (ObjectInputStream)((Object)objectInputStream));
                    blockUnmarshaller.restore(objectInputStream.getRestoreIdx());
                }
                objectInputStream.finish(restoreState);
                objectInputStream.swapCurrent(oldObj);
                objectInputStream.swapClass(oldDescriptor);
                ok = true;
            }
            finally {
                if (!ok) {
                    objectInputStream.fullReset();
                }
            }
        } else {
            this.readFields(obj, descriptor);
            if (typeId == 56) {
                blockUnmarshaller.readToEndBlockData();
                blockUnmarshaller.unblock();
            }
        }
    }

    protected void readFields(Object obj, SerializableClassDescriptor descriptor) throws IOException, ClassNotFoundException {
        for (SerializableField serializableField : descriptor.getFields()) {
            try {
                Field field = serializableField.getField();
                if (field == null) {
                    switch (serializableField.getKind()) {
                        case BOOLEAN: {
                            this.readBoolean();
                            break;
                        }
                        case BYTE: {
                            this.readByte();
                            break;
                        }
                        case CHAR: {
                            this.readChar();
                            break;
                        }
                        case DOUBLE: {
                            this.readDouble();
                            break;
                        }
                        case FLOAT: {
                            this.readFloat();
                            break;
                        }
                        case INT: {
                            this.readInt();
                            break;
                        }
                        case LONG: {
                            this.readLong();
                            break;
                        }
                        case OBJECT: {
                            this.doReadObject(serializableField.isUnshared());
                            break;
                        }
                        case SHORT: {
                            this.readShort();
                        }
                    }
                    continue;
                }
                try {
                    switch (serializableField.getKind()) {
                        case BOOLEAN: {
                            field.setBoolean(obj, this.readBoolean());
                            break;
                        }
                        case BYTE: {
                            field.setByte(obj, this.readByte());
                            break;
                        }
                        case CHAR: {
                            field.setChar(obj, this.readChar());
                            break;
                        }
                        case DOUBLE: {
                            field.setDouble(obj, this.readDouble());
                            break;
                        }
                        case FLOAT: {
                            field.setFloat(obj, this.readFloat());
                            break;
                        }
                        case INT: {
                            field.setInt(obj, this.readInt());
                            break;
                        }
                        case LONG: {
                            field.setLong(obj, this.readLong());
                            break;
                        }
                        case OBJECT: {
                            field.set(obj, this.doReadObject(serializableField.isUnshared()));
                            break;
                        }
                        case SHORT: {
                            field.setShort(obj, this.readShort());
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    InvalidObjectException ioe = new InvalidObjectException("Unable to set a field");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            catch (IOException e) {
                TraceInformation.addFieldInformation((Throwable)e, (String)serializableField.getName());
                throw e;
            }
            catch (ClassNotFoundException e) {
                TraceInformation.addFieldInformation((Throwable)e, (String)serializableField.getName());
                throw e;
            }
            catch (RuntimeException e) {
                TraceInformation.addFieldInformation((Throwable)e, (String)serializableField.getName());
                throw e;
            }
        }
    }

    void addValidation(ObjectInputValidation validation, int prio) {
        Validator validator = new Validator(prio, this.validatorSeq++, validation);
        SortedSet<Validator> validators = this.validators;
        (validators == null ? (this.validators = new TreeSet<Validator>()) : validators).add(validator);
    }

    public String readUTF() throws IOException {
        int len = this.readInt();
        return UTFUtils.readUTFBytes((ByteInput)this, (int)len);
    }

    private static final class DummyInvocationHandler
    implements InvocationHandler {
        private DummyInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new NoSuchMethodError("Invocation handler not yet loaded");
        }
    }
}

