/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingObjectTable
implements ObjectTable {
    private final List<Pair<ObjectTable, ObjectTable.Writer>> writers;
    private final ObjectTable[] readers;

    private static Pair<ObjectTable, ObjectTable.Writer> pair(final ObjectTable objectTable, final ObjectTable.Writer writer) {
        return new Pair<ObjectTable, ObjectTable.Writer>(){

            @Override
            public ObjectTable getX() {
                return objectTable;
            }

            @Override
            public ObjectTable.Writer getY() {
                return writer;
            }
        };
    }

    public ChainingObjectTable(ObjectTable[] objectTables) {
        if (objectTables == null) {
            throw new NullPointerException("objectTables is null");
        }
        this.readers = (ObjectTable[])objectTables.clone();
        if (this.readers.length > 256) {
            throw new IllegalArgumentException("Object table array is too long (limit is 256 elements)");
        }
        this.writers = new ArrayList<Pair<ObjectTable, ObjectTable.Writer>>();
        for (int i = 0; i < this.readers.length; ++i) {
            final ObjectTable objectTable = this.readers[i];
            if (objectTable == null) continue;
            final int idx = i;
            this.writers.add(ChainingObjectTable.pair(objectTable, new ObjectTable.Writer(){

                public void writeObject(Marshaller marshaller, Object obj) throws IOException {
                    marshaller.writeByte(idx);
                    objectTable.getObjectWriter(obj).writeObject(marshaller, obj);
                }
            }));
        }
    }

    @Override
    public ObjectTable.Writer getObjectWriter(Object obj) throws IOException {
        for (Pair<ObjectTable, ObjectTable.Writer> entry : this.writers) {
            ObjectTable table = entry.getX();
            ObjectTable.Writer writer = entry.getY();
            if (table.getObjectWriter(obj) == null) continue;
            return writer;
        }
        return null;
    }

    @Override
    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int v = unmarshaller.readByte() & 0xFF;
        ObjectTable table = this.readers[v];
        if (table == null) {
            throw new StreamCorruptedException(String.format("Unknown object table ID %02x encountered", v));
        }
        return table.readObject(unmarshaller);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Pair<X, Y> {
        public X getX();

        public Y getY();
    }
}

