/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;

public final class UTFUtils {
    private static final String INVALID_BYTE = "Invalid byte";
    private static final String MALFORMED = "Malformed UTF-8 sequence";

    private UTFUtils() {
    }

    public static int getShortUTFLength(String s) throws UTFDataFormatException {
        int length = s.length();
        int l = 0;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            l = c > '\u0000' && c <= '\u007f' ? ++l : (c <= '\u07ff' ? (l += 2) : (l += 3));
            if (l <= 65535) continue;
            throw new UTFDataFormatException("String is too long for writeUTF");
        }
        return l;
    }

    public static long getLongUTFLength(String s) {
        int length = s.length();
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                ++l;
                continue;
            }
            if (c <= '\u07ff') {
                l += 2L;
                continue;
            }
            l += 3L;
        }
        return l;
    }

    public static void writeUTFBytes(ByteOutput output, String s) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                output.write(c);
                continue;
            }
            if (c <= '\u07ff') {
                output.write(0xC0 | 0x1F & c >> 6);
                output.write(0x80 | 0x3F & c);
                continue;
            }
            output.write(0xE0 | 0xF & c >> 12);
            output.write(0x80 | 0x3F & c >> 6);
            output.write(0x80 | 0x3F & c);
        }
    }

    public static String readUTFBytes(ByteInput input, int len) throws IOException {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            int c = UTFUtils.readUTFChar(input);
            chars[i] = c == -1 ? (char)'\u0000' : (char)c;
        }
        return String.valueOf(chars);
    }

    public static String readUTFBytesByByteCount(ByteInput input, long len) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (long i = 0L; i < len; ++i) {
            int b;
            int a = input.read();
            if (a < 0) {
                throw new EOFException("Expected " + (len - i) + " more bytes");
            }
            if (a == 0) {
                builder.append('\u0000');
                continue;
            }
            if (a < 128) {
                builder.append((char)a);
                continue;
            }
            if (a < 192) {
                throw new UTFDataFormatException(INVALID_BYTE);
            }
            if (a < 224) {
                if (++i < len) {
                    b = input.read();
                    if (b == -1) {
                        throw new EOFException("Expected " + (len - i) + " more bytes");
                    }
                    if ((b & 0xC0) != 128) {
                        throw new UTFDataFormatException(INVALID_BYTE);
                    }
                    builder.append((char)((a & 0x1F) << 6 | b & 0x3F));
                    continue;
                }
                throw new UTFDataFormatException(MALFORMED);
            }
            if (a < 240) {
                if (++i < len) {
                    b = input.read();
                    if (b == -1) {
                        throw new EOFException("Expected " + (len - i) + " more bytes");
                    }
                    if ((b & 0xC0) != 128) {
                        throw new UTFDataFormatException(INVALID_BYTE);
                    }
                    if (++i < len) {
                        int c1 = input.read();
                        if (c1 == -1) {
                            throw new EOFException("Expected " + (len - i) + " more bytes");
                        }
                        if ((c1 & 0xC0) != 128) {
                            throw new UTFDataFormatException(INVALID_BYTE);
                        }
                        builder.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c1 & 0x3F));
                        continue;
                    }
                    throw new UTFDataFormatException(MALFORMED);
                }
                throw new UTFDataFormatException(MALFORMED);
            }
            throw new UTFDataFormatException(INVALID_BYTE);
        }
        return builder.toString();
    }

    public static String readUTFZBytes(ByteInput input) throws IOException {
        StringBuilder builder = new StringBuilder();
        int c;
        while ((c = UTFUtils.readUTFChar(input)) != -1) {
            builder.append((char)c);
        }
        return builder.toString();
    }

    private static int readUTFChar(ByteInput input) throws IOException {
        int a = input.read();
        if (a < 0) {
            throw new EOFException();
        }
        if (a == 0) {
            return -1;
        }
        if (a < 128) {
            return (char)a;
        }
        if (a < 192) {
            throw new UTFDataFormatException(INVALID_BYTE);
        }
        if (a < 224) {
            int b = input.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0xC0) != 128) {
                throw new UTFDataFormatException(INVALID_BYTE);
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = input.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0xC0) != 128) {
                throw new UTFDataFormatException(INVALID_BYTE);
            }
            int c = input.read();
            if (c == -1) {
                throw new EOFException();
            }
            if ((c & 0xC0) != 128) {
                throw new UTFDataFormatException(INVALID_BYTE);
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        throw new UTFDataFormatException(INVALID_BYTE);
    }
}

