/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.NotActiveException;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.UTFUtils;

public abstract class AbstractMarshaller
implements Marshaller {
    protected final ClassExternalizerFactory classExternalizerFactory;
    protected final StreamHeader streamHeader;
    protected final ClassResolver classResolver;
    protected final ObjectResolver objectResolver;
    protected final Creator creator;
    protected final ClassTable classTable;
    protected final ObjectTable objectTable;
    protected final int configuredVersion;
    protected ByteOutput byteOutput;
    protected final int bufferSize;
    private byte[] buffer;
    private int position;

    protected AbstractMarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) {
        ClassExternalizerFactory classExternalizerFactory = configuration.getClassExternalizerFactory();
        this.classExternalizerFactory = classExternalizerFactory == null ? marshallerFactory.getDefaultClassExternalizerFactory() : classExternalizerFactory;
        StreamHeader streamHeader = configuration.getStreamHeader();
        this.streamHeader = streamHeader == null ? marshallerFactory.getDefaultStreamHeader() : streamHeader;
        ClassResolver classResolver = configuration.getClassResolver();
        this.classResolver = classResolver == null ? marshallerFactory.getDefaultClassResolver() : classResolver;
        ObjectResolver objectResolver = configuration.getObjectResolver();
        this.objectResolver = objectResolver == null ? marshallerFactory.getDefaultObjectResolver() : objectResolver;
        Creator creator = configuration.getCreator();
        this.creator = creator == null ? marshallerFactory.getDefaultCreator() : creator;
        ClassTable classTable = configuration.getClassTable();
        this.classTable = classTable == null ? marshallerFactory.getDefaultClassTable() : classTable;
        ObjectTable objectTable = configuration.getObjectTable();
        this.objectTable = objectTable == null ? marshallerFactory.getDefaultObjectTable() : objectTable;
        int configuredVersion = configuration.getVersion();
        this.configuredVersion = configuredVersion == -1 ? marshallerFactory.getDefaultVersion() : configuredVersion;
        int minBufSize = marshallerFactory.getMinimumBufferSize();
        int bufferSize = configuration.getBufferSize();
        this.bufferSize = bufferSize == -1 ? marshallerFactory.getDefaultBufferSize() : (bufferSize < minBufSize ? minBufSize : bufferSize);
    }

    private static NotActiveException notActiveException() {
        return new NotActiveException("Output not started");
    }

    public void write(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int position = this.position;
            if (position == buffer.length) {
                this.flush();
                buffer[0] = (byte)v;
                this.position = 1;
            } else {
                buffer[position] = (byte)v;
                this.position = position + 1;
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        int bl = this.buffer.length;
        int position = this.position;
        if (len > bl - position || len > bl >> 3) {
            this.flush();
            this.byteOutput.write(bytes, off, len);
        } else {
            System.arraycopy(bytes, off, this.buffer, position, len);
            this.position = position + len;
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining == 0) {
                this.flush();
                buffer[0] = (byte)(v ? 1 : 0);
                this.position = 1;
            } else {
                buffer[this.position++] = (byte)(v ? 1 : 0);
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void writeByte(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining == 0) {
                this.flush();
                buffer[0] = (byte)v;
                this.position = 1;
            } else {
                buffer[this.position++] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void writeShort(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 2) {
                this.flush();
                buffer[0] = (byte)(v >> 8);
                buffer[1] = (byte)v;
                this.position = 2;
            } else {
                int s = this.position;
                this.position = s + 2;
                buffer[s] = (byte)(v >> 8);
                buffer[s + 1] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void writeChar(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 2) {
                this.flush();
                buffer[0] = (byte)(v >> 8);
                buffer[1] = (byte)v;
                this.position = 2;
            } else {
                int s = this.position;
                this.position = s + 2;
                buffer[s] = (byte)(v >> 8);
                buffer[s + 1] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void writeInt(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 4) {
                this.flush();
                buffer[0] = (byte)(v >> 24);
                buffer[1] = (byte)(v >> 16);
                buffer[2] = (byte)(v >> 8);
                buffer[3] = (byte)v;
                this.position = 4;
            } else {
                int s = this.position;
                this.position = s + 4;
                buffer[s] = (byte)(v >> 24);
                buffer[s + 1] = (byte)(v >> 16);
                buffer[s + 2] = (byte)(v >> 8);
                buffer[s + 3] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void writeLong(long v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 8) {
                this.flush();
                buffer[0] = (byte)(v >> 56);
                buffer[1] = (byte)(v >> 48);
                buffer[2] = (byte)(v >> 40);
                buffer[3] = (byte)(v >> 32);
                buffer[4] = (byte)(v >> 24);
                buffer[5] = (byte)(v >> 16);
                buffer[6] = (byte)(v >> 8);
                buffer[7] = (byte)v;
                this.position = 8;
            } else {
                int s = this.position;
                this.position = s + 8;
                buffer[s] = (byte)(v >> 56);
                buffer[s + 1] = (byte)(v >> 48);
                buffer[s + 2] = (byte)(v >> 40);
                buffer[s + 3] = (byte)(v >> 32);
                buffer[s + 4] = (byte)(v >> 24);
                buffer[s + 5] = (byte)(v >> 16);
                buffer[s + 6] = (byte)(v >> 8);
                buffer[s + 7] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void writeFloat(float v) throws IOException {
        int bits = Float.floatToIntBits(v);
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 4) {
                this.flush();
                buffer[0] = (byte)(bits >> 24);
                buffer[1] = (byte)(bits >> 16);
                buffer[2] = (byte)(bits >> 8);
                buffer[3] = (byte)bits;
                this.position = 4;
            } else {
                int s = this.position;
                this.position = s + 4;
                buffer[s] = (byte)(bits >> 24);
                buffer[s + 1] = (byte)(bits >> 16);
                buffer[s + 2] = (byte)(bits >> 8);
                buffer[s + 3] = (byte)bits;
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void writeDouble(double v) throws IOException {
        long bits = Double.doubleToLongBits(v);
        try {
            int remaining = this.buffer.length - this.position;
            if (remaining < 8) {
                this.flush();
                this.buffer[0] = (byte)(bits >> 56);
                this.buffer[1] = (byte)(bits >> 48);
                this.buffer[2] = (byte)(bits >> 40);
                this.buffer[3] = (byte)(bits >> 32);
                this.buffer[4] = (byte)(bits >> 24);
                this.buffer[5] = (byte)(bits >> 16);
                this.buffer[6] = (byte)(bits >> 8);
                this.buffer[7] = (byte)bits;
                this.position = 8;
            } else {
                int s = this.position;
                this.position = s + 8;
                this.buffer[s] = (byte)(bits >> 56);
                this.buffer[s + 1] = (byte)(bits >> 48);
                this.buffer[s + 2] = (byte)(bits >> 40);
                this.buffer[s + 3] = (byte)(bits >> 32);
                this.buffer[s + 4] = (byte)(bits >> 24);
                this.buffer[s + 5] = (byte)(bits >> 16);
                this.buffer[s + 6] = (byte)(bits >> 8);
                this.buffer[s + 7] = (byte)bits;
            }
        }
        catch (NullPointerException e) {
            throw AbstractMarshaller.notActiveException();
        }
    }

    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public void writeUTF(String s) throws IOException {
        this.writeShort(UTFUtils.getShortUTFLength(s));
        UTFUtils.writeUTFBytes(this, s);
    }

    public void flush() throws IOException {
        int pos = this.position;
        ByteOutput byteOutput = this.byteOutput;
        if (byteOutput != null) {
            if (pos > 0) {
                byteOutput.write(this.buffer, 0, pos);
            }
            this.position = 0;
            byteOutput.flush();
        }
    }

    public void close() throws IOException {
        this.finish();
    }

    public void start(ByteOutput byteOutput) throws IOException {
        this.byteOutput = byteOutput;
        this.buffer = new byte[this.bufferSize];
        this.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.buffer = null;
            this.byteOutput = null;
            this.clearClassCache();
        }
    }

    protected abstract void doWriteObject(Object var1, boolean var2) throws IOException;

    public final void writeObjectUnshared(Object obj) throws IOException {
        this.doWriteObject(obj, true);
    }

    public final void writeObject(Object obj) throws IOException {
        this.doWriteObject(obj, false);
    }

    protected void doStart() throws IOException {
        this.streamHeader.writeHeader(this);
    }
}

