/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.jboss.marshalling.AbstractExternalizer;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.Unmarshaller;

public final class Marshalling {
    private static final StreamHeader NULL_STREAM_HEADER = new StreamHeader(){

        public void readHeader(ByteInput input) throws IOException {
        }

        public void writeHeader(ByteOutput output) throws IOException {
        }

        public String toString() {
            return "null StreamHeader";
        }
    };
    private static final ClassExternalizerFactory NULL_CLASS_EXTERNALIZER_FACTORY = new ClassExternalizerFactory(){

        @Override
        public Externalizer getExternalizer(Class<?> type) {
            return null;
        }
    };
    private static final ObjectResolver NULL_OBJECT_RESOLVER = new ObjectResolver(){

        public Object readResolve(Object replacement) {
            return replacement;
        }

        public Object writeReplace(Object original) {
            return original;
        }
    };
    private static final ObjectTable NULL_OBJECT_TABLE = new ObjectTable(){

        public ObjectTable.Writer getObjectWriter(Object object) {
            return null;
        }

        public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
            return null;
        }
    };
    private static final ClassTable NULL_CLASS_TABLE = new ClassTable(){

        @Override
        public ClassTable.Writer getClassWriter(Class<?> clazz) {
            return null;
        }

        @Override
        public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
            return null;
        }
    };
    private static final OptionalDataExceptionCreateAction OPTIONAL_DATA_EXCEPTION_CREATE_ACTION = new OptionalDataExceptionCreateAction();
    private static final Externalizer NULL_EXTERNALIZER = new AbstractExternalizer(){
        private static final long serialVersionUID = 1L;

        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
        }

        public void readExternal(Object subject, ObjectInput input) throws IOException, ClassNotFoundException {
        }
    };

    private Marshalling() {
    }

    public static StreamHeader nullStreamHeader() {
        return NULL_STREAM_HEADER;
    }

    public static StreamHeader streamHeader(byte[] headerBytes) {
        return new StaticStreamHeader(headerBytes);
    }

    public static void readFully(ByteInput input, byte[] dest) throws IOException {
        int len = dest.length;
        int r = input.read(dest);
        if (r == -1) {
            throw new EOFException();
        }
        if (r < len) {
            Marshalling.readFully(input, dest, r, len - r);
        }
    }

    public static void readFully(ByteInput input, byte[] dest, int offs, int len) throws IOException {
        while (len > 0) {
            int r = input.read(dest, offs, len);
            if (r == -1) {
                throw new EOFException();
            }
            len -= r;
            offs += r;
        }
    }

    public static ByteInput createByteInput(final ByteBuffer buffer) {
        return new ByteInput(){

            public int read() throws IOException {
                try {
                    return buffer.get() & 0xFF;
                }
                catch (BufferUnderflowException e) {
                    return -1;
                }
            }

            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (len == 0) {
                    return 0;
                }
                int rem = buffer.remaining();
                if (rem == 0) {
                    return -1;
                }
                int c = Math.min(len, rem);
                buffer.get(b, 0, c);
                return c;
            }

            public int available() throws IOException {
                return buffer.remaining();
            }

            public long skip(long n) throws IOException {
                if (n > 0L) {
                    long c = Math.min((long)buffer.remaining(), n);
                    buffer.position(buffer.position() + (int)c);
                    return c;
                }
                return 0L;
            }

            public void close() throws IOException {
                buffer.clear();
            }
        };
    }

    public static ByteInput createByteInput(final InputStream inputStream) {
        return new ByteInput(){

            public int read() throws IOException {
                return inputStream.read();
            }

            public int read(byte[] b) throws IOException {
                return inputStream.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return inputStream.read(b, off, len);
            }

            public int available() throws IOException {
                return inputStream.available();
            }

            public long skip(long n) throws IOException {
                return inputStream.skip(n);
            }

            public void close() throws IOException {
                inputStream.close();
            }
        };
    }

    public static InputStream createInputStream(final ByteInput byteInput) {
        return new InputStream(){

            public int read() throws IOException {
                return byteInput.read();
            }

            public int read(byte[] b) throws IOException {
                return byteInput.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return byteInput.read(b, off, len);
            }

            public long skip(long n) throws IOException {
                return byteInput.skip(n);
            }

            public int available() throws IOException {
                return byteInput.available();
            }

            public void close() throws IOException {
                byteInput.close();
            }
        };
    }

    private static EOFException writePastEnd() {
        return new EOFException("Write past end of buffer");
    }

    private static IOException readOnlyBuffer() {
        return new IOException("Read only buffer");
    }

    public static ByteOutput createByteOutput(final ByteBuffer buffer) {
        return new ByteOutput(){

            public void write(int b) throws IOException {
                try {
                    buffer.put((byte)b);
                }
                catch (BufferOverflowException e) {
                    throw Marshalling.writePastEnd();
                }
                catch (ReadOnlyBufferException e) {
                    throw Marshalling.readOnlyBuffer();
                }
            }

            public void write(byte[] b) throws IOException {
                try {
                    buffer.put(b);
                }
                catch (BufferOverflowException e) {
                    throw Marshalling.writePastEnd();
                }
                catch (ReadOnlyBufferException e) {
                    throw Marshalling.readOnlyBuffer();
                }
            }

            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    buffer.put(b, off, len);
                }
                catch (BufferOverflowException e) {
                    throw Marshalling.writePastEnd();
                }
                catch (ReadOnlyBufferException e) {
                    throw Marshalling.readOnlyBuffer();
                }
            }

            public void close() throws IOException {
                buffer.clear();
            }

            public void flush() throws IOException {
            }
        };
    }

    public static ByteOutput createByteOutput(final OutputStream outputStream) {
        return new ByteOutput(){

            public void write(int b) throws IOException {
                outputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                outputStream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                outputStream.write(b, off, len);
            }

            public void close() throws IOException {
                outputStream.close();
            }

            public void flush() throws IOException {
                outputStream.flush();
            }
        };
    }

    public static OutputStream createOutputStream(final ByteOutput byteOutput) {
        return new OutputStream(){

            public void write(int b) throws IOException {
                byteOutput.write(b);
            }

            public void write(byte[] b) throws IOException {
                byteOutput.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                byteOutput.write(b, off, len);
            }

            public void flush() throws IOException {
                byteOutput.flush();
            }

            public void close() throws IOException {
                byteOutput.close();
            }
        };
    }

    public static ClassExternalizerFactory nullClassExternalizerFactory() {
        return NULL_CLASS_EXTERNALIZER_FACTORY;
    }

    public static ObjectResolver nullObjectResolver() {
        return NULL_OBJECT_RESOLVER;
    }

    public static ObjectTable nullObjectTable() {
        return NULL_OBJECT_TABLE;
    }

    public static ClassTable nullClassTable() {
        return NULL_CLASS_TABLE;
    }

    public static OptionalDataException createOptionalDataException(boolean eof) {
        OptionalDataException optionalDataException = Marshalling.createOptionalDataException();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement[] copyStackTrace = new StackTraceElement[stackTrace.length - 1];
        System.arraycopy(stackTrace, 1, copyStackTrace, 0, copyStackTrace.length);
        optionalDataException.setStackTrace(copyStackTrace);
        optionalDataException.eof = eof;
        return optionalDataException;
    }

    public static OptionalDataException createOptionalDataException(int length) {
        OptionalDataException optionalDataException = Marshalling.createOptionalDataException();
        optionalDataException.length = length;
        return optionalDataException;
    }

    private static OptionalDataException createOptionalDataException() {
        return AccessController.doPrivileged(OPTIONAL_DATA_EXCEPTION_CREATE_ACTION);
    }

    public static Externalizer nullExternalizer() {
        return NULL_EXTERNALIZER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OptionalDataExceptionCreateAction
    implements PrivilegedAction<OptionalDataException> {
        private final Constructor<OptionalDataException> constructor = AccessController.doPrivileged(new PrivilegedAction<Constructor<OptionalDataException>>(){

            @Override
            public Constructor<OptionalDataException> run() {
                try {
                    Constructor<OptionalDataException> constructor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
                    constructor.setAccessible(true);
                    return constructor;
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodError(e.getMessage());
                }
            }
        });

        private OptionalDataExceptionCreateAction() {
        }

        @Override
        public OptionalDataException run() {
            try {
                return this.constructor.newInstance(Boolean.FALSE);
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error invoking constructor", e);
            }
        }
    }

    private static final class StaticStreamHeader
    implements StreamHeader,
    Serializable {
        private final byte[] headerBytes;
        private static final long serialVersionUID = 8465784729867667872L;

        public StaticStreamHeader(byte[] bytes) {
            this.headerBytes = bytes;
        }

        public void readHeader(ByteInput input) throws IOException {
            byte[] buf = new byte[this.headerBytes.length];
            Marshalling.readFully(input, buf);
            if (!Arrays.equals(buf, this.headerBytes)) {
                throw new StreamCorruptedException("Header is incorrect (expected " + Arrays.toString(this.headerBytes) + ", got " + Arrays.toString(buf) + ")");
            }
        }

        public void writeHeader(ByteOutput output) throws IOException {
            output.write(this.headerBytes);
        }

        public String toString() {
            return "static StreamHeader@" + Integer.toHexString(this.hashCode()) + " (" + this.headerBytes.length + " bytes)";
        }
    }
}

