/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Pair;

public class NioByteInput
extends InputStream
implements ByteInput {
    private final Queue<Pair<ByteBuffer, BufferReturn>> queue;
    private final InputHandler inputHandler;
    private boolean eof;
    private IOException failure;

    public NioByteInput(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
        this.queue = new ArrayDeque<Pair<ByteBuffer, BufferReturn>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(ByteBuffer buffer) {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            if (!this.eof && this.failure == null) {
                this.queue.add(Pair.create(buffer, null));
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(ByteBuffer buffer, BufferReturn bufferReturn) {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            if (!this.eof && this.failure == null) {
                this.queue.add(Pair.create(buffer, bufferReturn));
                this.notifyAll();
            } else {
                bufferReturn.returnBuffer(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEof() {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            this.eof = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushException(IOException e) {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            if (!this.eof) {
                this.failure = e;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Queue<Pair<ByteBuffer, BufferReturn>> queue = this.queue;
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            while (queue.isEmpty()) {
                if (this.eof) {
                    return -1;
                }
                this.checkFailure();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted on read()");
                }
            }
            Pair<ByteBuffer, BufferReturn> pair = queue.peek();
            ByteBuffer buf = pair.getA();
            BufferReturn bufferReturn = pair.getB();
            int v = buf.get() & 0xFF;
            if (buf.remaining() == 0) {
                if (bufferReturn != null) {
                    bufferReturn.returnBuffer(buf);
                }
                queue.poll();
                try {
                    this.inputHandler.acknowledge();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue() {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            Pair<ByteBuffer, BufferReturn> pair;
            while ((pair = this.queue.poll()) != null) {
                ByteBuffer buffer = pair.getA();
                BufferReturn ret = pair.getB();
                if (ret == null) continue;
                ret.returnBuffer(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        Queue<Pair<ByteBuffer, BufferReturn>> queue = this.queue;
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            Pair<ByteBuffer, BufferReturn> pair;
            while (queue.isEmpty()) {
                if (this.eof) {
                    return -1;
                }
                this.checkFailure();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted on read()");
                }
            }
            int total = 0;
            while (len > 0 && (pair = queue.peek()) != null) {
                ByteBuffer buffer = pair.getA();
                BufferReturn bufferReturn = pair.getB();
                int bytecnt = Math.min(buffer.remaining(), len);
                buffer.get(b, off, bytecnt);
                off += bytecnt;
                total += bytecnt;
                len -= bytecnt;
                if (buffer.remaining() != 0) continue;
                if (bufferReturn != null) {
                    bufferReturn.returnBuffer(buffer);
                }
                queue.poll();
                try {
                    this.inputHandler.acknowledge();
                }
                catch (IOException e) {}
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            int total = 0;
            for (Pair pair : this.queue) {
                if ((total += ((ByteBuffer)pair.getA()).remaining()) >= 0) continue;
                return Integer.MAX_VALUE;
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long qty) throws IOException {
        Queue<Pair<ByteBuffer, BufferReturn>> queue = this.queue;
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            Pair<ByteBuffer, BufferReturn> pair;
            while (queue.isEmpty()) {
                if (this.eof) {
                    return 0L;
                }
                this.checkFailure();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted on read()");
                }
            }
            long skipped = 0L;
            while (qty > 0L && (pair = queue.peek()) != null) {
                ByteBuffer buffer = pair.getA();
                BufferReturn bufferReturn = pair.getB();
                int bytecnt = Math.min(buffer.remaining(), (int)Math.max(Integer.MAX_VALUE, qty));
                buffer.position(buffer.position() + bytecnt);
                skipped += (long)bytecnt;
                qty -= (long)bytecnt;
                if (buffer.remaining() != 0) continue;
                queue.poll();
                if (bufferReturn != null) {
                    bufferReturn.returnBuffer(buffer);
                }
                try {
                    this.inputHandler.acknowledge();
                }
                catch (IOException e) {}
            }
            return skipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            if (!this.eof) {
                this.clearQueue();
                this.eof = true;
                this.notifyAll();
                this.inputHandler.close();
            }
        }
    }

    private void checkFailure() throws IOException {
        IOException failure = this.failure;
        if (failure != null) {
            failure.fillInStackTrace();
            try {
                throw failure;
            }
            catch (Throwable throwable) {
                this.eof = true;
                this.clearQueue();
                this.notifyAll();
                this.failure = null;
                throw throwable;
            }
        }
    }

    public static interface BufferReturn {
        public void returnBuffer(ByteBuffer var1);
    }

    public static interface InputHandler
    extends Closeable {
        public void acknowledge() throws IOException;

        public void close() throws IOException;
    }
}

