/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.serialization.jboss.DerivedStreamingClass;
import org.jboss.marshalling.serialization.jboss.JBossSerializationUnmarshaller;
import org.jboss.serial.classmetamodel.ClassDescriptorStrategy;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetaDataSlot;
import org.jboss.serial.classmetamodel.DefaultClassDescriptorStrategy;
import org.jboss.serial.classmetamodel.StreamingClass;
import org.jboss.serial.io.JBossObjectInputStreamSharedTree;
import org.jboss.serial.objectmetamodel.DefaultObjectDescriptorStrategy;
import org.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import org.jboss.serial.objectmetamodel.ObjectsCache;
import org.jboss.serial.util.HashStringUtil;
import org.jboss.serial.util.StringUtilBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSerializationInputStream
extends JBossObjectInputStreamSharedTree {
    private JBossSerializationUnmarshaller unmarshaller;
    private StreamHeader streamHeader;
    private ClassResolver classResolver;
    private ClassTable classTable;
    private ObjectResolver objectResolver;
    private ObjectTable objectTable;
    private Creator creator;
    private ThreadLocal<String> resolvedClassName = new ThreadLocal();
    private ThreadLocal<Class<?>> resolvedClass = new ThreadLocal();
    private boolean readyForStreamHeader;

    public JBossSerializationInputStream(JBossSerializationUnmarshaller unmarshaller, StreamHeader streamHeader, ClassResolver classResolver, ClassTable classTable, ObjectResolver objectResolver, ObjectTable objectTable, Creator creator, boolean jbossSerializationCompatible) throws IOException {
        super(unmarshaller.getInputStream(), new StringUtilBuffer(10024, 10024));
        this.unmarshaller = unmarshaller;
        this.streamHeader = streamHeader;
        this.classResolver = classResolver;
        this.classTable = classTable;
        this.objectResolver = objectResolver;
        this.objectTable = objectTable;
        this.creator = creator;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                JBossSerializationInputStream.this.enableResolveObject(true);
                return null;
            }
        });
        if (jbossSerializationCompatible) {
            this.setClassDescriptorStrategy((ClassDescriptorStrategy)new DefaultClassDescriptorStrategy());
            this.setObjectDescriptorStrategy((ObjectDescriptorStrategy)new DefaultObjectDescriptorStrategy());
        } else {
            this.setClassDescriptorStrategy((ClassDescriptorStrategy)new JBMClassDescriptorStrategy(unmarshaller, this, classTable, classResolver));
            this.setObjectDescriptorStrategy((ObjectDescriptorStrategy)new JBMObjectDescriptorStrategy((Unmarshaller)unmarshaller, this));
        }
        this.readyForStreamHeader = true;
    }

    public void clear() {
    }

    public Creator getCreator() {
        return this.creator;
    }

    public ObjectTable getObjectTable() {
        return this.objectTable;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    protected void completeConstruction() throws IOException {
        this.readStreamHeader();
    }

    protected void readStreamHeader() throws IOException {
        if (this.readyForStreamHeader) {
            if (this.streamHeader != null) {
                this.streamHeader.readHeader((ByteInput)this.unmarshaller);
            } else {
                super.readStreamHeader();
            }
        }
    }

    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = this.resolvedClassName.get();
        if (className != null && className.equals(desc.getName())) {
            return this.resolvedClass.get();
        }
        return super.resolveClass(desc);
    }

    protected Object resolveObject(Object obj) throws IOException {
        return this.objectResolver.readResolve(obj);
    }

    static class JBMObjectDescriptorStrategy
    extends DefaultObjectDescriptorStrategy {
        private Unmarshaller unmarshaller;
        private ClassResolver classResolver;
        private ObjectTable objectTable;
        private Creator creator;

        public JBMObjectDescriptorStrategy(Unmarshaller unmarshaller, JBossSerializationInputStream jbsis) {
            this.unmarshaller = unmarshaller;
            this.classResolver = jbsis.classResolver;
            this.objectTable = jbsis.objectTable;
            this.creator = jbsis.creator;
        }

        public Object readObjectSpecialCase(ObjectsCache.JBossSeralizationInputInterface input, ObjectsCache cache, byte byteIdentify) throws IOException {
            switch (byteIdentify) {
                case 110: {
                    try {
                        return this.objectTable.readObject(this.unmarshaller);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("class not found: " + e.getMessage());
                    }
                }
            }
            return super.readObjectSpecialCase(input, cache, byteIdentify);
        }

        public Object readObject(ObjectsCache.JBossSeralizationInputInterface input, ObjectsCache cache, StreamingClass streamingClass, int reference) throws IOException {
            byte tag = input.readByte();
            switch (tag) {
                case 116: {
                    try {
                        Externalizer externalizer = (Externalizer)this.unmarshaller.readObject();
                        Object result = externalizer.createExternal(streamingClass.getMetadata().getClazz(), (ObjectInput)input, this.creator);
                        externalizer.readExternal(result, (ObjectInput)input);
                        cache.putObjectInCacheRead(reference, result);
                        return result;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("class not found: " + e.getMessage());
                    }
                }
                case 112: {
                    if (this.classResolver != null) {
                        try {
                            InvocationHandler handler = (InvocationHandler)input.readObject();
                            Class<?> clazz = streamingClass.getClass();
                            Object obj = Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), handler);
                            cache.putObjectInCacheRead(reference, obj);
                            return obj;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException("class not found: " + e.getMessage());
                        }
                    }
                }
                case 111: {
                    return super.readObject(input, cache, streamingClass, reference);
                }
            }
            throw new IOException("unrecognized object type: " + tag);
        }
    }

    static class JBMClassDescriptorStrategy
    extends DefaultClassDescriptorStrategy {
        private JBossSerializationUnmarshaller unmarshaller;
        private JBossSerializationInputStream jbsis;
        private ClassTable classTable;
        private ClassResolver classResolver;

        public JBMClassDescriptorStrategy(JBossSerializationUnmarshaller unmarshaller, JBossSerializationInputStream jbsis, ClassTable classTable, ClassResolver classResolver) {
            this.unmarshaller = unmarshaller;
            this.jbsis = jbsis;
            this.classTable = jbsis.classTable;
            this.classResolver = jbsis.classResolver;
        }

        public StreamingClass readClassDescription(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input, org.jboss.serial.classmetamodel.ClassResolver passedClassResolver, String ignored) throws IOException {
            byte tag = input.readByte();
            switch (tag) {
                case 113: {
                    return null;
                }
                case 117: {
                    try {
                        return new DerivedStreamingClass(this.classTable.readClass((Unmarshaller)this.unmarshaller));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                case 114: {
                    if (this.classResolver != null) {
                        String className = input.readUTF();
                        try {
                            Class resolvedClass = this.classResolver.resolveClass((Unmarshaller)this.unmarshaller, className, -1L);
                            this.jbsis.resolvedClassName.set(className);
                            this.jbsis.resolvedClass.set(resolvedClass);
                            if (className.equals(resolvedClass.getName())) {
                                StreamingClass streamingClass = super.readClassDescription(cache, input, passedClassResolver, className);
                                this.jbsis.resolvedClassName.set(null);
                                return streamingClass;
                            }
                            StreamingClass streamingClass = super.readClassDescription(cache, input, passedClassResolver, className);
                            ClassMetaData metaData = streamingClass.getMetadata();
                            metaData.setClassName(resolvedClass.getName());
                            metaData.setClazz(resolvedClass);
                            metaData.setConstructor(resolvedClass.getConstructor(new Class[0]));
                            Long shaHash = HashStringUtil.hashName((String)resolvedClass.getName());
                            metaData.setShaHash(shaHash.longValue());
                            ClassMetaDataSlot slot = metaData.getSlots()[0];
                            slot.setSlotClass(resolvedClass);
                            slot.setShaHash(shaHash.longValue());
                            this.jbsis.resolvedClassName.set(null);
                            return streamingClass;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException(e.getMessage());
                        }
                        catch (NoSuchMethodException e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    return super.readClassDescription(cache, input, passedClassResolver, null);
                }
                case 115: {
                    if (this.classResolver != null) {
                        String[] interfaces = new String[input.readInt()];
                        for (int i = 0; i < interfaces.length; ++i) {
                            interfaces[i] = input.readUTF();
                        }
                        try {
                            Class clazz = this.classResolver.resolveProxyClass((Unmarshaller)this.unmarshaller, interfaces);
                            this.jbsis.resolvedClassName.set("PROXY");
                            this.jbsis.resolvedClass.set(clazz);
                            DerivedStreamingClass streamingClass = new DerivedStreamingClass(clazz);
                            this.jbsis.resolvedClassName.set(null);
                            return streamingClass;
                        }
                        catch (ClassNotFoundException e) {
                            StringBuffer sb = new StringBuffer(interfaces[0]);
                            for (int i = 1; i < interfaces.length; ++i) {
                                sb.append('|').append(interfaces[i]);
                            }
                            throw new IOException("unable to create proxy: " + sb.toString());
                        }
                    }
                    return super.readClassDescription(cache, input, passedClassResolver, null);
                }
            }
            throw new IOException("unrecognized class type: " + tag);
        }
    }
}

