/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.as.control.mojo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.maven.plugins.as.common.JbossAsRuntimeDelegate;
import org.jboss.maven.plugins.as.control.mojo.JbossAsControlAbstractMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JbossAsControlAbstractDeploymentMojo
extends JbossAsControlAbstractMojo {
    protected static final Log logger = LogFactory.getLog(JbossAsControlAbstractDeploymentMojo.class);
    protected static final String DELIMITER_DEPLOYABLE_FILES = ",";
    protected boolean runTests;
    protected String serverConfigName;
    protected String files;
    protected final JbossAsRuntimeDelegate delegate = new JbossAsRuntimeDelegate();
    protected static ClassLoader hackClassLoader;

    protected Set<File> getDeployableUnits() {
        LinkedHashSet<File> deployables = new LinkedHashSet<File>();
        String configuredFiles = this.getFiles();
        if (configuredFiles != null) {
            configuredFiles = configuredFiles.trim();
        }
        if (configuredFiles == null || configuredFiles.length() == 0) {
            throw new RuntimeException("Configured files must be specified for deployment");
        }
        StringTokenizer tokenizer = new StringTokenizer(configuredFiles, DELIMITER_DEPLOYABLE_FILES);
        while (tokenizer.hasMoreTokens()) {
            String deployable = tokenizer.nextToken();
            File file = new File(deployable);
            if (!file.exists()) {
                throw new RuntimeException("Configured file for deployment, " + deployable + ", does not exist.");
            }
            deployables.add(file);
        }
        return deployables;
    }

    protected ClassLoader getJbossClientClassLoader(ClassLoader oldLoader) {
        if (hackClassLoader == null) {
            String jbossClientPathName = this.delegate.getJbossHome() + "/client/jbossall-client.jar";
            File jbossClientPath = new File(jbossClientPathName);
            if (!jbossClientPath.exists() || jbossClientPath.isDirectory()) {
                throw new RuntimeException("Could not find JBossAS Client JAR located at " + jbossClientPathName + ", required for deploy.");
            }
            URL jbossClientURL = null;
            try {
                jbossClientURL = jbossClientPath.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            hackClassLoader = new URLClassLoader(new URL[]{jbossClientURL}, oldLoader);
        }
        return hackClassLoader;
    }

    public boolean isEnabled() {
        return this.runTests;
    }

    public String getServerConfigName() {
        return this.serverConfigName;
    }

    public void setServerConfigName(String serverConfigName) {
        this.serverConfigName = serverConfigName;
    }

    public String getFiles() {
        return this.files;
    }

    public void setFiles(String files) {
        this.files = files;
    }
}

