/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.as.control.mojo;

import java.io.File;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.jbossas.servermanager.Server;
import org.jboss.jbossas.servermanager.ServerManager;
import org.jboss.maven.plugins.as.control.mojo.JbossAsControlAbstractDeploymentMojo;

public class JbossAsControlDeployMojo
extends JbossAsControlAbstractDeploymentMojo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String name;
        if (!this.isEnabled()) {
            logger.info((Object)"Skipping Deploy to JBossAS, to enable set \"jboss.test.run\".");
            return;
        }
        ServerManager manager = this.delegate.getServerManager();
        Server server = manager.getServer(name = this.getServerConfigName());
        if (server == null) {
            throw new MojoExecutionException("Could not deploy into specified server \"" + name + "\": was not found running");
        }
        Set<File> deployables = this.getDeployableUnits();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = this.getJbossClientClassLoader(oldLoader);
        Thread.currentThread().setContextClassLoader(newLoader);
        try {
            for (File file : deployables) {
                try {
                    server.deploy(file);
                    logger.info((Object)("Deployed " + file.toString() + " to JBossAS instance \"" + name + "\""));
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Could not deploy " + file.toString(), e);
                    return;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }
}

