/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.as.control.mojo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.jbossas.servermanager.Server;
import org.jboss.maven.plugins.as.common.JbossAsRuntimeDelegate;
import org.jboss.maven.plugins.as.control.mojo.JbossAsControlAbstractMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbossAsControlStopMojo
extends JbossAsControlAbstractMojo {
    private static final Log logger = LogFactory.getLog(JbossAsControlStopMojo.class);
    private boolean runTests;
    private List<String> jvmArgs = new ArrayList<String>();
    private final JbossAsRuntimeDelegate delegate = new JbossAsRuntimeDelegate();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isEnabled()) {
            logger.info((Object)"Skipping JBossAS Stop, to enable set \"jboss.test.run\".");
            return;
        }
        List servers = this.delegate.getServerManager().getServers();
        if (servers.size() == 0) {
            logger.info((Object)"No servers registered as running, exiting...");
            return;
        }
        if (servers.size() > 1) {
            throw new MojoExecutionException("Cannot stop AS; more than one server is registered as running: " + servers);
        }
        String name = ((Server)servers.get(0)).getName();
        try {
            this.delegate.stopJbossAs(name);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error in stopping server with name \"" + name + "\"", (Exception)ioe);
        }
    }

    public boolean isEnabled() {
        return this.runTests;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }
}

