/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.maven.plugins.thirdparty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 
 * A ComponentInfo.
 * 
 * @author Paul Gier
 * @version $Revision: 114 $
 */
public class ComponentInfo
{
   
   /**
    * This is the list of artifacts in the component-info file.
    * 
    * <artifact id="proj-artifact1.jar"/>
    * <artifact id="proj-artifact1-sources.jar"/>
    * <artifact id="proj-artifact2.jar"/>
    * 
    */
   private List artifactIds = new ArrayList();
   
   /**
    * This is the list of artifacts in the component-info file.
    * 
    * <pre>
    * &lt;exports&gt;
    * &nbsp;&lt;include input="proj-artifact1.jar"/&gt;
    * &nbsp;&lt;include input="proj-artifact1.jar"/&gt;
    * &lt;/exports&gt;
    * </pre>
    * 
    */
   private Set exports = new HashSet();
   
   /**
    * This is the map of components that this project depends on.  If generateImports is set
    * to true, the generated imports will be appended to the imports specified here.
    */
   private Map imports = new HashMap();

   /**
    * The id of this component.
    */
   private String componentId = "";

   /**
    * Source control information.
    * 
    */
   private String scm = "";

   private String description = "";
   
   /**
    * Name of license to add to component-info.xml.
    */
   private String license = "";

   private String projectName = "";
   
   private String version = "";
   
   /**
    * If no project name has been set, this will default 
    * to the componentId with "-component-info" appended.
    * 
    * @return the component info project name
    */
   public String getProjectName()
   {
      if (projectName == null)
      {
         projectName = componentId + "-component-info";
      }
      return projectName;
   }

   public void setProjectName(String projectName)
   {
      this.projectName = projectName;
   }

   public String getVersion()
   {
      return version;
   }

   public void setVersion(String version)
   {
      this.version = version;
   }
      
   public boolean addExport(String export)
   {
      return exports.add(export);
   }
   
   public Set getExports()
   {
      return exports;
   }

   public void setExports(Set exports)
   {
      this.exports = exports;
   }

   public void addImport(String componentRef, String versions)
   {
      imports.put(componentRef, versions);
   }
   
   public Map getImports()
   {
      return imports;
   }

   public void setImports(Map imports)
   {
      this.imports = imports;
   }

   public String getComponentId()
   {
      return componentId;
   }

   /**
    * Takes a dot or slash delimited componentId.  Automatically convert dots to slashes.
    * This is similar to a maven groupId.
    * 
    * @param componentId
    */
   public void setComponentId(String componentId)
   {
      this.componentId = componentId.replace( '.', '/' );
   }

   public String getScm()
   {
      return scm;
   }

   public void setScm(String scm)
   {
      this.scm = scm;
   }

   public String getLicense()
   {
      return license;
   }

   public void setLicense(String license)
   {
      this.license = license;
   }

   public String toString()
   {
      StringBuffer compInfoString = new StringBuffer( );
      compInfoString.append(componentId + "-" + version);
      return compInfoString.toString();
   }
   
   public boolean addArtifactId( String artifactId )
   {
      return artifactIds.add( artifactId );
   }
   
   public boolean containsArtifactId( String artifactId )
   {
      return artifactIds.contains( artifactId );
   }
   
   public List getArtifactIds()
   {
      return artifactIds;
   }

   public void setArtifactIds(List artifactIds)
   {
      this.artifactIds = artifactIds;
   }

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   /**
    * Removed the slashes and dashes from the componentId.  Replaces with dots.
    * 
    * @return
    */
   public String getLibrariesEntCompId()
   {
      String libEntCompId = this.getComponentId().replace('-', '.').replace( '/', '.' );
      if ( ! libEntCompId.contains( "." ) )
      {
         libEntCompId += "." + libEntCompId;
      }
      return libEntCompId;
   }
   

}
