/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.maven.plugins.thirdparty;

import org.apache.maven.artifact.Artifact;

/**
 * 
 * A Dependency mapping between maven dependencies and third party dependencies.
 * 
 * @author Paul Gier
 * @version $Revision: 97 $
 */
public class Dependency extends org.apache.maven.model.Dependency
{
   private Mapping mapping = new Mapping();
   
   private boolean exportArtifact = true;

   public Dependency()
   {

   }
   
   public Dependency( Artifact artifact )
   {
      setGroupId( artifact.getGroupId() );
      setArtifactId( artifact.getArtifactId() );
      setVersion( artifact.getVersion() );
      setClassifier( artifact.getClassifier() );
   }
   
   public Mapping getMapping()
   {
      return mapping;
   }

   public void setMapping(Mapping mapping)
   {
      this.mapping = mapping;
   }
   
   public String getComponentId()
   {
      if ( mapping.getComponentId() == null )
      {
         mapping.setComponentId( getGroupId() );
      }
      return mapping.getComponentId();
   }
   
   public void setComponentId(String componentId)
   {
      mapping.setComponentId(componentId);
   }
   
   public String getComponentVersion()
   {
      if ( mapping.getVersion() == null )
      {
         mapping.setVersion( this.getVersion() );
      }
      return mapping.getVersion();
   }
   
   public String getCompArtifactId()
   {
      if ( mapping.getArtifactId() == null )
      {
         String compArtifactId = getArtifactId();
         if ( getClassifier() != null )
         {
            compArtifactId = compArtifactId + "-" + getClassifier();
         }
         mapping.setArtifactId( compArtifactId );
      }
      return mapping.getArtifactId();
   }
   
   public boolean equals( Object dependency )
   {
      if ( ! (dependency instanceof Dependency) )
      {
         return false;
      }
      Dependency compare = (Dependency)dependency;
      
      if ( ! this.getGroupId().equals( compare.getGroupId() ) )
      {
         return false;
      }
      if ( ! this.getArtifactId().equals( compare.getArtifactId() ) )
      {
         return false;
      }
      if ( ( getClassifier() == null ) && ( compare.getClassifier() != null ) )
      {
         return false;
      }
      else if ( ! this.getClassifier().equals( compare.getClassifier() ) )
      {
         return false;
      }
      
      return true;
   }
   
   /**
    * Get an id for determining the appropriate thirdparty artifact
    * 
    * @return
    */
   public String getResolutionId()
   {
      StringBuffer resId = new StringBuffer();
      resId.append( getGroupId() + ":" + getArtifactId() );
      if ( getClassifier() != null )
      {
         resId.append( ":" + getClassifier() );
      }
      return resId.toString();
   }
   
   public int hashCode()
   {
      return getResolutionId().hashCode();
   }

   /**
    * Determines whether the artifact should be in the list of exports
    * in the component-info.xml file.
    * 
    * @return
    */
   public boolean isExportArtifact()
   {
      return exportArtifact;
   }

   public void setExportArtifact(boolean exportArtifact)
   {
      this.exportArtifact = exportArtifact;
   }
}
