/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.maven.plugins.thirdparty.util;

public class FileUtil
{
   /**
    * Remove the filename extension.
    * 
    * @param filename
    * @return The file name without the extension
    */
   public static String removeFileExtension( String filename )
   {
      // Create the artifact metadata
      int extIndex = filename.lastIndexOf('.');
      return filename.substring(0, extIndex);
   }
   
   public static String removeSourceQualifier( String filename )
   {
      return filename.replace("-sources", "").replace("-src", "");
   }
   
   /**
    * Get the filename extension (everything after the ".")
    * 
    * @param filename
    * @return
    */
   public static String getFileExtension( String filename )
   {
      int extIndex = filename.lastIndexOf('.');
      return filename.substring(extIndex + 1);
   }
   

}
