package org.jboss.maven.plugins.thirdparty.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.Deflater;

import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class JarUtil
{

   public static List getJarEntries(File basedir) throws IOException
   {
      String [] includes = {"**"};
      String [] excludes = null;
      return getJarEntries(basedir, includes, excludes);
   }
   
   public static List getJarEntries(File basedir, String [] includes, String [] excludes) throws IOException
   {
      List fileEntries = new ArrayList ();
      
      DirectoryScanner scanner = new DirectoryScanner();
      scanner.setBasedir( basedir );
      scanner.setIncludes( includes );
      scanner.setExcludes( excludes );
      scanner.addDefaultExcludes();
      scanner.scan();
      String [] filenames = scanner.getIncludedFiles();
      
      for (int i=0; i<filenames.length; ++i )
      {
         String fileContents = FileUtils.fileRead( new File(basedir, filenames[i] ) );
         byte [] fileData = IOUtil.toByteArray( fileContents );
         fileEntries.add(new JarFileEntry(filenames[i], fileData));
      }
      return fileEntries;
   }
   
   /**
    * Create a jar file from a List of JarFileEntry 
    * 
    * @param jarFileEntries List of files to add the the jar
    * @param outputJar Path to jar file
    * @throws IOException
    */
   public static void writeJarFile(List jarFileEntries, File outputJar) throws IOException
   {
      Manifest manifest = new Manifest();
      Attributes attributes = manifest.getMainAttributes();
      attributes.putValue("Manifest-Version", "1.0");
      attributes.putValue("Created-By", System.getProperty("java.vm.version") + " ("
            + System.getProperty("java.vm.vendor") + ")");
      JarOutputStream stream = new JarOutputStream(new FileOutputStream(outputJar), manifest);
      stream.setLevel(Deflater.BEST_COMPRESSION);
      Iterator entryIter = jarFileEntries.iterator();
      while ( entryIter.hasNext() )
      {
         JarFileEntry entry = (JarFileEntry)entryIter.next();
         JarEntry jarEntry = new JarEntry(entry.getName());
         stream.putNextEntry(jarEntry);
         stream.write(entry.getContent());
      }
      stream.close();
   }
   
   public static void extractJarFile(File jarFile, File outputDirectory) throws IOException
   {
      JarFile theJarFile = new JarFile(jarFile);
      Enumeration entries = theJarFile.entries();
      while (entries.hasMoreElements())
      {
         JarEntry entry = (JarEntry)entries.nextElement();
         
         if ( entry.isDirectory() || entry.getName().startsWith("META-INF") )
         {
            continue;
         }
         
         InputStream jis = theJarFile.getInputStream( entry );
         File outFile = new File( outputDirectory, entry.getName() );
         
         if ( outFile.getParentFile().isFile() )
         {
            outFile.getParentFile().delete();
         }
         if ( ! outFile.getParentFile().exists() )
         {
            FileUtils.mkdir( outFile.getParentFile().getAbsolutePath() );
         }
         
         FileOutputStream out = new FileOutputStream( outFile );
         IOUtil.copy( jis, out );
         jis.close();
         out.close();
      }
      
   }

}
