/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.thirdparty;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.maven.plugins.thirdparty.ComponentInfo;
import org.jboss.maven.plugins.thirdparty.ComponentInfoWriter;
import org.jboss.maven.plugins.thirdparty.Dependency;
import org.jboss.maven.plugins.thirdparty.util.JarUtil;

public class BuildThirdpartyMojo
extends AbstractMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    protected MavenProject project;
    private boolean skip;
    private File outputDirectory;
    private File thirdpartyResources;
    private Set resourceIncludes;
    private Set resourceExcludes;
    private boolean copyResources;
    private boolean copySources;
    private Set mappedDependencies;
    private List includedScopes;
    private File librariesEnt;
    private File aliasesEnt;
    private Map groupIdTranslations = new HashMap();

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Executing build thirdparty mojo");
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        if (this.includedScopes == null || this.includedScopes.size() == 0) {
            this.includedScopes = new ArrayList();
            this.includedScopes.add("compile");
        }
        HashMap<String, Dependency> tpDepNameMap = new HashMap<String, Dependency>();
        for (Dependency dep : this.mappedDependencies) {
            tpDepNameMap.put(dep.getResolutionId(), dep);
            if (!dep.getArtifactId().equals("*")) continue;
            this.groupIdTranslations.put(dep.getGroupId(), dep.getComponentId());
        }
        Map compInfoMap = this.copyDependenciesAndGenrateCompInfo(tpDepNameMap);
        this.getLog().info((CharSequence)"Generating component info files...");
        try {
            ComponentInfoWriter.loadTemplate();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to load componentInfo template.", (Exception)e);
        }
        for (String componentId : compInfoMap.keySet()) {
            ComponentInfo compInfo = (ComponentInfo)compInfoMap.get(componentId);
            File compInfoDir = new File(this.outputDirectory, componentId);
            File compInfoFile = new File(compInfoDir, "component-info.xml");
            try {
                ComponentInfoWriter.writeComponentInfo(compInfo, compInfoFile);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to write comp info file: " + compInfoFile));
                this.getLog().warn((Throwable)e);
            }
        }
        if (this.copyResources) {
            try {
                this.copyResources(this.thirdpartyResources, this.outputDirectory);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to copy resources folder: " + this.thirdpartyResources));
                this.getLog().warn((Throwable)e);
            }
        }
        try {
            this.generateLibrariesEnt(compInfoMap);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Problem writing libraries ent file: " + this.librariesEnt));
            this.getLog().warn((Throwable)e);
        }
    }

    private Map copyDependenciesAndGenrateCompInfo(Map tpDepNameMap) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Copying dependencies to thirdparty directories...");
        HashMap<String, ComponentInfo> compInfoMap = new HashMap<String, ComponentInfo>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (artifact.getScope() == null) {
                artifact.setScope("compile");
            }
            if (!this.includedScopes.contains(artifact.getScope())) {
                this.getLog().debug((CharSequence)("artifact not included: " + artifact));
                continue;
            }
            File mavenArtifactFile = artifact.getFile();
            String artifactResId = this.getDependencyResolutionId(artifact);
            Dependency tpdependency = (Dependency)((Object)tpDepNameMap.get(artifactResId));
            if (tpdependency == null) {
                tpdependency = new Dependency(artifact);
                if (this.groupIdTranslations.containsKey(artifact.getGroupId())) {
                    tpdependency.setComponentId((String)this.groupIdTranslations.get(artifact.getGroupId()));
                }
            } else if (tpdependency.getVersion() == null) {
                tpdependency.setVersion(artifact.getVersion());
            }
            String componentId = tpdependency.getComponentId();
            File componentLibDir = new File(this.outputDirectory, tpdependency.getComponentId() + "/lib/");
            componentLibDir.mkdirs();
            if (artifact.getArtifactId().equals("resources")) {
                File componentDir = new File(this.outputDirectory, tpdependency.getComponentId());
                try {
                    JarUtil.extractJarFile(artifact.getFile(), componentDir);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Unable to extract resources artifact: " + artifact));
                    this.getLog().warn((Throwable)e);
                }
                continue;
            }
            String fileExt = this.getFileExtension(mavenArtifactFile);
            String compInfoArtifactId = tpdependency.getCompArtifactId() + "." + fileExt;
            File thirdpartyJarFile = new File(componentLibDir, compInfoArtifactId);
            ComponentInfo compInfo = (ComponentInfo)compInfoMap.get(componentId);
            if (compInfo == null) {
                compInfo = new ComponentInfo();
                compInfo.setComponentId(componentId);
                compInfo.setVersion(tpdependency.getComponentVersion());
            }
            compInfo.addArtifactId(compInfoArtifactId);
            if (tpdependency.isExportArtifact()) {
                compInfo.addExport(compInfoArtifactId);
            }
            compInfoMap.put(componentId, compInfo);
            try {
                this.getLog().debug((CharSequence)("Copying: " + mavenArtifactFile));
                this.getLog().debug((CharSequence)("to: " + thirdpartyJarFile));
                if (mavenArtifactFile.length() != thirdpartyJarFile.length()) {
                    FileUtils.copyFile((File)mavenArtifactFile, (File)thirdpartyJarFile);
                }
                if (!this.copySources) continue;
                String fileExtension = this.getFileExtension(mavenArtifactFile.getName());
                String sourceJarName = mavenArtifactFile.getName().replace("." + fileExtension, "-sources." + fileExtension);
                File sourceJarFile = new File(mavenArtifactFile.getParentFile(), sourceJarName);
                if (!sourceJarFile.exists()) continue;
                String tpSourceFileName = tpdependency.getCompArtifactId() + "-sources." + fileExtension;
                File thirdpartySourceJar = new File(componentLibDir, tpSourceFileName);
                if (sourceJarFile.length() == thirdpartySourceJar.length()) continue;
                FileUtils.copyFile((File)sourceJarFile, (File)thirdpartySourceJar);
            }
            catch (IOException e) {
                throw new MojoExecutionException(" Unable to copy artifact: " + e, (Exception)e);
            }
        }
        return compInfoMap;
    }

    public void copyResources(File resourceDirectory, File outputDirectory) throws IOException {
        if (!resourceDirectory.exists()) {
            this.getLog().debug((CharSequence)("Resource directory does not exist: " + resourceDirectory));
            return;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDirectory);
        if (this.resourceIncludes == null || this.resourceIncludes.isEmpty()) {
            scanner.setIncludes(DEFAULT_INCLUDES);
        } else {
            scanner.setIncludes(this.resourceIncludes.toArray(EMPTY_STRING_ARRAY));
        }
        if (this.resourceExcludes != null && !this.resourceExcludes.isEmpty()) {
            scanner.setExcludes(this.resourceExcludes.toArray(EMPTY_STRING_ARRAY));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
        Iterator<String> j = includedFiles.iterator();
        while (j.hasNext()) {
            String name;
            String destination = name = j.next();
            File source = new File(resourceDirectory, name);
            File destinationFile = new File(outputDirectory, destination);
            if (!destinationFile.getParentFile().exists()) {
                destinationFile.getParentFile().mkdirs();
            }
            FileUtils.copyFileIfModified((File)source, (File)destinationFile);
        }
    }

    public void generateLibrariesEnt(Map compInfoMap) throws IOException {
        this.getLog().info((CharSequence)("Creating " + this.librariesEnt.getName() + "..."));
        FileWriter fw = new FileWriter(this.librariesEnt);
        Set compInfoIds = compInfoMap.keySet();
        ArrayList compInfoIdList = new ArrayList();
        compInfoIdList.addAll(compInfoIds);
        Collections.sort(compInfoIdList);
        for (int i = 0; i < compInfoIdList.size(); ++i) {
            ComponentInfo compInfo = (ComponentInfo)compInfoMap.get(compInfoIdList.get(i));
            fw.write(ComponentInfoWriter.getLibrariesEntEntry(compInfo));
        }
        if (this.aliasesEnt != null && this.aliasesEnt.isFile()) {
            BufferedReader aliasesReader = new BufferedReader(new FileReader(this.aliasesEnt));
            String line = "";
            while ((line = aliasesReader.readLine()) != null) {
                fw.write(line + "\n");
            }
            aliasesReader.close();
        }
        fw.close();
    }

    private String getFileExtension(File file) {
        return this.getFileExtension(file.getName());
    }

    private String getFileExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0) {
            return fileName.substring(lastDot + 1);
        }
        return "";
    }

    private String getDependencyResolutionId(Artifact artifact) {
        StringBuffer id = new StringBuffer();
        id.append(artifact.getGroupId());
        id.append(":");
        id.append(artifact.getArtifactId());
        if (artifact.getClassifier() != null) {
            id.append(":" + artifact.getClassifier());
        }
        return id.toString();
    }
}

