/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jboss.maven.plugins.deploy.CompInfoVerifier;
import org.xml.sax.SAXException;

public class JBossDeployMojo
extends AbstractMojo {
    private static String fileSep = System.getProperty("file.separator");
    protected MavenProject project;
    private Scm scm;
    private List pomLicenses;
    private String license;
    protected Properties projectProperties;
    private String jbossDeployRoot;
    private boolean generateImports;
    private Map imports;
    private String groupId;
    private Set<String> exports;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Executing JBoss deploy plugin");
        if ((this.project.getArtifact() == null || this.project.getArtifact().getFile() == null) && this.project.getAttachedArtifacts().size() == 0) {
            this.getLog().info((CharSequence)("No artifacts to deploy for project:" + this.project.getName()));
            return;
        }
        if (this.exports == null) {
            this.exports = new HashSet<String>();
        }
        if (this.groupId == null || this.groupId.equals("")) {
            this.groupId = this.project.getGroupId();
        }
        String groupIdPath = this.groupId.replace('.', '/');
        File deployToDir = new File(this.jbossDeployRoot + fileSep + groupIdPath + fileSep + this.project.getArtifactId() + fileSep + this.project.getVersion() + fileSep);
        File deployToLibDir = new File(deployToDir.getAbsolutePath() + fileSep + "lib" + fileSep);
        InputStream templateInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("component-info-template.txt");
        if (templateInputStream == null) {
            this.getLog().error((CharSequence)"Unable to load template file");
            return;
        }
        StringBuffer compInfoTemplate = new StringBuffer();
        try {
            compInfoTemplate.append(IOUtils.toString((InputStream)templateInputStream));
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)"Unable to load component info template.");
            this.getLog().error((CharSequence)ioe.toString());
            throw new MojoExecutionException(ioe.getMessage());
        }
        String componentId = groupIdPath + "/" + this.project.getArtifactId();
        this.evaluateVariable(compInfoTemplate, "project.name", componentId + "-component-info");
        this.evaluateVariable(compInfoTemplate, "component.id", componentId);
        this.evaluateVariable(compInfoTemplate, "project.version", this.project.getVersion());
        if (this.license != null && !this.license.equals("")) {
            this.evaluateVariable(compInfoTemplate, "project.license", this.license);
        } else if (this.pomLicenses.size() == 0) {
            this.getLog().warn((CharSequence)"No license specified.  Default lgpl license will be used.");
            this.evaluateVariable(compInfoTemplate, "project.license", "lgpl");
        } else {
            License firstLicense = (License)this.pomLicenses.get(0);
            this.evaluateVariable(compInfoTemplate, "project.license", firstLicense.getName());
        }
        if (this.project.getDescription() == null || this.project.getDescription().equals("")) {
            this.project.setDescription(this.project.getId());
        }
        this.evaluateVariable(compInfoTemplate, "project.description", this.project.getDescription());
        if (this.scm == null || this.scm.getConnection() == null) {
            this.evaluateVariable(compInfoTemplate, "project.scm", "");
        } else {
            String scmConnStr = this.scm.getConnection().replaceFirst("scm:", "");
            this.evaluateVariable(compInfoTemplate, "project.scm", "scm=\"" + scmConnStr + "\"");
        }
        HashSet<String> artifactSet = new HashSet<String>();
        Artifact projectArtifact = this.project.getArtifact();
        if (projectArtifact != null && projectArtifact.getFile() != null) {
            artifactSet.add("    <artifact id=\"" + projectArtifact.getFile().getName() + "\"/>\n");
            try {
                this.getLog().debug((CharSequence)("Deploying file://" + deployToLibDir + fileSep + projectArtifact.getFile().getName()));
                FileUtils.copyFileToDirectory((File)projectArtifact.getFile(), (File)deployToLibDir);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Problem copying artifact: " + ioe.getMessage());
            }
        }
        List list = this.project.getAttachedArtifacts();
        this.getLog().debug((CharSequence)("Number of attached artifacts: " + list.size()));
        for (Object artifactObj : list) {
            String artifactLine;
            Artifact artifact = (Artifact)artifactObj;
            this.getLog().debug((CharSequence)("Attaching artifact: " + artifact.getArtifactId()));
            String classifierStr = artifact.getClassifier();
            if (classifierStr == null) {
                classifierStr = "";
                if (artifact.getArtifactId().equals(this.project.getArtifactId())) {
                    this.exports.add(artifact.getArtifactId() + "." + artifact.getType());
                }
                if (this.project.getArtifact() != null) {
                    this.getLog().warn((CharSequence)"Attached artifact with same name as default artifact.");
                    this.getLog().warn((CharSequence)"This could be caused by an assembly descriptor with no id.");
                }
            }
            if (artifactSet.contains(artifactLine = "    <artifact id=\"" + artifact.getFile().getName() + "\"/>\n")) {
                this.getLog().warn((CharSequence)("Duplicate attached artifact found: " + artifact.getFile().getName() + ".jar"));
            }
            artifactSet.add(artifactLine);
            try {
                this.getLog().debug((CharSequence)("Deploying file://" + deployToLibDir + fileSep + artifact.getFile().getName()));
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)deployToLibDir);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Problem copying artifact: " + ioe.getMessage());
            }
        }
        StringBuffer artifacts = new StringBuffer();
        for (String line : artifactSet) {
            artifacts.append(line);
        }
        this.evaluateVariable(compInfoTemplate, "artifacts", artifacts.toString());
        StringBuffer exportsString = new StringBuffer();
        if (this.project.getArtifact().getFile() != null) {
            this.exports.add(this.project.getArtifact().getFile().getName());
        }
        for (String export : this.exports) {
            exportsString.append("      <include input=\"" + export + "\"/>\n");
        }
        this.evaluateVariable(compInfoTemplate, "includes", exportsString.toString());
        this.evaluateVariable(compInfoTemplate, "imports", this.generateImportsString());
        File compInfoFile = new File(deployToDir + fileSep + "component-info.xml");
        try {
            if (!deployToDir.exists()) {
                deployToDir.mkdirs();
            }
            FileWriter fw = new FileWriter(compInfoFile);
            this.getLog().info((CharSequence)("Deploying file: " + compInfoFile.getCanonicalPath()));
            fw.write(compInfoTemplate.toString());
            fw.close();
        }
        catch (IOException ioe) {
            this.getLog().error((Throwable)ioe);
        }
        CompInfoVerifier verifier = new CompInfoVerifier();
        try {
            verifier.verifyCompInfo(new FileInputStream(compInfoFile));
        }
        catch (SAXException e) {
            this.getLog().warn((Throwable)e);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    private String generateImportsString() {
        StringBuffer importsString = new StringBuffer();
        if (this.imports != null) {
            Set componentNames = this.imports.keySet();
            for (Object component : componentNames) {
                String[] versions;
                importsString.append("    <import componentref=\"" + component.toString().replace('.', '/') + "\">\n");
                String componentVersions = this.imports.get(component).toString();
                for (String version : versions = componentVersions.split(",")) {
                    importsString.append("      <compatible version=\"" + version.trim() + "\"/>\n");
                }
                importsString.append("    </import>\n");
            }
        }
        if (this.generateImports) {
            List dependencies = this.project.getDependencies();
            for (Object obj : dependencies) {
                Dependency dep = (Dependency)obj;
                if (dep.getScope() != null && dep.getScope().equals("test")) continue;
                importsString.append("    <import componentref=\"" + dep.getGroupId().replace('.', '/') + "/" + dep.getArtifactId() + "\">\n");
                importsString.append("      <compatible version=\"" + dep.getVersion() + "\"/>\n");
                importsString.append("    </import>\n");
            }
        }
        return importsString.toString();
    }

    public void evaluateVariable(StringBuffer buffer, String var, String value) {
        int start = 0;
        while ((start = buffer.indexOf("${" + var + "}")) != -1) {
            int end = start + ("${" + var + "}").length();
            buffer.replace(start, end, value);
        }
    }
}

